/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.cache;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.cache.LSIDCacheException;
import com.ibm.lsid.client.cache.LSIDCachingInputStream;
import com.ibm.lsid.client.cache.LSIDCachingInputStreamListener;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LSIDCache
implements Comparator {
    public static final String DEFAULT_CACHE_DIR_WIN32 = "/lsid-client/cache";
    public static final String DEFAULT_CACHE_DIR_UNIX = "~/.lsid-client/cache";
    public static final String CACHE_CONFIG_FILE = "lsid-cache.properties";
    public static final String CACHE_DIR_PROPERTY = "LSID_CACHE_DIR";
    public static final String MAX_CACHE_SIZE = "max-cache-size";
    public static final String MAX_CACHE_LIFETIME = "max-cache-lifetime";
    public static final String MAX_CACHE_SIZE_HIGH = "max-cache-size-high";
    public static final String MAX_CACHE_LIFETIME_HIGH = "max-cache-lifetime-high";
    public static final String LOGGING_ON = "logging-on";
    public static final String MANGLE_CASE = "mangle-case";
    public static final String LOG_FILE = "log-file";
    private static final String STD_ERR = "std-err";
    private static final String DATA_EXT = "tmp";
    private static final String EXPIRATION_FILENAME = "EXPIRES";
    private static final String COMPLETE_FILE = "complete.tmp";
    private static final Hashtable METADATA_TYPE_2_EXTENSION = new Hashtable();
    private static final String[] ALL_FORMATS = new String[]{"application/xml+rdf", "application/xml+xmi", "application/octet-stream", null};
    private static final SimpleDateFormat LOG_DATE_FORMAT;
    private int maxCacheSize = -1;
    private int maxCacheLifetime = -1;
    private boolean loggingOn = false;
    private String logFile = "std-err";
    private int mangleCase = 0;
    private static final int MANGLE_SYSTEM = 0;
    private static final int MANGLE_ON = 1;
    private static final int MANGLE_SHA1 = 2;
    private static final int MANGLE_OFF = -1;
    private static File cacheDir;
    private PrintWriter logFileWriter;
    private static LSIDCache singletonInstance;

    public static synchronized LSIDCache load() throws LSIDCacheException {
        File file;
        String string = System.getProperty(CACHE_DIR_PROPERTY);
        boolean bl = true;
        if (singletonInstance != null && string != null) {
            file = new File(string);
            boolean bl2 = bl = !file.equals(cacheDir);
        }
        if (bl) {
            char c;
            file = null;
            file = string == null ? ((c = File.separatorChar) == '/' ? new File(DEFAULT_CACHE_DIR_UNIX) : new File(DEFAULT_CACHE_DIR_WIN32)) : new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            singletonInstance = new LSIDCache(null, file);
        }
        return singletonInstance;
    }

    public static String getLocation() {
        try {
            return cacheDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            System.err.println("Error canonicalizing path to cache dir: " + cacheDir.toString());
            iOException.printStackTrace();
            return iOException.toString();
        }
    }

    public String getLogFileName() {
        return this.logFile;
    }

    public LSIDWSDLWrapper readWSDL(LSIDAuthority lSIDAuthority, LSID lSID) throws LSIDException {
        String string = null;
        string = lSID != null ? this.canonicalizeFilename(lSID.toString()) : "authority";
        string = string + ".wsdl";
        File file = new File(cacheDir, "/wsdl/" + lSIDAuthority + "/" + string);
        if (!file.exists()) {
            return null;
        }
        Hashtable hashtable = this.loadExpirationEntries(file.getParentFile());
        if (LSIDCache.fileExpired(hashtable, string)) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            LSIDWSDLWrapper lSIDWSDLWrapper = new LSIDWSDLWrapper(fileInputStream);
            long l = LSIDCache.getExpiration(hashtable, string);
            if (l != -1L) {
                lSIDWSDLWrapper.setExpiration(new Date(l));
            }
            if (this.getLoggingOn()) {
                if (lSID != null) {
                    this.logOpenClose(new File(cacheDir, "/wsdl/" + lSIDAuthority), "Read WSDL for " + lSID);
                } else {
                    this.logOpenClose(new File(cacheDir, "/wsdl/" + lSIDAuthority), "Read WSDL for " + lSIDAuthority);
                }
            }
            LSIDWSDLWrapper lSIDWSDLWrapper2 = lSIDWSDLWrapper;
            return lSIDWSDLWrapper2;
        }
        catch (IOException iOException) {
            throw new LSIDCacheException(iOException, "Error reading WSDL cache file: " + string);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new LSIDCacheException(iOException, "Error closing WSDL cache file: " + string);
            }
        }
    }

    public synchronized InputStream readData(LSID lSID, int n, int n2) throws LSIDCacheException {
        Object object;
        File file = new File(cacheDir, "/data/" + this.canonicalizeFilename(lSID.toString()));
        File file2 = new File(file, COMPLETE_FILE);
        if (file2.exists()) {
            try {
                if (this.getLoggingOn()) {
                    this.logOpenClose(file, "Read data for " + lSID);
                }
                FileInputStream fileInputStream = new FileInputStream(file2);
                if (n != -1) {
                    fileInputStream.skip(n);
                }
                return fileInputStream;
            }
            catch (IOException iOException) {
                throw new LSIDCacheException(iOException, "Error opening data cache file " + file2);
            }
        }
        if (n == -1 && n2 == -1) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        File file3 = null;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < fileArray.length) {
            object = fileArray[n5].getName();
            if (((String)object).startsWith("range")) {
                int n6 = ((String)object).lastIndexOf(95);
                n3 = Integer.parseInt(((String)object).substring(6, n6));
                n4 = Integer.parseInt(((String)object).substring(n6 + 1, ((String)object).indexOf(46)));
                if (n3 <= n && n3 + n4 >= n + n2) {
                    file3 = fileArray[n5];
                    break;
                }
            }
            ++n5;
        }
        if (file3 != null) {
            try {
                if (this.getLoggingOn()) {
                    this.logOpenClose(file, "Read data for " + lSID);
                }
                object = new FileInputStream(file3);
                ((FileInputStream)object).skip(n - n3);
                return object;
            }
            catch (IOException iOException) {
                throw new LSIDCacheException(iOException, "Error opening data cache file " + file3);
            }
        }
        return null;
    }

    public synchronized MetadataResponse readMetadata(LSIDAuthority lSIDAuthority, LSID lSID, String string, String string2, String[] stringArray) throws LSIDCacheException {
        if (stringArray == null) {
            stringArray = ALL_FORMATS;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string3 = string + "." + string2;
            string3 = stringArray[n] != null ? string3 + "." + METADATA_TYPE_2_EXTENSION.get(stringArray[n]) : string3 + ".tmp";
            File file = new File(cacheDir, "/metadata/" + lSIDAuthority + "/" + this.canonicalizeFilename(lSID.toString()) + "/" + string3);
            Hashtable hashtable = this.loadExpirationEntries(file.getParentFile());
            if (file.exists() && !LSIDCache.fileExpired(hashtable, string3)) {
                try {
                    if (this.getLoggingOn()) {
                        this.logOpenClose(new File(cacheDir, "/metadata/" + lSIDAuthority + "/" + this.canonicalizeFilename(lSID.toString())), "Read meta data for " + lSID + " at: " + string + "." + string2);
                    }
                    return new MetadataResponse((Object)new FileInputStream(file), LSIDCache.getExpiration(hashtable, string3), stringArray[n]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new LSIDCacheException(fileNotFoundException, "Error opening meta data cache file " + file);
                }
            }
            ++n;
        }
        return null;
    }

    public void writeWSDL(LSIDAuthority lSIDAuthority, LSID lSID, LSIDWSDLWrapper lSIDWSDLWrapper) throws LSIDCacheException {
        Comparable<File> comparable;
        File file = new File(cacheDir, "/wsdl/" + lSIDAuthority);
        file.mkdirs();
        String string = null;
        String string2 = null;
        if (lSID != null) {
            string = this.canonicalizeFilename(lSID.toString());
            string2 = lSID.toString();
        } else {
            string = "authority";
            string2 = lSIDAuthority.toString();
        }
        string = string + ".wsdl";
        File file2 = new File(file, string);
        FileOutputStream fileOutputStream = null;
        File file3 = new File(LSIDCache.getLocation(), "/temp/");
        file3.mkdirs();
        try {
            comparable = File.createTempFile("cache", DATA_EXT, file3);
            fileOutputStream = new FileOutputStream((File)comparable);
            fileOutputStream.write(lSIDWSDLWrapper.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            if (file2.exists()) {
                file2.delete();
            }
            ((File)comparable).renameTo(file2);
            ((File)comparable).delete();
            this.logOpenClose(file, "Wrote WSDL for " + string2);
        }
        catch (IOException iOException) {
            throw new LSIDCacheException(iOException, "Error writing WSDL for " + string2);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new LSIDCacheException(iOException, "Error closing WSDL cache file for " + string2);
            }
        }
        comparable = lSIDWSDLWrapper.getExpiration();
        if (comparable != null) {
            this.updateExpirationEntry(file, string, ((Date)comparable).getTime());
        }
    }

    public InputStream writeData(LSID lSID, InputStream inputStream, int n, int n2) throws LSIDCacheException {
        File file = new File(cacheDir, "/data/" + this.canonicalizeFilename(lSID.toString()));
        file.mkdirs();
        String string = null;
        string = n == -1 && n2 == -1 ? COMPLETE_FILE : "range_" + n + "_" + n2 + "." + DATA_EXT;
        File file2 = new File(file, string);
        LSIDCachingInputStream lSIDCachingInputStream = new LSIDCachingInputStream(inputStream, file2, null, lSID);
        lSIDCachingInputStream.setInputStreamListener(new LSIDCachingInputStreamListener(){

            public void inputStreamClosed(LSIDAuthority lSIDAuthority, LSID lSID) throws IOException {
                try {
                    File file = new File(cacheDir, "/data/" + LSIDCache.this.canonicalizeFilename(lSID.toString()));
                    LSIDCache.this.logOpenClose(file, "Wrote data for " + lSID);
                }
                catch (LSIDCacheException lSIDCacheException) {
                    lSIDCacheException.printStackTrace();
                    throw new IOException("Error handling inputStreamClosed event for " + lSID + " : " + lSIDCacheException.getMessage());
                }
            }
        });
        return lSIDCachingInputStream;
    }

    public synchronized InputStream writeMetadata(LSIDAuthority lSIDAuthority, LSID lSID, String string, String string2, InputStream inputStream, Date date, String string3) throws LSIDCacheException {
        File file = new File(cacheDir, "/metadata/" + lSIDAuthority + "/" + this.canonicalizeFilename(lSID.toString()));
        String string4 = string + "." + string2;
        string4 = string3 != null ? string4 + "." + METADATA_TYPE_2_EXTENSION.get(string3) : string4 + ".tmp";
        File file2 = new File(file, string4);
        LSIDCachingInputStream lSIDCachingInputStream = new LSIDCachingInputStream(inputStream, file2, lSIDAuthority, lSID);
        final String string5 = string4;
        final Date date2 = date;
        lSIDCachingInputStream.setInputStreamListener(new LSIDCachingInputStreamListener(){

            public void inputStreamClosed(LSIDAuthority lSIDAuthority, LSID lSID) throws IOException {
                try {
                    File file = new File(cacheDir, "/metadata/" + lSIDAuthority + "/" + LSIDCache.this.canonicalizeFilename(lSID.toString()));
                    LSIDCache.this.logOpenClose(file, "Wrote meta data for " + lSID + " at: " + string5);
                    if (date2 != null) {
                        LSIDCache.this.updateExpirationEntry(file, string5, date2.getTime());
                    }
                }
                catch (LSIDCacheException lSIDCacheException) {
                    lSIDCacheException.printStackTrace();
                    throw new IOException("Error handling inputStreamClosed event for " + lSID + " : " + lSIDCacheException.getMessage());
                }
            }
        });
        return lSIDCachingInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainCache() throws LSIDCacheException {
        this.openLogWriter();
        try {
            this.maintainCache(-1L);
            Object var2_1 = null;
            this.closeLogWriter();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.closeLogWriter();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private LSIDCache(LSIDCache var1_1, File var2_2) throws LSIDCacheException {
        super();
        LSIDCache.cacheDir = var2_2;
        var3_3 = new File(var2_2, "lsid-cache.properties");
        if (var3_3.exists()) {
            var4_4 = null;
            try {
                var5_5 = new Properties();
                var4_4 = new FileInputStream(var3_3);
                var5_5.load(var4_4);
                var6_8 = var5_5.getProperty("max-cache-size");
                var7_9 = var5_5.getProperty("max-cache-lifetime");
                var8_10 = var5_5.getProperty("max-cache-size-high");
                var9_11 = var5_5.getProperty("max-cache-lifetime-high");
                var10_12 = var5_5.getProperty("mangle-case");
                var11_13 = var5_5.getProperty("logging-on");
                this.logFile = var5_5.getProperty("log-file");
                try {
                    this.maxCacheSize = Integer.parseInt(var6_8);
                }
                catch (Exception var12_14) {
                    throw new LSIDCacheException(var12_14, "Error parsing cache config value: " + var6_8);
                }
                if (var10_12 != null) {
                    try {
                        this.mangleCase = Integer.parseInt(var10_12);
                        if (this.mangleCase != -1 && this.mangleCase != 1 && this.mangleCase != 0 && this.mangleCase != 2) {
                            throw new LSIDCacheException("Error parsing cache config mangle value: " + var10_12);
                        }
                    }
                    catch (Exception var12_15) {
                        throw new LSIDCacheException(var12_15, "Error parsing cache config mangle value: " + var10_12);
                    }
                }
                if (var8_10 != null) {
                    try {
                        var12_16 = Integer.parseInt(var8_10);
                        this.maxCacheSize = (var12_16 <<= 32) + this.maxCacheSize;
                    }
                    catch (Exception var12_17) {
                        throw new LSIDCacheException(var12_17, "Error parsing cache config value: " + var8_10);
                    }
                }
                try {
                    this.maxCacheLifetime = Integer.parseInt(var7_9);
                }
                catch (Exception var12_18) {
                    throw new LSIDCacheException(var12_18, "Error parsing cache config value: " + var7_9);
                }
                if (var9_11 != null) {
                    try {
                        var12_16 = Integer.parseInt(var9_11);
                        this.maxCacheLifetime = (var12_16 <<= 32) + this.maxCacheLifetime;
                    }
                    catch (Exception var12_19) {
                        throw new LSIDCacheException(var12_19, "Error parsing cache config value: " + var9_11);
                    }
                }
                try {
                    this.loggingOn = Boolean.valueOf(var11_13);
                }
                catch (Exception var12_20) {
                    throw new LSIDCacheException(var12_20, "Error parsing cache config value: " + var11_13);
                }
                if (var1_1 == null) ** GOTO lbl79
                if (var1_1.getMaxCacheSize() != -1 && var1_1.getMaxCacheSize() < this.maxCacheSize) {
                    this.maxCacheSize = var1_1.getMaxCacheSize();
                }
                if (var1_1.getMaxCacheLifetime() != -1 && var1_1.getMaxCacheLifetime() < this.maxCacheLifetime) {
                    this.maxCacheLifetime = var1_1.getMaxCacheLifetime();
                }
                if (var1_1.getLoggingOn()) ** GOTO lbl79
                this.loggingOn = false;
            }
            catch (IOException var5_7) {
                throw new LSIDCacheException(var5_7, "Error loading properties file from: " + var2_2 + "/" + "lsid-cache.properties");
            }
            finally {
                try {
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                }
                catch (IOException var14_22) {
                    throw new LSIDCacheException(var14_22, "Error closing properties file from: " + var2_2 + "/" + "lsid-cache.properties");
                }
            }
        } else if (var1_1 != null) {
            this.copyConfig(var1_1);
        }
lbl79:
        // 6 sources

        if (var1_1 != null) {
            this.logFileWriter = var1_1.logFileWriter;
        }
    }

    private Vector maintainCache(long l) throws LSIDCacheException {
        if (l == -1L) {
            l = System.currentTimeMillis();
        }
        this.log(cacheDir, "Beginning cache maintenance");
        Vector<File> vector = new Vector<File>();
        File[] fileArray = cacheDir.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            if (file.isDirectory()) {
                vector.addAll(new LSIDCache(this, file).maintainCache(l));
                if (file.list().length == 0) {
                    this.log(cacheDir, "Directory " + file.getName() + " is empty, removing");
                    file.delete();
                }
            } else if (!file.getName().equals(CACHE_CONFIG_FILE) && !file.getName().equals(this.logFile) && !file.getName().equals(EXPIRATION_FILENAME) && this.filterFileByDate(file, l)) {
                vector.add(file);
            }
            ++n;
        }
        this.filterFilesBySize(vector);
        this.log(cacheDir, "Cache maintenance complete");
        return vector;
    }

    private int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    private int getMaxCacheLifetime() {
        return this.maxCacheLifetime;
    }

    private File getCacheDir() {
        return cacheDir;
    }

    private boolean getLoggingOn() {
        return this.loggingOn;
    }

    private String getLogFile() {
        return this.logFile;
    }

    private void openLogWriter() throws LSIDCacheException {
        try {
            if (this.getLoggingOn() && !this.logFile.equals(STD_ERR)) {
                this.logFileWriter = new PrintWriter(new FileWriter(new File(cacheDir, this.logFile).toString(), true));
            }
        }
        catch (IOException iOException) {
            throw new LSIDCacheException(iOException, "error opening cache log file: " + cacheDir + "/" + this.logFile);
        }
    }

    private void closeLogWriter() {
        if (this.logFileWriter != null) {
            this.logFileWriter.close();
        }
    }

    private void log(File file, String string) {
        if (this.getLoggingOn()) {
            String string2 = LOG_DATE_FORMAT.format(new Date(System.currentTimeMillis()));
            if (this.logFileWriter != null) {
                this.logFileWriter.println("[" + string2 + "]" + "[" + file + "]" + string);
                this.logFileWriter.flush();
            } else {
                System.err.println("[" + string2 + "]" + "[" + file + "]" + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logOpenClose(File file, String string) throws LSIDCacheException {
        if (this.getLoggingOn()) {
            try {
                this.openLogWriter();
                this.log(file, string);
                Object var4_3 = null;
                this.closeLogWriter();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.closeLogWriter();
                throw throwable;
            }
        }
    }

    private boolean filterFileByDate(File file, long l) {
        if (this.maxCacheLifetime == -1) {
            return true;
        }
        if (l - file.lastModified() >= (long)this.maxCacheLifetime) {
            this.log(cacheDir, "File " + file + " has expired, deleting");
            file.delete();
            return false;
        }
        return true;
    }

    private void filterFilesBySize(Vector vector) {
        if (this.maxCacheSize == -1) {
            return;
        }
        Collections.sort(vector, this);
        long l = 0L;
        int n = 0;
        while (n < vector.size()) {
            l += ((File)vector.elementAt(n)).length();
            ++n;
        }
        while (l > (long)this.maxCacheSize || this.maxCacheSize == 0 && vector.size() > 0) {
            File file = (File)vector.elementAt(0);
            l -= file.length();
            this.log(cacheDir, "Cache too big, removing file " + file.getName());
            file.delete();
            vector.removeElementAt(0);
        }
    }

    private static boolean fileExpired(Hashtable hashtable, String string) {
        long l = System.currentTimeMillis();
        ExpEntry expEntry = (ExpEntry)hashtable.get(string);
        if (expEntry == null) {
            return false;
        }
        if (expEntry.expires == -1L) {
            return false;
        }
        return l >= expEntry.expires;
    }

    private static long getExpiration(Hashtable hashtable, String string) {
        ExpEntry expEntry = (ExpEntry)hashtable.get(string);
        if (expEntry == null) {
            return -1L;
        }
        return expEntry.expires;
    }

    private void updateExpirationEntry(File file, String string, long l) throws LSIDCacheException {
        File file2 = new File(file, EXPIRATION_FILENAME);
        Hashtable hashtable = this.loadExpirationEntries(file);
        hashtable.put(string, new ExpEntry(string, l));
        LSIDCache.writeExpirationEntries(file, hashtable);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Hashtable loadExpirationEntries(File file) throws LSIDCacheException {
        File file2 = new File(file, EXPIRATION_FILENAME);
        if (!file2.exists()) {
            return new Hashtable();
        }
        BufferedReader bufferedReader = null;
        Hashtable<String, ExpEntry> hashtable = null;
        bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
        hashtable = new Hashtable<String, ExpEntry>();
        String string = bufferedReader.readLine();
        while (string != null) {
            ExpEntry expEntry = new ExpEntry(string);
            hashtable.put(expEntry.filename, expEntry);
            string = bufferedReader.readLine();
        }
        Object var8_8 = null;
        if (bufferedReader == null) return hashtable;
        try {
            bufferedReader.close();
            return hashtable;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashtable;
        {
            catch (IOException iOException) {
                throw new LSIDCacheException(iOException, "Error updating expiration file in directory: " + file);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    private static void writeExpirationEntries(File file, Hashtable hashtable) throws LSIDCacheException {
        File file2 = new File(file, EXPIRATION_FILENAME);
        PrintWriter printWriter = null;
        try {
            try {
                if (file2.exists()) {
                    file2.delete();
                }
                File file3 = new File(LSIDCache.getLocation(), "/temp/");
                file3.mkdirs();
                File file4 = File.createTempFile("cache", DATA_EXT, file3);
                printWriter = new PrintWriter(new FileWriter(file4.getCanonicalPath(), false));
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    ExpEntry expEntry = (ExpEntry)hashtable.get(enumeration.nextElement());
                    printWriter.println(expEntry.filename + ":" + expEntry.expires);
                    printWriter.flush();
                }
                printWriter.close();
                file4.renameTo(file2);
                file4.delete();
            }
            catch (IOException iOException) {
                throw new LSIDCacheException(iOException, "Error writing expiration file to: " + file);
            }
            Object var9_9 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    public int compare(Object object, Object object2) {
        long l;
        File file = (File)object;
        File file2 = (File)object2;
        long l2 = file.lastModified();
        if (l2 > (l = file2.lastModified())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    private void copyConfig(LSIDCache lSIDCache) {
        this.maxCacheLifetime = lSIDCache.getMaxCacheLifetime();
        this.maxCacheSize = lSIDCache.getMaxCacheSize();
        this.loggingOn = lSIDCache.getLoggingOn();
    }

    public String canonicalizeFilename(String string) throws LSIDCacheException {
        if (this.mangleCase == 1) {
            return LSIDCache.getEncodedFilename(string);
        }
        if (this.mangleCase == -1) {
            return LSIDCache.getEncodedFilename(string, false);
        }
        if (this.mangleCase == 2) {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(string.getBytes("UTF-8"));
                byte[] byArray = messageDigest.digest();
                char[] cArray = new char[byArray.length * 2];
                int n = 0;
                int n2 = 0;
                while (n < byArray.length) {
                    cArray[n2++] = "0123456789ABCDEF".charAt(byArray[n] >> 4 & 0xF);
                    cArray[n2++] = "0123456789ABCDEF".charAt(byArray[n] & 0xF);
                    ++n;
                }
                return new String(cArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new LSIDCacheException("Could not find SHA1 hashing algorithm");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new LSIDCacheException("Could not find UTF-8 encoding");
            }
        }
        if (File.separatorChar == '/') {
            return LSIDCache.getEncodedFilename(string, false);
        }
        return LSIDCache.getEncodedFilename(string);
    }

    public static LSIDCache getSingletonInstance() {
        return singletonInstance;
    }

    public static String getEncodedFilename(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.' || c == '-' || c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') {
                stringBuffer.append(c);
            } else if (!bl && c >= 'A' && c <= 'Z') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("%" + Integer.toHexString(c));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getDecodedFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2];
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '%') {
                cArray[0] = string.charAt(n + 1);
                cArray[1] = string.charAt(n + 2);
                int n2 = Integer.parseInt(new String(cArray), 16);
                stringBuffer.append(new Character((char)n2).toString());
                n += 2;
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getEncodedFilename(String string) {
        return LSIDCache.getEncodedFilename(string, true);
    }

    static {
        METADATA_TYPE_2_EXTENSION.put("application/xml+rdf", "rdf");
        METADATA_TYPE_2_EXTENSION.put("application/xml+xmi", "xmi");
        METADATA_TYPE_2_EXTENSION.put("application/octet-stream", DATA_EXT);
        LOG_DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss:SSS");
        singletonInstance = null;
    }

    private static class ExpEntry {
        String filename;
        long expires;

        ExpEntry(String string, long l) {
            this.filename = string;
            this.expires = l;
        }

        ExpEntry(String string) throws LSIDCacheException {
            int n = string.indexOf(58);
            if (n == -1) {
                throw new LSIDCacheException("Bad Expiration file entry: " + string);
            }
            this.filename = string.substring(0, n);
            try {
                this.expires = Long.parseLong(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new LSIDCacheException(numberFormatException, "Bad Expiration file entry: " + string);
            }
        }
    }
}

