/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.wsdl;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.conf.castor.ImportMapChoice;
import com.ibm.lsid.wsdl.DefaultLSIDPort;
import com.ibm.lsid.wsdl.LSIDAuthorityPort;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDPort;
import com.ibm.lsid.wsdl.LSIDStandardPort;
import com.ibm.lsid.wsdl.WSDLConstants;
import com.ibm.wsdl.DefinitionImpl;
import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import com.ibm.wsdl.extensions.file.FileBinding;
import com.ibm.wsdl.extensions.file.FileBindingSerializer;
import com.ibm.wsdl.extensions.file.FileLocation;
import com.ibm.wsdl.extensions.file.FileLocationImpl;
import com.ibm.wsdl.extensions.file.FileLocationSerializer;
import com.ibm.wsdl.extensions.file.FileOperation;
import com.ibm.wsdl.extensions.file.FileOperationSerializer;
import com.ibm.wsdl.extensions.file.FileOutput;
import com.ibm.wsdl.extensions.file.FileOutputSerializer;
import com.ibm.wsdl.extensions.ftp.FTPBinding;
import com.ibm.wsdl.extensions.ftp.FTPBindingSerializer;
import com.ibm.wsdl.extensions.ftp.FTPLocation;
import com.ibm.wsdl.extensions.ftp.FTPLocationImpl;
import com.ibm.wsdl.extensions.ftp.FTPLocationSerializer;
import com.ibm.wsdl.extensions.ftp.FTPOperation;
import com.ibm.wsdl.extensions.ftp.FTPOperationSerializer;
import com.ibm.wsdl.extensions.ftp.FTPOutput;
import com.ibm.wsdl.extensions.ftp.FTPOutputSerializer;
import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.factory.WSDLFactoryImpl;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public class LSIDWSDLWrapper
implements WSDLConstants {
    private static final HashMap IMPORT_MAPS = new HashMap();
    private String wsdlStr = null;
    private Definition wsdlDef;
    private Hashtable lsidMetadataPorts = new Hashtable();
    private Hashtable lsidDataPorts = new Hashtable();
    private Hashtable lsidAuthorityPorts = new Hashtable();
    private Hashtable wsdlExtensionPorts = new Hashtable();
    private Date expiration;
    private int currPortNum = 1;
    private int currBindingNum = 1;
    static /* synthetic */ Class class$javax$wsdl$Port;
    static /* synthetic */ Class class$javax$wsdl$BindingOutput;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$Binding;

    public LSIDWSDLWrapper(LSID lSID) throws LSIDException {
        this.wsdlDef = new DefinitionImpl();
        this.wsdlDef.setExtensionRegistry((ExtensionRegistry)new PopulatedExtensionRegistry());
        String string = LSIDWSDLWrapper.getTargetNamespace(lSID);
        this.wsdlDef.setTargetNamespace(string);
        this.wsdlDef.addNamespace("tns", string);
    }

    public LSIDWSDLWrapper(String string) throws LSIDException {
        this.wsdlStr = string;
        try {
            WSDLReader wSDLReader = WSDLFactoryImpl.newInstance().newWSDLReader();
            wSDLReader.setExtensionRegistry((ExtensionRegistry)new PopulatedExtensionRegistry());
            ExtensionRegistry extensionRegistry = wSDLReader.getExtensionRegistry();
            LSIDWSDLWrapper.registerFTP(extensionRegistry);
            LSIDWSDLWrapper.registerFile(extensionRegistry);
            LSIDWSDLLocator lSIDWSDLLocator = new LSIDWSDLLocator(string);
            this.wsdlDef = wSDLReader.readWSDL((WSDLLocator)lSIDWSDLLocator);
        }
        catch (WSDLException wSDLException) {
            throw new LSIDException((Exception)((Object)wSDLException), "Error reading wsdl file into wsdl4j");
        }
        this.extractPorts();
    }

    public LSIDWSDLWrapper(InputStream inputStream) throws LSIDException {
        try {
            WSDLReader wSDLReader = WSDLFactoryImpl.newInstance().newWSDLReader();
            wSDLReader.setExtensionRegistry((ExtensionRegistry)new PopulatedExtensionRegistry());
            ExtensionRegistry extensionRegistry = wSDLReader.getExtensionRegistry();
            LSIDWSDLWrapper.registerFTP(extensionRegistry);
            LSIDWSDLWrapper.registerFile(extensionRegistry);
            LSIDWSDLLocator lSIDWSDLLocator = new LSIDWSDLLocator(inputStream);
            this.wsdlDef = wSDLReader.readWSDL((WSDLLocator)lSIDWSDLLocator);
        }
        catch (WSDLException wSDLException) {
            throw new LSIDException((Exception)((Object)wSDLException), "Error reading wsdl file into wsdl4j");
        }
        this.extractPorts();
    }

    public String getWSDL() {
        try {
            if (this.wsdlStr == null) {
                this.updateStringRepresentation();
            }
        }
        catch (LSIDException lSIDException) {
            lSIDException.printStackTrace();
            return null;
        }
        return this.wsdlStr;
    }

    public String toString() {
        return this.getWSDL();
    }

    public Definition getDefinition() {
        this.wsdlStr = null;
        return this.wsdlDef;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date date) {
        this.expiration = date;
    }

    public void setDataLocation(LSIDDataPort lSIDDataPort) throws LSIDException {
        String string;
        String string2;
        QName qName;
        Map map;
        Service service;
        String string3 = lSIDDataPort.getServiceName();
        if (string3 == null) {
            string3 = "LSIDService";
        }
        if ((service = (Service)(map = this.wsdlDef.getServices()).get(qName = new QName(this.wsdlDef.getTargetNamespace(), string3))) == null) {
            service = this.wsdlDef.createService();
            service.setQName(qName);
            this.wsdlDef.addService(service);
        }
        if ((string2 = lSIDDataPort.getName()) != null) {
            string = service.getPort(string2);
            if (string != null) {
                this.wsdlDef.removeBinding(string.getBinding().getQName());
                service.getPorts().remove(string2);
            }
            this.lsidDataPorts.remove(this.getPortKey(lSIDDataPort));
        }
        string = lSIDDataPort.getProtocol();
        this.configureDataServiceDef(lSIDDataPort.getProtocol());
        PortType portType = this.wsdlDef.getPortType(new QName("http://www.omg.org/LSID/2003/Standard/WSDL", "LSIDDataServicePortType"));
        Binding binding = null;
        if (string.equals("soap")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.DATA_SOAP_BINDING);
        } else if (string.equals("http")) {
            System.err.println(lSIDDataPort.getClass());
            System.err.println("path: " + lSIDDataPort.getPath());
            binding = lSIDDataPort.getPath().equals("urlEncoded") ? this.wsdlDef.getBinding(WSDLConstants.DATA_HTTP_BINDING) : this.wsdlDef.getBinding(WSDLConstants.DATA_HTTP_BINDING_DIRECT);
        } else if (string.equals("ftp")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.DATA_FTP_BINDING);
        } else if (string.equals("file")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.DATA_FILE_BINDING);
        }
        Port port = this.createPort(binding, lSIDDataPort);
        service.addPort(port);
        this.lsidDataPorts.put(this.getPortKey(lSIDDataPort), lSIDDataPort);
        this.wsdlStr = null;
    }

    public void setMetadataLocation(LSIDMetadataPort lSIDMetadataPort) throws LSIDException {
        String string;
        String string2;
        QName qName;
        Map map;
        Service service;
        String string3 = lSIDMetadataPort.getServiceName();
        if (string3 == null) {
            string3 = "LSIDService";
        }
        if ((service = (Service)(map = this.wsdlDef.getServices()).get(qName = new QName(this.wsdlDef.getTargetNamespace(), string3))) == null) {
            service = this.wsdlDef.createService();
            service.setQName(qName);
            this.wsdlDef.addService(service);
        }
        if ((string2 = lSIDMetadataPort.getName()) != null) {
            string = service.getPort(string2);
            if (string != null) {
                this.wsdlDef.removeBinding(string.getBinding().getQName());
                service.getPorts().remove(string2);
            }
            this.lsidMetadataPorts.remove(this.getPortKey(lSIDMetadataPort));
        }
        string = lSIDMetadataPort.getProtocol();
        this.configureDataServiceDef(lSIDMetadataPort.getProtocol());
        PortType portType = this.wsdlDef.getPortType(new QName("http://www.omg.org/LSID/2003/Standard/WSDL", "LSIDMetadataServicePortType"));
        Binding binding = null;
        if (string.equals("soap")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.METADATA_SOAP_BINDING);
        } else if (string.equals("http")) {
            binding = lSIDMetadataPort.getPath().equals("urlEncoded") ? this.wsdlDef.getBinding(WSDLConstants.METADATA_HTTP_BINDING) : this.wsdlDef.getBinding(WSDLConstants.METADATA_HTTP_BINDING_DIRECT);
        } else if (string.equals("ftp")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.METADATA_FTP_BINDING);
        } else if (string.equals("file")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.METADATA_FILE_BINDING);
        }
        Port port = this.createPort(binding, lSIDMetadataPort);
        service.addPort(port);
        this.lsidMetadataPorts.put(this.getPortKey(lSIDMetadataPort), lSIDMetadataPort);
        this.wsdlStr = null;
    }

    public void setAuthorityLocation(LSIDAuthorityPort lSIDAuthorityPort) throws LSIDException {
        String string;
        String string2;
        QName qName;
        Map map;
        Service service;
        String string3 = lSIDAuthorityPort.getServiceName();
        if (string3 == null) {
            string3 = "LSIDService";
        }
        if ((service = (Service)(map = this.wsdlDef.getServices()).get(qName = new QName(this.wsdlDef.getTargetNamespace(), string3))) == null) {
            service = this.wsdlDef.createService();
            service.setQName(qName);
            this.wsdlDef.addService(service);
        }
        if ((string2 = lSIDAuthorityPort.getName()) != null) {
            string = service.getPort(string2);
            if (string != null) {
                this.wsdlDef.removeBinding(string.getBinding().getQName());
                service.getPorts().remove(string2);
            }
            this.lsidAuthorityPorts.remove(this.getPortKey(lSIDAuthorityPort));
        }
        string = lSIDAuthorityPort.getProtocol();
        this.configureAuthorityServiceDef(string);
        PortType portType = this.wsdlDef.getPortType(new QName("http://www.omg.org/LSID/2003/Standard/WSDL", "LSIDAuthorityServicePortType"));
        Binding binding = null;
        if (string.equals("soap")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.AUTHORITY_SOAP_BINDING);
        } else if (string.equals("http")) {
            binding = this.wsdlDef.getBinding(WSDLConstants.AUTHORITY_HTTP_BINDING);
        }
        if (binding == null) {
            throw new LSIDException("Unsuported protocol for authority port: " + string);
        }
        Port port = this.createPort(binding, lSIDAuthorityPort);
        service.addPort(port);
        this.lsidAuthorityPorts.put(this.getPortKey(lSIDAuthorityPort), lSIDAuthorityPort);
        this.wsdlStr = null;
    }

    public Enumeration getServiceNames() {
        Map map = this.wsdlDef.getServices();
        Vector<String> vector = new Vector<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            vector.add(qName.getLocalPart());
        }
        return vector.elements();
    }

    public Enumeration getMetadataPortNames() {
        return this.lsidMetadataPorts.keys();
    }

    public Enumeration getMetadataPortNamesForService(String string) {
        Service service = this.wsdlDef.getService(new QName(this.wsdlDef.getTargetNamespace(), string));
        Map map = service.getPorts();
        Vector<String> vector = new Vector<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Port port = (Port)map.get(string2);
            if (!port.getBinding().getPortType().getQName().getLocalPart().equals("LSIDMetadataServicePortType")) continue;
            vector.add(string + ":" + string2);
        }
        return vector.elements();
    }

    public Enumeration getMetadataPortNamesForProtocol(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.lsidMetadataPorts.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            LSIDMetadataPort lSIDMetadataPort = (LSIDMetadataPort)this.lsidMetadataPorts.get(string2);
            String string3 = lSIDMetadataPort.getProtocol();
            if (string3 == null || !string3.equals(string)) continue;
            vector.add(string2);
        }
        return vector.elements();
    }

    public LSIDMetadataPort getMetadataPort() {
        LSIDMetadataPort lSIDMetadataPort = this.getMetadataPortForProtocol("http");
        if (lSIDMetadataPort != null) {
            return lSIDMetadataPort;
        }
        lSIDMetadataPort = this.getMetadataPortForProtocol("ftp");
        if (lSIDMetadataPort != null) {
            return lSIDMetadataPort;
        }
        if (!this.lsidMetadataPorts.keys().hasMoreElements()) {
            return null;
        }
        return (LSIDMetadataPort)this.lsidMetadataPorts.get(this.lsidMetadataPorts.keys().nextElement());
    }

    public LSIDMetadataPort getMetadataPort(String string) {
        return (LSIDMetadataPort)this.lsidMetadataPorts.get(string);
    }

    public LSIDMetadataPort getMetadataPortForProtocol(String string) {
        Enumeration enumeration = this.lsidMetadataPorts.keys();
        while (enumeration.hasMoreElements()) {
            LSIDMetadataPort lSIDMetadataPort = (LSIDMetadataPort)this.lsidMetadataPorts.get(enumeration.nextElement());
            String string2 = lSIDMetadataPort.getProtocol();
            if (string2 == null || !string2.equals(string)) continue;
            return lSIDMetadataPort;
        }
        return null;
    }

    public Enumeration getDataPortNames() {
        return this.lsidDataPorts.keys();
    }

    public Enumeration getDataPortNamesForProtocol(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.lsidDataPorts.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            LSIDDataPort lSIDDataPort = (LSIDDataPort)this.lsidDataPorts.get(string2);
            if (!lSIDDataPort.getProtocol().equals(string)) continue;
            vector.add(string2);
        }
        return vector.elements();
    }

    public LSIDDataPort getDataPort() {
        LSIDDataPort lSIDDataPort = this.getDataPortForProtocol("http");
        if (lSIDDataPort != null) {
            return lSIDDataPort;
        }
        lSIDDataPort = this.getDataPortForProtocol("ftp");
        if (lSIDDataPort != null) {
            return lSIDDataPort;
        }
        if (!this.lsidDataPorts.keys().hasMoreElements()) {
            return null;
        }
        return (LSIDDataPort)this.lsidDataPorts.get(this.lsidDataPorts.keys().nextElement());
    }

    public LSIDDataPort getDataPort(String string) {
        return (LSIDDataPort)this.lsidDataPorts.get(string);
    }

    public LSIDDataPort getDataPortForProtocol(String string) {
        Enumeration enumeration = this.lsidDataPorts.keys();
        while (enumeration.hasMoreElements()) {
            LSIDDataPort lSIDDataPort = (LSIDDataPort)this.lsidDataPorts.get(enumeration.nextElement());
            if (!lSIDDataPort.getProtocol().equals(string)) continue;
            return lSIDDataPort;
        }
        return null;
    }

    public Enumeration getAuthorityPortNames() {
        return this.lsidAuthorityPorts.keys();
    }

    public Enumeration getAuthorityPortNamesForProtocol(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.lsidAuthorityPorts.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            LSIDAuthorityPort lSIDAuthorityPort = (LSIDAuthorityPort)this.lsidAuthorityPorts.get(string2);
            String string3 = lSIDAuthorityPort.getProtocol();
            if (string3 == null || !string3.equals(string)) continue;
            vector.add(string2);
        }
        return vector.elements();
    }

    public LSIDAuthorityPort getAuthorityPort() {
        LSIDAuthorityPort lSIDAuthorityPort = this.getAuthorityPortForProtocol("http");
        if (lSIDAuthorityPort != null) {
            return lSIDAuthorityPort;
        }
        lSIDAuthorityPort = this.getAuthorityPortForProtocol("soap");
        if (lSIDAuthorityPort != null) {
            return lSIDAuthorityPort;
        }
        if (!this.lsidAuthorityPorts.keys().hasMoreElements()) {
            return null;
        }
        return (LSIDAuthorityPort)this.lsidAuthorityPorts.get(this.lsidAuthorityPorts.keys().nextElement());
    }

    public LSIDAuthorityPort getAuthorityPort(String string) {
        return (LSIDAuthorityPort)this.lsidAuthorityPorts.get(string);
    }

    public LSIDAuthorityPort getAuthorityPortForProtocol(String string) {
        Enumeration enumeration = this.lsidAuthorityPorts.keys();
        while (enumeration.hasMoreElements()) {
            LSIDAuthorityPort lSIDAuthorityPort = (LSIDAuthorityPort)this.lsidAuthorityPorts.get(enumeration.nextElement());
            String string2 = lSIDAuthorityPort.getProtocol();
            if (string2 == null || !string2.equals(string)) continue;
            return lSIDAuthorityPort;
        }
        return null;
    }

    public Enumeration getExtensionPortNames() {
        return this.wsdlExtensionPorts.keys();
    }

    public Enumeration getExtensionPortNamesByClass(Class clazz) {
        Enumeration enumeration = this.wsdlExtensionPorts.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LSIDPort lSIDPort = (LSIDPort)this.wsdlExtensionPorts.get(string);
            if (!lSIDPort.getClass().equals(clazz)) continue;
            vector.add(string);
        }
        return vector.elements();
    }

    public LSIDPort getExtensionPort(String string) {
        return (LSIDPort)this.wsdlExtensionPorts.get(string);
    }

    private void configureDataServiceDef(String string) throws LSIDException {
        if (string.equals("http")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/DataServiceHTTPBindings")) {
                this.importNamespace("dhb", "http://www.omg.org/LSID/2003/DataServiceHTTPBindings", "LSIDDataServiceHTTPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://schemas.xmlsoap.org/wsdl/http/")) {
                this.wsdlDef.addNamespace("http", "http://schemas.xmlsoap.org/wsdl/http/");
            }
        } else if (string.equals("ftp")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/DataServiceFTPBindings")) {
                this.importNamespace("dfb", "http://www.omg.org/LSID/2003/DataServiceFTPBindings", "LSIDDataServiceFTPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.ibm.com/wsdl/ftp/")) {
                this.wsdlDef.addNamespace("ftp", "http://www.ibm.com/wsdl/ftp/");
                ExtensionRegistry extensionRegistry = this.wsdlDef.getExtensionRegistry();
                LSIDWSDLWrapper.registerFTP(extensionRegistry);
            }
        } else if (string.equals("file")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/DataServiceFileBindings")) {
                this.importNamespace("dfb", "http://www.omg.org/LSID/2003/DataServiceFileBindings", "LSIDDataServiceFileBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.ibm.com/wsdl/file/")) {
                this.wsdlDef.addNamespace("file", "http://www.ibm.com/wsdl/file/");
                ExtensionRegistry extensionRegistry = this.wsdlDef.getExtensionRegistry();
                LSIDWSDLWrapper.registerFile(extensionRegistry);
            }
        } else if (string.equals("soap")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/DataServiceSOAPBindings")) {
                this.importNamespace("dsb", "http://www.omg.org/LSID/2003/DataServiceSOAPBindings", "LSIDDataServiceSOAPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://schemas.xmlsoap.org/wsdl/soap/")) {
                this.wsdlDef.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            }
        }
    }

    private void configureAuthorityServiceDef(String string) throws LSIDException {
        if (string.equals("http")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/AuthorityServiceHTTPBindings")) {
                this.importNamespace("ahb", "http://www.omg.org/LSID/2003/AuthorityServiceHTTPBindings", "LSIDAuthorityServiceHTTPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://schemas.xmlsoap.org/wsdl/http/")) {
                this.wsdlDef.addNamespace("http", "http://schemas.xmlsoap.org/wsdl/http/");
            }
        } else if (string.equals("soap")) {
            if (!this.wsdlDef.getNamespaces().containsValue("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings")) {
                this.importNamespace("asb", "http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings", "LSIDAuthorityServiceSOAPBindings.wsdl");
            }
            if (!this.wsdlDef.getNamespaces().containsValue("http://schemas.xmlsoap.org/wsdl/soap/")) {
                this.wsdlDef.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            }
        }
    }

    private void importNamespace(String string, String string2, String string3) throws LSIDException {
        WSDLReaderImpl wSDLReaderImpl;
        Definition definition = null;
        try {
            wSDLReaderImpl = new WSDLReaderImpl();
            definition = wSDLReaderImpl.readWSDL((WSDLLocator)new LSIDWSDLLocator(string3));
        }
        catch (WSDLException wSDLException) {
            throw new LSIDException((Exception)((Object)wSDLException), "Error importing namespace: " + string2);
        }
        this.wsdlDef.addNamespace(string, string2);
        wSDLReaderImpl = this.wsdlDef.createImport();
        wSDLReaderImpl.setLocationURI(string3);
        wSDLReaderImpl.setNamespaceURI(string2);
        wSDLReaderImpl.setDefinition(definition);
        this.wsdlDef.addImport((Import)wSDLReaderImpl);
    }

    private void updateStringRepresentation() throws LSIDException {
        StringWriter stringWriter = new StringWriter();
        WSDLWriterImpl wSDLWriterImpl = new WSDLWriterImpl();
        try {
            wSDLWriterImpl.writeWSDL(this.wsdlDef, (Writer)stringWriter);
        }
        catch (WSDLException wSDLException) {
            throw new LSIDException((Exception)((Object)wSDLException), "Error writing WSDL def to string");
        }
        this.wsdlStr = stringWriter.getBuffer().toString();
    }

    private void extractPorts() throws LSIDException {
        Map map = this.wsdlDef.getServices();
        Object[] objectArray = map.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            Service service = (Service)map.get(objectArray[n]);
            Map map2 = service.getPorts();
            Object[] objectArray2 = map2.keySet().toArray();
            int n2 = 0;
            while (n2 < objectArray2.length) {
                Object object;
                Port port = (Port)map2.get(objectArray2[n2]);
                Binding binding = port.getBinding();
                PortType portType = binding.getPortType();
                QName qName = portType.getQName();
                if (qName.getLocalPart().equals("LSIDMetadataServicePortType") && qName.getNamespaceURI().equals("http://www.omg.org/LSID/2003/Standard/WSDL")) {
                    if (!(binding.getQName().equals(WSDLConstants.METADATA_SOAP_BINDING) || binding.getQName().equals(WSDLConstants.METADATA_HTTP_BINDING) || binding.getQName().equals(WSDLConstants.METADATA_FTP_BINDING) || binding.getQName().equals(WSDLConstants.METADATA_FILE_BINDING))) {
                        throw new LSIDException(711, "Unrecognized metadata binding: " + binding.getQName());
                    }
                    object = this.extractPort(service, port, qName);
                    this.lsidMetadataPorts.put(((LSIDStandardPortImpl)object).getKey(), object);
                } else if (qName.getLocalPart().equals("LSIDDataServicePortType") && qName.getNamespaceURI().equals("http://www.omg.org/LSID/2003/Standard/WSDL")) {
                    if (!(binding.getQName().equals(WSDLConstants.DATA_SOAP_BINDING) || binding.getQName().equals(WSDLConstants.DATA_HTTP_BINDING) || binding.getQName().equals(WSDLConstants.DATA_FTP_BINDING) || binding.getQName().equals(WSDLConstants.DATA_FILE_BINDING))) {
                        throw new LSIDException(711, "Unrecognized data binding: " + binding.getQName());
                    }
                    object = this.extractPort(service, port, qName);
                    this.lsidDataPorts.put(((LSIDStandardPortImpl)object).getKey(), object);
                } else if (qName.getLocalPart().equals("LSIDAuthorityServicePortType") && qName.getNamespaceURI().equals("http://www.omg.org/LSID/2003/Standard/WSDL")) {
                    if (!binding.getQName().equals(WSDLConstants.AUTHORITY_SOAP_BINDING) && !binding.getQName().equals(WSDLConstants.AUTHORITY_HTTP_BINDING)) {
                        throw new LSIDException(711, "Unrecognized authority binding: " + binding.getQName());
                    }
                    object = this.extractPort(service, port, qName);
                    this.lsidAuthorityPorts.put(((LSIDStandardPortImpl)object).getKey(), object);
                } else {
                    object = LSIDResolver.getConfig().getLSIDPortFactory(portType);
                    LSIDPort lSIDPort = null;
                    lSIDPort = object == null ? new DefaultLSIDPort(service.getQName().getLocalPart(), port.getName(), port) : object.createPort(service.getQName().getLocalPart(), port);
                    this.wsdlExtensionPorts.put(this.getPortKey(lSIDPort), lSIDPort);
                }
                ++n2;
            }
            ++n;
        }
    }

    private LSIDStandardPortImpl extractPort(Service service, Port port, QName qName) throws LSIDException {
        String string = port.getName();
        LSIDStandardPortImpl lSIDStandardPortImpl = new LSIDStandardPortImpl();
        lSIDStandardPortImpl.name = string;
        lSIDStandardPortImpl.serviceName = service.getQName().getLocalPart();
        ListIterator listIterator = port.getExtensibilityElements().listIterator();
        while (listIterator.hasNext()) {
            Object object;
            Object e = listIterator.next();
            if (e instanceof SOAPAddress) {
                object = (SOAPAddress)e;
                lSIDStandardPortImpl.location = object.getLocationURI();
                lSIDStandardPortImpl.protocol = "soap";
                continue;
            }
            if (e instanceof HTTPAddress) {
                object = (HTTPAddress)e;
                lSIDStandardPortImpl.location = object.getLocationURI();
                lSIDStandardPortImpl.protocol = "http";
                QName qName2 = port.getBinding().getQName();
                if (qName2.equals(WSDLConstants.DATA_HTTP_BINDING_DIRECT)) {
                    lSIDStandardPortImpl.path = "direct";
                    continue;
                }
                lSIDStandardPortImpl.path = "urlEncoded";
                continue;
            }
            if (e instanceof FTPLocation) {
                object = (FTPLocation)e;
                lSIDStandardPortImpl.location = object.getServer();
                lSIDStandardPortImpl.path = object.getFilePath();
                lSIDStandardPortImpl.protocol = "ftp";
                continue;
            }
            if (e instanceof FileLocation) {
                object = (FileLocation)e;
                lSIDStandardPortImpl.location = object.getFilename();
                lSIDStandardPortImpl.protocol = "file";
                continue;
            }
            throw new LSIDException("Unknown Port impl");
        }
        return lSIDStandardPortImpl;
    }

    private Port createPort(Binding binding, LSIDStandardPort lSIDStandardPort) {
        Port port = this.wsdlDef.createPort();
        port.setBinding(binding);
        String string = lSIDStandardPort.getName();
        String string2 = lSIDStandardPort.getProtocol();
        if (string == null) {
            string = this.newPortName(string2);
        }
        port.setName(string);
        if (string2.equals("http")) {
            HTTPAddressImpl hTTPAddressImpl = new HTTPAddressImpl();
            hTTPAddressImpl.setLocationURI(lSIDStandardPort.getLocation());
            port.addExtensibilityElement((ExtensibilityElement)hTTPAddressImpl);
        } else if (string2.equals("ftp")) {
            FTPLocationImpl fTPLocationImpl = new FTPLocationImpl(lSIDStandardPort.getLocation(), lSIDStandardPort.getPath());
            port.addExtensibilityElement((ExtensibilityElement)fTPLocationImpl);
        } else if (string2.equals("file")) {
            FileLocationImpl fileLocationImpl = new FileLocationImpl(lSIDStandardPort.getLocation());
            port.addExtensibilityElement((ExtensibilityElement)fileLocationImpl);
        } else if (string2.equals("soap")) {
            SOAPAddressImpl sOAPAddressImpl = new SOAPAddressImpl();
            sOAPAddressImpl.setLocationURI(lSIDStandardPort.getLocation());
            port.addExtensibilityElement((ExtensibilityElement)sOAPAddressImpl);
        }
        return port;
    }

    private synchronized String newPortName(String string) {
        return string + "Port" + String.valueOf(this.currPortNum++);
    }

    private static String getTargetNamespace(LSID lSID) {
        if (lSID == null) {
            return "http://www.omg.org/LSID/2003/Standard/WSDL";
        }
        return "http://" + lSID.getAuthority() + "/" + "availableServices?" + lSID.toString();
    }

    private String getPortKey(LSIDPort lSIDPort) {
        return (lSIDPort.getServiceName() != null ? lSIDPort.getServiceName() : "LSIDService") + ":" + lSIDPort.getName();
    }

    private static void registerFTP(ExtensionRegistry extensionRegistry) {
        extensionRegistry.registerDeserializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = LSIDWSDLWrapper.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, FTPLocation.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FTPLocationSerializer());
        extensionRegistry.registerDeserializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = LSIDWSDLWrapper.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, FTPOutput.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FTPOutputSerializer());
        extensionRegistry.registerDeserializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = LSIDWSDLWrapper.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, FTPOperation.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FTPOperationSerializer());
        extensionRegistry.registerDeserializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = LSIDWSDLWrapper.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FTPBinding.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FTPBindingSerializer());
        extensionRegistry.registerSerializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = LSIDWSDLWrapper.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, FTPLocation.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FTPLocationSerializer());
        extensionRegistry.registerSerializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = LSIDWSDLWrapper.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, FTPOutput.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FTPOutputSerializer());
        extensionRegistry.registerSerializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = LSIDWSDLWrapper.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, FTPOperation.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FTPOperationSerializer());
        extensionRegistry.registerSerializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = LSIDWSDLWrapper.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FTPBinding.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FTPBindingSerializer());
    }

    private static void registerFile(ExtensionRegistry extensionRegistry) {
        extensionRegistry.registerDeserializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = LSIDWSDLWrapper.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, FileLocation.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FileLocationSerializer());
        extensionRegistry.registerDeserializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = LSIDWSDLWrapper.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, FileOutput.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FileOutputSerializer());
        extensionRegistry.registerDeserializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = LSIDWSDLWrapper.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, FileOperation.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FileOperationSerializer());
        extensionRegistry.registerDeserializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = LSIDWSDLWrapper.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FileBinding.DEFAULT_ELEMENT_TYPE, (ExtensionDeserializer)new FileBindingSerializer());
        extensionRegistry.registerSerializer(class$javax$wsdl$Port == null ? (class$javax$wsdl$Port = LSIDWSDLWrapper.class$("javax.wsdl.Port")) : class$javax$wsdl$Port, FileLocation.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FileLocationSerializer());
        extensionRegistry.registerSerializer(class$javax$wsdl$BindingOutput == null ? (class$javax$wsdl$BindingOutput = LSIDWSDLWrapper.class$("javax.wsdl.BindingOutput")) : class$javax$wsdl$BindingOutput, FileOutput.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FileOutputSerializer());
        extensionRegistry.registerSerializer(class$javax$wsdl$BindingOperation == null ? (class$javax$wsdl$BindingOperation = LSIDWSDLWrapper.class$("javax.wsdl.BindingOperation")) : class$javax$wsdl$BindingOperation, FileOperation.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FileOperationSerializer());
        extensionRegistry.registerSerializer(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = LSIDWSDLWrapper.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, FileBinding.DEFAULT_ELEMENT_TYPE, (ExtensionSerializer)new FileBindingSerializer());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        IMPORT_MAPS.put("LSIDPortTypes.wsdl", "LSIDPortTypes.wsdl");
        IMPORT_MAPS.put("LSIDDataServiceSOAPBindings.wsdl", "LSIDDataServiceSOAPBindings.wsdl");
        IMPORT_MAPS.put("LSIDDataServiceHTTPBindings.wsdl", "LSIDDataServiceHTTPBindings.wsdl");
        IMPORT_MAPS.put("LSIDDataServiceFTPBindings.wsdl", "LSIDDataServiceFTPBindings.wsdl");
        IMPORT_MAPS.put("LSIDDataServiceFileBindings.wsdl", "LSIDDataServiceFileBindings.wsdl");
        IMPORT_MAPS.put("LSIDAuthorityServiceSOAPBindings.wsdl", "LSIDAuthorityServiceSOAPBindings.wsdl");
        IMPORT_MAPS.put("LSIDAuthorityServiceHTTPBindings.wsdl", "LSIDAuthorityServiceHTTPBindings.wsdl");
    }

    class LSIDStandardPortImpl
    implements LSIDDataPort,
    LSIDMetadataPort,
    LSIDAuthorityPort {
        private String name = null;
        private String serviceName = null;
        private String location;
        private String protocol;
        private String path;
        private LSIDCredentials lsidCredentials = null;
        private Map headers = new HashMap();

        LSIDStandardPortImpl() {
        }

        public void addProtocolHeader(String string, String string2) {
            this.headers.put(string, string2);
        }

        public Map getProtocolHeaders() {
            return this.headers;
        }

        public LSIDCredentials getLsidCredentials() {
            LSIDCredentials lSIDCredentials;
            if (this.lsidCredentials == null && (lSIDCredentials = new LSIDCredentials(this)).keys().hasMoreElements()) {
                this.lsidCredentials = lSIDCredentials;
            }
            return this.lsidCredentials;
        }

        public void setLsidCredentials(LSIDCredentials lSIDCredentials) {
            this.lsidCredentials = lSIDCredentials;
        }

        public String getName() {
            return this.name;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPath() {
            return this.path;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getKey() {
            return this.serviceName + ":" + this.name;
        }
    }

    class LSIDWSDLLocator
    implements WSDLLocator {
        String wsdlStr = null;
        InputStream wsdlStream = null;
        String lastImportURI = null;

        LSIDWSDLLocator(InputStream inputStream) {
            this.wsdlStream = inputStream;
        }

        LSIDWSDLLocator(String string) {
            this.wsdlStr = string;
        }

        public Reader getBaseReader() {
            if (this.wsdlStream != null) {
                return new InputStreamReader(this.wsdlStream);
            }
            String string = (String)IMPORT_MAPS.get(this.wsdlStr);
            if (string != null) {
                InputStream inputStream = LSIDWSDLWrapper.this.getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    System.err.println("Failed to load resource: " + inputStream);
                    return null;
                }
                return new InputStreamReader(inputStream);
            }
            return new StringReader(this.wsdlStr);
        }

        public String getBaseURI() {
            return "localhost";
        }

        public Reader getImportReader(String string, String string2) {
            this.lastImportURI = string2;
            String string3 = (String)IMPORT_MAPS.get(string2);
            if (string3 != null) {
                InputStream inputStream = LSIDWSDLWrapper.this.getClass().getResourceAsStream(string3);
                if (inputStream == null) {
                    System.err.println("Failed to load resource: " + string3);
                    return null;
                }
                return new InputStreamReader(inputStream);
            }
            ImportMapChoice importMapChoice = LSIDResolver.getConfig().getImportMap(string2);
            if (importMapChoice != null) {
                String string4 = importMapChoice.getResource();
                if (string4 != null) {
                    InputStream inputStream = this.getClass().getResourceAsStream(string4);
                    if (inputStream == null) {
                        System.err.println("Error loading custom import for " + string2);
                        return null;
                    }
                    return new InputStreamReader(inputStream);
                }
                File file = new File(importMapChoice.getFile());
                if (file.exists()) {
                    System.err.println("Error loading custom import for " + string2);
                    return null;
                }
                try {
                    return new FileReader(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    System.err.println("Error loading custom import for " + string2 + " from file: " + file);
                    return null;
                }
            }
            try {
                URL uRL = string != null ? StringUtils.getURL(null, (String)string) : null;
                URL uRL2 = StringUtils.getURL((URL)uRL, (String)string2);
                return new InputStreamReader(uRL2.openStream());
            }
            catch (Exception exception) {
                System.err.println("Error loading import at: " + string + "|" + string2);
                exception.printStackTrace();
                return null;
            }
        }

        public String getLatestImportURI() {
            return this.lastImportURI;
        }

        public InputSource getBaseInputSource() {
            return new InputSource(this.getBaseReader());
        }

        public InputSource getImportInputSource(String string, String string2) {
            return new InputSource(this.getImportReader(string, string2));
        }
    }
}

