/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class Sitemap
extends TimerTask {
    private static Logger logMetacat = Logger.getLogger(Sitemap.class);
    private File directory;
    private String urlRoot;
    private String skin;
    static final int MAX_URLS_IN_FILE = 25000;
    static final String fileRoot = "metacat";
    static final String indexFilename = "metacatSitemapIndex.xml";
    static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";

    public Sitemap(File directory, String urlRoot, String skin) {
        this.directory = directory;
        this.urlRoot = urlRoot;
        this.skin = skin;
    }

    @Override
    public void run() {
        this.generateSitemaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSitemaps() {
        logMetacat.info((Object)"Running the Sitemap task.");
        if (this.directory.isDirectory()) {
            StringBuffer query = new StringBuffer();
            String sql = "SELECT xml_documents.docid, xml_documents.rev FROM xml_documents, xml_access, identifier WHERE xml_documents.doctype LIKE 'eml:%' AND xml_documents.docid = identifier.docid AND xml_documents.rev = identifier.rev AND identifier.guid = xml_access.guid AND xml_access.principal_name = 'public' AND xml_access.perm_type = 'allow' order by docid, rev";
            query.append(sql);
            DBConnection dbConn = null;
            int serialNumber = -1;
            try {
                dbConn = DBConnectionPool.getDBConnection("Sitemap.generateSitemap()");
                serialNumber = dbConn.getCheckOutSerialNumber();
                PreparedStatement stmt = dbConn.prepareStatement(query.toString());
                stmt.execute();
                ResultSet rs = stmt.getResultSet();
                File sitemapFile = null;
                OutputStreamWriter sitemap = null;
                int counter = 0;
                int fileNumber = 0;
                while (rs.next()) {
                    if (counter % 25000 == 0) {
                        if (sitemapFile != null && sitemapFile.canWrite()) {
                            this.writeSitemapFooter(sitemap);
                        }
                        sitemapFile = new File(this.directory, fileRoot + ++fileNumber + ".xml");
                        sitemap = new OutputStreamWriter((OutputStream)new FileOutputStream(sitemapFile), Charset.forName("UTF-8"));
                        this.writeSitemapHeader(sitemap);
                    }
                    String separator = PropertyService.getProperty("document.accNumSeparator");
                    String docid = rs.getString(1) + separator + rs.getString(2);
                    this.writeSitemapEntry(sitemap, docid);
                    ++counter;
                }
                stmt.close();
                this.writeSitemapFooter(sitemap);
                this.writeSitemapIndex(fileNumber);
            }
            catch (SQLException e) {
                logMetacat.warn((Object)("Error while writing to the sitemap file: " + e.getMessage()));
            }
            catch (IOException ioe) {
                logMetacat.warn((Object)("Could not open or write to the sitemap file." + ioe.getMessage()));
            }
            catch (PropertyNotFoundException pnfe) {
                logMetacat.warn((Object)("Could not retrieve the account number separator." + pnfe.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        } else {
            logMetacat.warn((Object)"Sitemap not created because directory not valid.");
        }
    }

    private void writeSitemapHeader(Writer sitemap) throws IOException {
        sitemap.write(PROLOG);
        String header = "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\nxmlns:sm=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\">\n";
        sitemap.write(header);
        sitemap.flush();
    }

    private void writeSitemapEntry(Writer sitemap, String docid) throws IOException {
        if (sitemap != null && docid != null && this.urlRoot != null) {
            StringBuffer url = new StringBuffer();
            url.append(this.urlRoot);
            if (!this.urlRoot.endsWith("/")) {
                url.append("/");
            }
            url.append(docid);
            if (this.skin != null) {
                url.append("/");
                url.append(this.skin);
            }
            sitemap.write("<url><loc>");
            sitemap.write(url.toString());
            sitemap.write("</loc>");
            sitemap.write("</url>");
            sitemap.write("\n");
            sitemap.flush();
        }
    }

    private void writeSitemapFooter(Writer sitemap) throws IOException {
        if (sitemap != null) {
            String footer = "</urlset>\n";
            sitemap.write(footer);
            sitemap.close();
        }
    }

    private void writeSitemapIndex(int fileNumber) {
        File sitemapIndexFile = null;
        OutputStreamWriter sitemapIndex = null;
        sitemapIndexFile = new File(this.directory, indexFilename);
        try {
            sitemapIndex = new OutputStreamWriter((OutputStream)new FileOutputStream(sitemapIndexFile), Charset.forName("UTF-8"));
            sitemapIndex.write(PROLOG);
            String header = "<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\nxmlns:sm=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/siteindex.xsd\">\n";
            sitemapIndex.write(header);
            sitemapIndex.flush();
            for (int fn = 1; fn <= fileNumber; ++fn) {
                String filename = fileRoot + fileNumber + ".xml";
                this.writeSitemapIndexEntry(sitemapIndex, filename);
            }
            if (sitemapIndex != null) {
                String footer = "</sitemapindex>\n";
                sitemapIndex.write(footer);
                sitemapIndex.close();
            }
            if (sitemapIndex != null) {
                sitemapIndex.close();
            }
        }
        catch (IOException e) {
            logMetacat.warn((Object)("Could not open or write to the sitemap index file." + e.getMessage()));
        }
    }

    private void writeSitemapIndexEntry(Writer sitemapIndex, String filename) throws IOException {
        if (sitemapIndex != null && filename != null && this.urlRoot != null) {
            StringBuffer url = new StringBuffer();
            url.append(this.urlRoot);
            if (!this.urlRoot.endsWith("/")) {
                url.append("/");
            }
            url.append(filename);
            sitemapIndex.write("<sitemap><loc>");
            sitemapIndex.write(url.toString());
            sitemapIndex.write("</loc>");
            Date now = new Date();
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            sitemapIndex.write("<lastmod>" + fmt.format(now) + "</lastmod>");
            sitemapIndex.write("</sitemap>");
            sitemapIndex.write("\n");
            sitemapIndex.flush();
        }
    }
}

