/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class Upgrade1_5_0
implements UpgradeUtilityInterface {
    private String driver = null;
    private String database = null;
    private String url = null;
    private String user = null;
    private String password = null;

    @Override
    public boolean upgrade() throws AdminException {
        try {
            this.driver = PropertyService.getProperty("database.driver");
            this.database = PropertyService.getProperty("database.type");
            this.url = PropertyService.getProperty("database.connectionURI");
            this.user = PropertyService.getProperty("database.user");
            this.password = PropertyService.getProperty("database.password");
            if (!this.database.equals("oracle")) {
                return true;
            }
            Connection sqlca = null;
            Driver d = (Driver)Class.forName(this.driver).newInstance();
            DriverManager.registerDriver(d);
            sqlca = DriverManager.getConnection(this.url, this.user, this.password);
            Statement sqlStatement = null;
            PreparedStatement pstmt = null;
            ResultSet rset = null;
            try {
                System.out.println("Deleting old nodedatanumerical column from xml_nodes...");
                pstmt = sqlca.prepareStatement("ALTER TABLE xml_nodes DROP COLUMN nodedatanumerical");
                pstmt.execute();
                pstmt.close();
                System.out.println("Done.");
            }
            catch (Exception e) {
                System.out.println(" column not found.");
            }
            System.out.println("Creating new nodedatanumerical column in xml_nodes...");
            pstmt = this.database.equals("oracle") ? sqlca.prepareStatement("ALTER TABLE xml_nodes ADD nodedatanumerical NUMBER") : sqlca.prepareStatement("ALTER TABLE xml_nodes ADD nodedatanumerical FLOAT8");
            pstmt.execute();
            pstmt.close();
            System.out.println("Done.");
            System.out.println("Please be patient as the next upgrade step can be extremely time consuming.");
            System.out.println("Copy numerical values from nodedata to nodedatanumerical in xml_nodes...");
            sqlStatement = sqlca.createStatement();
            rset = sqlStatement.executeQuery("SELECT DISTINCT NODEID, NODEDATA FROM xml_nodes WHERE nodedata IS NOT NULL AND UPPER(nodedata) = LOWER(nodedata)");
            int count = 0;
            while (rset.next()) {
                String nodeid = rset.getString(1);
                String nodedata = rset.getString(2);
                try {
                    if (nodedata.trim().equals("")) continue;
                    double s = Double.parseDouble(nodedata);
                    pstmt = sqlca.prepareStatement("update xml_nodes set nodedatanumerical = " + s + " where nodeid=" + nodeid);
                    pstmt.execute();
                    pstmt.close();
                    if (++count % 5 != 0) continue;
                    System.out.println(count + "...");
                }
                catch (NumberFormatException s) {
                }
                catch (Exception e) {
                    System.out.println("Exception:" + e.getMessage());
                }
            }
            System.out.println("\nDone. " + count + " values copied.");
            rset.close();
            sqlStatement.close();
            sqlca.close();
        }
        catch (Exception e) {
            throw new AdminException("Error upgrading system to 1.5: " + e.getMessage());
        }
        return true;
    }

    public static void main(String[] ags) {
        try {
            Upgrade1_5_0 upgrader = new Upgrade1_5_0();
            upgrader.upgrade();
        }
        catch (Exception ex) {
            System.out.println("Exception:" + ex.getMessage());
        }
    }
}

