/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.v1;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.mn.tier1.v1.MNCore;
import org.dataone.service.mn.tier1.v1.MNRead;
import org.dataone.service.mn.tier2.v1.MNAuthorization;
import org.dataone.service.mn.tier3.v1.MNStorage;
import org.dataone.service.mn.tier4.v1.MNReplication;
import org.dataone.service.mn.v1.MNQuery;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.types.v2.Log;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.types.v2.TypeFactory;

public class MNodeService
implements MNAuthorization,
MNCore,
MNRead,
MNReplication,
MNStorage,
MNQuery {
    edu.ucsb.nceas.metacat.dataone.MNodeService impl = null;
    private Logger logMetacat = Logger.getLogger(MNodeService.class);

    public static MNodeService getInstance(HttpServletRequest request) {
        return new MNodeService(request);
    }

    private MNodeService(HttpServletRequest request) {
        this.impl = edu.ucsb.nceas.metacat.dataone.MNodeService.getInstance(request);
    }

    public void setSession(Session session) {
        this.impl.setSession(session);
    }

    public boolean isAdminAuthorized(Session session) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        return this.impl.isAdminAuthorized(session);
    }

    public QueryEngineDescription getQueryEngineDescription(String engine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        return this.impl.getQueryEngineDescription(null, engine);
    }

    public QueryEngineList listQueryEngines() throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        return this.impl.listQueryEngines(null);
    }

    public InputStream query(String engine, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return this.impl.query(null, engine, query);
    }

    public Identifier archive(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "2912";
        String notFound = "2911";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.archive(null, pid);
    }

    @Deprecated
    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "2912";
        String notFound = "2911";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.archive(session, pid);
    }

    public Identifier create(Identifier pid, InputStream object, org.dataone.service.types.v1.SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType {
        return this.create(null, pid, object, sysmeta);
    }

    @Deprecated
    public Identifier create(Session session, Identifier pid, InputStream object, org.dataone.service.types.v1.SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType {
        SystemMetadata v2Sysmeta = null;
        try {
            v2Sysmeta = (SystemMetadata)TypeFactory.convertTypeFromType((Object)sysmeta, SystemMetadata.class);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((InputStream)object);
            ServiceFailure sf = new ServiceFailure("1190", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return this.impl.create(session, pid, object, v2Sysmeta);
    }

    public Identifier delete(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "2902";
        String notFound = "2901";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.delete(null, pid);
    }

    @Deprecated
    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailure = "2902";
        String notFound = "2901";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.delete(session, pid);
    }

    public Identifier generateIdentifier(String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return this.impl.generateIdentifier(null, scheme, fragment);
    }

    @Deprecated
    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return this.impl.generateIdentifier(session, scheme, fragment);
    }

    public Identifier update(Identifier pid, InputStream object, Identifier newPid, org.dataone.service.types.v1.SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType, NotFound {
        return this.update(null, pid, object, newPid, sysmeta);
    }

    @Deprecated
    public Identifier update(Session session, Identifier pid, InputStream object, Identifier newPid, org.dataone.service.types.v1.SystemMetadata sysmeta) throws IdentifierNotUnique, InsufficientResources, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, UnsupportedType, NotFound {
        String serviceFailure = "1310";
        String notFound = "1280";
        try {
            this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        }
        catch (Exception e) {
            IOUtils.closeQuietly((InputStream)object);
            throw e;
        }
        SystemMetadata v2Sysmeta = null;
        try {
            v2Sysmeta = (SystemMetadata)TypeFactory.convertTypeFromType((Object)sysmeta, SystemMetadata.class);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((InputStream)object);
            ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return this.impl.update(session, pid, object, newPid, v2Sysmeta);
    }

    public boolean replicate(org.dataone.service.types.v1.SystemMetadata sysmeta, NodeReference sourceNode) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken, InsufficientResources, UnsupportedType {
        return this.replicate(null, sysmeta, sourceNode);
    }

    @Deprecated
    public boolean replicate(Session session, org.dataone.service.types.v1.SystemMetadata sysmeta, NodeReference sourceNode) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken, InsufficientResources, UnsupportedType {
        SystemMetadata v2Sysmeta = null;
        try {
            v2Sysmeta = (SystemMetadata)TypeFactory.convertTypeFromType((Object)sysmeta, SystemMetadata.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return this.impl.replicate(session, v2Sysmeta, sourceNode);
    }

    public DescribeResponse describe(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        String serviceFailure = "1030";
        String notFound = "1020";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No system metadata could be found for given PID: " + pid.getValue());
        return this.impl.describe(null, pid);
    }

    @Deprecated
    public DescribeResponse describe(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        String serviceFailure = "1030";
        String notFound = "1020";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No system metadata could be found for given PID: " + pid.getValue());
        return this.impl.describe(session, pid);
    }

    public InputStream get(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        String serviceFailure = "1030";
        String notFound = "1020";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.get(null, pid);
    }

    @Deprecated
    public InputStream get(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        String serviceFailure = "1030";
        String notFound = "1020";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.get(session, pid);
    }

    public Checksum getChecksum(Identifier pid, String algorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return this.impl.getChecksum(null, pid, algorithm);
    }

    @Deprecated
    public Checksum getChecksum(Session session, Identifier pid, String algorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return this.impl.getChecksum(session, pid, algorithm);
    }

    public InputStream getReplica(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        return this.impl.getReplica(null, pid);
    }

    @Deprecated
    public InputStream getReplica(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        return this.impl.getReplica(session, pid);
    }

    public org.dataone.service.types.v1.SystemMetadata getSystemMetadata(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return this.getSystemMetadata(null, pid);
    }

    @Deprecated
    public org.dataone.service.types.v1.SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        String serviceFailure = "1090";
        String notFound = "1060";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No system metadata could be found for given PID: " + pid.getValue());
        SystemMetadata sysMeta = this.impl.getSystemMetadata(session, pid);
        org.dataone.service.types.v1.SystemMetadata retSysMeta = null;
        try {
            retSysMeta = (org.dataone.service.types.v1.SystemMetadata)TypeFactory.convertTypeFromType((Object)sysMeta, org.dataone.service.types.v1.SystemMetadata.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("4801", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return retSysMeta;
    }

    public ObjectList listObjects(Date startTime, Date endTime, ObjectFormatIdentifier objectFormatId, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.listObjects(null, startTime, endTime, objectFormatId, replicaStatus, start, count);
    }

    @Deprecated
    public ObjectList listObjects(Session session, Date startTime, Date endTime, ObjectFormatIdentifier objectFormatId, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.impl.listObjects(session, startTime, endTime, objectFormatId, null, replicaStatus, start, count);
    }

    public boolean synchronizationFailed(SynchronizationFailed syncFailed) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.impl.synchronizationFailed(null, syncFailed);
    }

    @Deprecated
    public boolean synchronizationFailed(Session session, SynchronizationFailed syncFailed) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.impl.synchronizationFailed(session, syncFailed);
    }

    public org.dataone.service.types.v1.Node getCapabilities() throws NotImplemented, ServiceFailure {
        Node node = this.impl.getCapabilities();
        org.dataone.service.types.v1.Node retNode = null;
        try {
            retNode = (org.dataone.service.types.v1.Node)TypeFactory.convertTypeFromType((Object)node, org.dataone.service.types.v1.Node.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("4801", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return retNode;
    }

    public org.dataone.service.types.v1.Log getLogRecords(Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.getLogRecords(null, fromDate, toDate, event, pidFilter, start, count);
    }

    @Deprecated
    public org.dataone.service.types.v1.Log getLogRecords(Session session, Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        org.dataone.service.types.v1.Log retLog = new org.dataone.service.types.v1.Log();
        if (pidFilter != null && !pidFilter.trim().equals("")) {
            String serviceFailure = "1490";
            String notFound = "1020";
            Identifier pid = new Identifier();
            pid.setValue(pidFilter);
            try {
                this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "The given PID: " + pid.getValue() + " doesn't exist in this node");
            }
            catch (NotFound e) {
                this.logMetacat.info((Object)e.getMessage());
                return retLog;
            }
        }
        String eventValue = null;
        if (event != null) {
            eventValue = event.xmlValue();
        }
        Log log = this.impl.getLogRecords(session, fromDate, toDate, eventValue, pidFilter, start, count);
        try {
            retLog = (org.dataone.service.types.v1.Log)TypeFactory.convertTypeFromType((Object)log, org.dataone.service.types.v1.Log.class);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1490", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return retLog;
    }

    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        return this.impl.ping();
    }

    public boolean isAuthorized(Identifier pid, Permission permission) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        String serviceFailure = "1760";
        String notFound = "1800";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.isAuthorized(null, pid, permission);
    }

    @Deprecated
    public boolean isAuthorized(Session session, Identifier pid, Permission permission) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        String serviceFailure = "1760";
        String notFound = "1800";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.isAuthorized(session, pid, permission);
    }

    public boolean systemMetadataChanged(Identifier pid, long serialVersion, Date dateSysMetaLastModified) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        String serviceFailure = "1333";
        String notFound = "1800";
        try {
            this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata of the object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The system metadata of the object specified by " + pid.getValue() + " does not exist at this node.");
        }
        catch (NotFound e) {
            throw new ServiceFailure(serviceFailure, e.getMessage());
        }
        boolean needCheckAuthoriativeNode = false;
        return this.impl.systemMetadataChanged(needCheckAuthoriativeNode, null, pid, serialVersion, dateSysMetaLastModified);
    }

    @Deprecated
    public boolean systemMetadataChanged(Session session, Identifier pid, long serialVersion, Date dateSysMetaLastModified) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        String serviceFailure = "1333";
        String notFound = "1800";
        try {
            this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata of the object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The system metadata of the object specified by " + pid.getValue() + " does not exist at this node.");
        }
        catch (NotFound e) {
            throw new ServiceFailure(serviceFailure, e.getMessage());
        }
        boolean needCheckAuthoriativeNode = false;
        return this.impl.systemMetadataChanged(needCheckAuthoriativeNode, session, pid, serialVersion, dateSysMetaLastModified);
    }

    public Identifier publish(Session session, Identifier originalIdentifier) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest, NotFound, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, IOException {
        String serviceFailure = "1030";
        String notFound = "1020";
        this.impl.checkV1SystemMetaPidExist(originalIdentifier, serviceFailure, "The system metadata of the object specified by " + originalIdentifier.getValue() + " couldn't be identified if it exists", notFound, "The system metadata of the object specified by " + originalIdentifier.getValue() + " does not exist at this node.");
        return this.impl.publish(session, originalIdentifier);
    }

    public InputStream view(Session session, String format, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        String serviceFailure = "2831";
        String notFound = "2835";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata of the object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The system metadata of the object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.view(session, format, pid);
    }

    public InputStream getPackage(Session session, ObjectFormatIdentifier formatId, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        String serviceFailure = "2871";
        String notFound = "2875";
        this.impl.checkV1SystemMetaPidExist(pid, serviceFailure, "The system metadata of the object specified by " + pid.getValue() + " couldn't be identified if it exists", notFound, "The system metadata of the object specified by " + pid.getValue() + " does not exist at this node.");
        return this.impl.getPackage(session, formatId, pid);
    }
}

