/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.dataquery.MetacatDatabaseConnectionPoolFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.dspace.foresite.ResourceMap;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.ecoinformatics.datamanager.parser.DataPackage;

public class MetacatPopulator {
    private String sourceUrl = null;
    private String destinationUrl = null;
    private String query = null;
    private String username = null;
    private String password = null;
    private Session session = null;
    private String subjectDN = null;

    public MetacatPopulator(String sourceUrl, String destUrl, String query, String username, String password) {
        this.sourceUrl = sourceUrl;
        this.query = query;
        this.username = username;
        this.password = password;
        this.destinationUrl = destUrl;
        this.session = null;
        this.subjectDN = CertificateManager.getInstance().getSubjectDN(CertificateManager.getInstance().loadCertificate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate() throws Exception {
        String params = "returndoctype=eml://ecoinformatics.org/eml-2.1.0&returndoctype=eml://ecoinformatics.org/eml-2.0.1&returndoctype=eml://ecoinformatics.org/eml-2.0.0&";
        params = params + "action=query&";
        params = params + "qformat=xml&";
        params = params + "anyfield=" + this.query;
        this.printHeader("Searching source");
        System.out.println("searching '" + this.sourceUrl + "' for '" + this.query + "'");
        InputStream is = this.getResponse(this.sourceUrl, "/metacat", params, "POST");
        String response = IOUtils.toString((InputStream)is, (String)"UTF-8");
        Vector<Document> docs = this.parseResponse(response);
        this.printHeader("Parsing source results");
        System.out.println("creating MN with url: " + this.destinationUrl + "/");
        MNode mn = D1Client.getMN((String)(this.destinationUrl + "/"));
        this.printHeader("Processing " + docs.size() + " results.");
        for (int i = 0; i < docs.size(); ++i) {
            HashMap idMap = new HashMap();
            ArrayList<Identifier> dataIds = new ArrayList<Identifier>();
            Document doc = docs.get(i);
            String docid = doc.docid;
            this.printHeader("Getting document " + doc.docid + " from source " + this.sourceUrl);
            params = "action=read&qformat=xml&docid=" + docid;
            is = this.getResponse(this.sourceUrl, "/metacat", params, "POST");
            String doctext = IOUtils.toString((InputStream)is, (String)"UTF-8");
            System.out.println("doctext: " + doctext);
            is = IOUtils.toInputStream((String)doctext, (String)"UTF-8");
            DatabaseConnectionPoolInterface connectionPool = MetacatDatabaseConnectionPoolFactory.getDatabaseConnectionPoolInterface();
            DataManager dataManager = DataManager.getInstance((DatabaseConnectionPoolInterface)connectionPool, (String)connectionPool.getDBAdapterName());
            DataPackage dataPackage = dataManager.parseMetadata(is);
            if (dataPackage == null) continue;
            is = IOUtils.toInputStream((String)doctext, (String)"UTF-8");
            doc.doctext = doctext;
            this.printHeader("creating document on destination " + this.destinationUrl);
            SystemMetadata sysmeta = this.generateSystemMetadata(doc);
            if (dataPackage.getEntityList() != null) {
                for (int j = 0; j < dataPackage.getEntityList().length; ++j) {
                    String dataDocUrl = dataPackage.getEntityList()[j].getURL();
                    String dataDocMimeType = dataPackage.getEntityList()[j].getDataFormat();
                    if (dataDocMimeType == null) {
                        dataDocMimeType = ObjectFormatCache.getInstance().getFormat("application/octet-stream").getFormatId().getValue();
                    }
                    String dataDocLocalId = "";
                    if (dataDocUrl.trim().startsWith("ecogrid://knb/")) {
                        dataDocLocalId = dataDocUrl.substring(dataDocUrl.indexOf("ecogrid://knb/") + "ecogrid://knb/".length(), dataDocUrl.length());
                        params = "action=read&qformat=xml&docid=" + dataDocLocalId;
                        InputStream dataDocIs = this.getResponse(this.sourceUrl, "/metacat", params, "POST");
                        String dataDocText = IOUtils.toString((InputStream)dataDocIs, (String)"UTF-8");
                        Identifier did = new Identifier();
                        did.setValue(dataDocLocalId);
                        dataIds.add(did);
                        SystemMetadata dataDocSysMeta = this.generateSystemMetadata(doc);
                        dataDocSysMeta.setIdentifier(did);
                        ObjectFormat format = null;
                        try {
                            format = ObjectFormatCache.getInstance().getFormat(dataDocMimeType);
                            dataDocSysMeta.setFormatId(format.getFormatId());
                        }
                        catch (NotFound e) {
                            System.out.println(e.getMessage());
                        }
                        dataDocIs = IOUtils.toInputStream((String)dataDocText, (String)"UTF-8");
                        String algorithm = PropertyService.getProperty("dataone.checksumAlgorithm.default");
                        Checksum checksum = ChecksumUtil.checksum((InputStream)dataDocIs, (String)algorithm);
                        dataDocSysMeta.setChecksum(checksum);
                        String sizeStr = Long.toString(dataDocText.getBytes("UTF-8").length);
                        dataDocSysMeta.setSize(new BigInteger(sizeStr));
                        boolean error = false;
                        try {
                            mn.create(this.session, dataDocSysMeta.getIdentifier(), IOUtils.toInputStream((String)dataDocText, (String)"UTF-8"), dataDocSysMeta);
                            continue;
                        }
                        catch (Exception e) {
                            error = true;
                            System.out.println("ERROR: Could not create data document with id " + dataDocSysMeta.getIdentifier().getValue() + " : " + e.getMessage());
                            continue;
                        }
                        finally {
                            if (error) {
                                this.printHeader("Insertion of document " + dataDocSysMeta.getIdentifier().getValue() + "FAILED.");
                            } else {
                                this.printHeader("Done inserting document " + dataDocSysMeta.getIdentifier().getValue() + " which is described by " + sysmeta.getIdentifier().getValue());
                            }
                        }
                    }
                    System.out.println("WARNING: Could not process describes url " + dataDocUrl + " for document " + doc.docid + ".  Only ecogrid://knb/ urls are currently supported.");
                }
            }
            try {
                Identifier id = mn.create(this.session, sysmeta.getIdentifier(), IOUtils.toInputStream((String)doc.doctext, (String)"UTF-8"), sysmeta);
                System.out.println("Success inserting document " + id.getValue());
                if (dataIds.isEmpty()) continue;
                Identifier resourceMapId = new Identifier();
                resourceMapId.setValue("resourceMap_" + sysmeta.getIdentifier().getValue());
                idMap.put(sysmeta.getIdentifier(), dataIds);
                ResourceMap rm = ResourceMapFactory.getInstance().createResourceMap(resourceMapId, idMap);
                String resourceMapXML = ResourceMapFactory.getInstance().serializeResourceMap(rm);
                Document rmDoc = new Document(resourceMapId.getValue(), "http://www.openarchives.org/ore/terms", "", "");
                rmDoc.doctext = resourceMapXML;
                SystemMetadata resourceMapSysMeta = this.generateSystemMetadata(rmDoc);
                mn.create(this.session, resourceMapId, IOUtils.toInputStream((String)resourceMapXML, (String)"UTF-8"), resourceMapSysMeta);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Could not create document with id " + sysmeta.getIdentifier().getValue() + " : " + e.getMessage());
                continue;
            }
            finally {
                this.printHeader("Done processing document " + sysmeta.getIdentifier().getValue());
            }
        }
    }

    private SystemMetadata generateSystemMetadata(Document doc) throws Exception {
        SystemMetadata sm = new SystemMetadata();
        sm.setSerialVersion(BigInteger.valueOf(1L));
        Identifier id = new Identifier();
        id.setValue(doc.docid.trim());
        sm.setIdentifier(id);
        ObjectFormat format = ObjectFormatCache.getInstance().getFormat(doc.doctype);
        if (format == null) {
            format = doc.doctype.trim().equals("BIN") ? ObjectFormatCache.getInstance().getFormat("application/octet-stream") : ObjectFormatCache.getInstance().getFormat("text/plain");
        }
        sm.setFormatId(format.getFormatId());
        ByteArrayInputStream bais = new ByteArrayInputStream(doc.doctext.getBytes("UTF-8"));
        String algorithm = PropertyService.getProperty("dataone.checksumAlgorithm.default");
        Checksum checksum = ChecksumUtil.checksum((InputStream)bais, (String)algorithm);
        sm.setChecksum(checksum);
        String sizeStr = Long.toString(doc.doctext.getBytes("UTF-8").length);
        sm.setSize(new BigInteger(sizeStr));
        Subject p = new Subject();
        p.setValue(this.subjectDN);
        sm.setSubmitter(p);
        sm.setRightsHolder(p);
        try {
            Date dateCreated = this.parseMetacatDate(doc.createDate);
            sm.setDateUploaded(dateCreated);
            Date dateUpdated = this.parseMetacatDate(doc.updateDate);
            sm.setDateSysMetadataModified(dateUpdated);
        }
        catch (Exception e) {
            System.out.println("couldn't parse a date: " + e.getMessage());
            Date dateCreated = new Date();
            sm.setDateUploaded(dateCreated);
            Date dateUpdated = new Date();
            sm.setDateSysMetadataModified(dateUpdated);
        }
        NodeReference nr = new NodeReference();
        nr.setValue(PropertyService.getProperty("dataone.nodeId"));
        sm.setOriginMemberNode(nr);
        sm.setAuthoritativeMemberNode(nr);
        AccessPolicy accessPolicy = new AccessPolicy();
        AccessRule accessRule = new AccessRule();
        accessRule.addPermission(Permission.READ);
        Subject subject = new Subject();
        subject.setValue("public");
        accessRule.addSubject(subject);
        accessPolicy.addAllow(accessRule);
        sm.setAccessPolicy(accessPolicy);
        return sm;
    }

    private void printHeader(String s) {
        System.out.println("****** " + s + " *******");
    }

    private Date parseMetacatDate(String date) {
        String year = date.substring(0, 4);
        String month = date.substring(5, 7);
        String day = date.substring(8, 10);
        Calendar c = Calendar.getInstance();
        c.set(new Integer(year), new Integer(month), new Integer(day));
        return c.getTime();
    }

    private Vector<Document> parseResponse(String response) {
        Vector<Document> v = new Vector<Document>();
        int dstart = response.indexOf("<document>");
        int dend = response.indexOf("</document>", dstart);
        while (dstart != -1) {
            String doc = response.substring(dstart + "<document>".length(), dend);
            Document d = new Document(this.getFieldFromDoc(doc, "docid"), this.getFieldFromDoc(doc, "doctype"), this.getFieldFromDoc(doc, "createdate"), this.getFieldFromDoc(doc, "updatedate"));
            v.add(d);
            dstart = response.indexOf("<document>", dend);
            dend = response.indexOf("</document>", dstart);
        }
        return v;
    }

    private String getFieldFromDoc(String doc, String fieldname) {
        String field = "<" + fieldname + ">";
        String fieldend = "</" + fieldname + ">";
        int start = doc.indexOf(field);
        int end = doc.indexOf(fieldend);
        String s = doc.substring(start + field.length(), end);
        return s;
    }

    private String login() throws Exception {
        InputStream is = this.getResponse(this.sourceUrl, "/metacat", "action=login&username=" + this.username + "&password=" + this.password + "&qformat=xml", "POST");
        String response = IOUtils.toString((InputStream)is, (String)"UTF-8");
        if (response.indexOf("sessionId") == -1) {
            throw new Exception("Error logging into " + this.sourceUrl);
        }
        String sessionid = response.substring(response.indexOf("<sessionId>") + "<sessionId>".length(), response.indexOf("</sessionId>"));
        System.out.println("sessionid: " + sessionid);
        return sessionid;
    }

    private void logout() throws Exception {
        this.getResponse(this.sourceUrl, "/metacat", "action=logout&username=" + this.username, "POST");
    }

    private InputStream getResponse(String contextRootUrl, String resource, String urlParameters, String method) throws Exception {
        HttpURLConnection connection = null;
        String restURL = contextRootUrl + resource;
        if (urlParameters != null) {
            if (restURL.indexOf("?") == -1) {
                restURL = restURL + "?";
            }
            if ((restURL = restURL + urlParameters).indexOf(" ") != -1) {
                restURL = restURL.replaceAll("\\s", "%20");
            }
        }
        URL u = null;
        InputStream content = null;
        System.out.println("url: " + restURL);
        System.out.println("method: " + method);
        u = new URL(restURL);
        connection = (HttpURLConnection)u.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod(method);
        content = connection.getInputStream();
        return content;
    }

    private class Document {
        public String docid;
        public String doctype;
        public String createDate;
        public String updateDate;
        public String doctext;

        public Document(String docid, String doctype, String createDate, String updateDate) {
            this.docid = docid.trim();
            this.doctype = doctype.trim();
            this.createDate = createDate.trim();
            this.updateDate = updateDate.trim();
        }
    }
}

