/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.MetaDataGroup;
import edu.ucsb.nceas.utilities.MetaDataProperty;
import edu.ucsb.nceas.utilities.XMLProperties;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMetaData {
    private TreeMap<String, MetaDataProperty> propertyMap;
    private TreeMap<Integer, MetaDataGroup> groupMap;

    public PropertiesMetaData(String propFileName) throws IOException, TransformerException {
        File xmlPropsFile = new File(propFileName);
        this.propertyMap = new TreeMap();
        this.groupMap = new TreeMap();
        XMLProperties metadataProperties = new XMLProperties();
        metadataProperties.load(xmlPropsFile);
        this.load(metadataProperties);
    }

    public synchronized void setMetadata(String key, String label, int groupId, int index, String description, String helpFile) {
        MetaDataProperty metaData = this.propertyMap.get(key);
        if (metaData == null) {
            metaData = new MetaDataProperty(key, label, groupId, index, description, helpFile);
        } else {
            metaData.setKey(key);
            metaData.setLabel(label);
            metaData.setGroupId(groupId);
            metaData.setIndex(index);
            metaData.setDescription(description);
            metaData.setHelpFile(helpFile);
        }
        this.propertyMap.put(key, metaData);
    }

    public synchronized MetaDataGroup getGroup(int groupId) {
        return this.getGroups().get(new Integer(groupId));
    }

    public synchronized Map<Integer, MetaDataGroup> getGroups() {
        return this.groupMap;
    }

    public synchronized Map<String, MetaDataProperty> getProperties() {
        return this.propertyMap;
    }

    public synchronized Set<String> getKeys() {
        return this.propertyMap.keySet();
    }

    public synchronized SortedMap<Integer, MetaDataProperty> getPropertiesInGroup(int groupId) {
        TreeMap<Integer, MetaDataProperty> groupPropertyMap = new TreeMap<Integer, MetaDataProperty>();
        for (String key : this.propertyMap.keySet()) {
            MetaDataProperty metadata = this.propertyMap.get(key);
            if (metadata == null || metadata.getGroupId() != groupId) continue;
            groupPropertyMap.put(new Integer(metadata.getIndex()), metadata);
        }
        return groupPropertyMap;
    }

    public synchronized void load(XMLProperties metadataProperties) throws TransformerException {
        String[] groupArray = metadataProperties.getProperty("/metadataConfig/group");
        MetaDataGroup defaultGroup = new MetaDataGroup();
        defaultGroup.setIndex(0);
        defaultGroup.setName("Hidden Group");
        defaultGroup.setComment("Group for hidden values");
        defaultGroup.setDescription("This group holds values that will not show up on the configuration page, but we want to be persisted to backup properties.");
        this.groupMap.put(0, defaultGroup);
        for (int i = 1; i <= groupArray.length; ++i) {
            Integer intIndex;
            String xPathPrefix = "/metadataConfig/group[" + i + "]";
            String[] indexArray = metadataProperties.getProperty(xPathPrefix + "/index");
            String[] nameArray = metadataProperties.getProperty(xPathPrefix + "/name");
            String[] commentArray = metadataProperties.getProperty(xPathPrefix + "/comment");
            String[] descriptionArray = metadataProperties.getProperty(xPathPrefix + "/description");
            String[] helpFileArray = metadataProperties.getProperty(xPathPrefix + "/helpFile");
            if (indexArray == null || nameArray == null) {
                throw new TransformerException("PropertiesMetaData.load - Could not process a metadata group properties record. One of the following values is null: name or index");
            }
            try {
                intIndex = Integer.parseInt(indexArray[0]);
            }
            catch (NumberFormatException nfe) {
                throw new TransformerException("PropertiesMetaData.load - Could not process a metadata properties record. index was not a valid integer for group: " + nameArray[0]);
            }
            MetaDataGroup group = new MetaDataGroup();
            group.setIndex(intIndex);
            group.setName(nameArray[0]);
            if (commentArray != null) {
                group.setComment(commentArray[0]);
            }
            if (descriptionArray != null) {
                group.setDescription(descriptionArray[0]);
            }
            if (helpFileArray != null) {
                group.setHelpFile(helpFileArray[0]);
            }
            this.groupMap.put(intIndex, group);
        }
        String[] configArray = metadataProperties.getProperty("/metadataConfig/config");
        int configArrayLength = 0;
        if (configArray != null) {
            configArrayLength = configArray.length;
        }
        for (int i = 1; i <= configArrayLength; ++i) {
            Integer intGroupId;
            Integer intIndex;
            String xPathPrefix = "/metadataConfig/config[" + i + "]";
            String[] keyArray = metadataProperties.getProperty(xPathPrefix + "/key");
            String[] labelArray = metadataProperties.getProperty(xPathPrefix + "/label");
            String[] groupIdArray = metadataProperties.getProperty(xPathPrefix + "/group");
            String[] indexArray = metadataProperties.getProperty(xPathPrefix + "/index");
            String[] descriptionArray = metadataProperties.getProperty(xPathPrefix + "/description");
            String[] helpFileArray = metadataProperties.getProperty(xPathPrefix + "/helpFile");
            String[] fieldTypeArray = metadataProperties.getProperty(xPathPrefix + "/fieldType");
            String[] isRequired = metadataProperties.getProperty(xPathPrefix + "/required");
            if (keyArray == null || labelArray == null || groupIdArray == null || indexArray == null) {
                throw new TransformerException("PropertiesMetaData.load - Could not process a metadata properties +record. One of the following values is null: key, label, group or index");
            }
            try {
                intIndex = Integer.parseInt(indexArray[0]);
                intGroupId = Integer.parseInt(groupIdArray[0]);
            }
            catch (NumberFormatException nfe) {
                throw new TransformerException("Could not process a metadata properties record. index was not a valid integer for key: " + keyArray[0] + " : " + nfe.getMessage());
            }
            MetaDataProperty metadata = new MetaDataProperty();
            metadata.setKey(keyArray[0]);
            metadata.setLabel(labelArray[0]);
            metadata.setGroupId(intGroupId);
            metadata.setIndex(intIndex);
            if (descriptionArray != null) {
                metadata.setDescription(descriptionArray[0]);
            }
            if (helpFileArray != null) {
                metadata.setHelpFile(helpFileArray[0]);
            }
            try {
                if (fieldTypeArray != null) {
                    metadata.setFieldType(fieldTypeArray[0]);
                    Vector<String> fieldOptionNames = new Vector<String>();
                    Vector<String> fieldOptionValues = new Vector<String>();
                    if (fieldTypeArray[0].equals("select")) {
                        String[] optionArray = metadataProperties.getProperty(xPathPrefix + "/option");
                        for (int j = 1; j <= optionArray.length; ++j) {
                            String[] fieldOptionArray = metadataProperties.getProperty(xPathPrefix + "/option[" + j + "]/name");
                            String[] fieldValueArray = metadataProperties.getProperty(xPathPrefix + "/option[" + j + "]/value");
                            if (fieldOptionArray == null || fieldValueArray == null) {
                                throw new TransformerException("PropertiesMetaData.load - Both name and value must be specified for metadata element: ");
                            }
                            fieldOptionNames.add(fieldOptionArray[0]);
                            fieldOptionValues.add(fieldValueArray[0]);
                        }
                    }
                    metadata.setFieldOptionNames(fieldOptionNames);
                    metadata.setFieldOptionValues(fieldOptionValues);
                } else {
                    metadata.setFieldType("text");
                }
            }
            catch (GeneralPropertyException gpe) {
                throw new TransformerException("PropertiesMetaData.load - Property error while processing key: " + keyArray[0] + " : " + gpe.getMessage());
            }
            if (isRequired != null && isRequired[0].equals("true")) {
                metadata.setIsRequired(true);
            }
            this.propertyMap.put(keyArray[0], metadata);
        }
    }
}

