/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import HTTPClient.FilenameMangler;
import HTTPClient.NVPair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.BitSet;

public class MultipartForm {
    private static BitSet BoundChar;
    private static final String ContDisp = "\r\nContent-Disposition: form-data; name=\"";
    private static final String FileName = "\"; filename=\"";
    private static final String ContType = "\r\nContent-Type: ";
    private static final String Boundary = "\r\n----------ieoau._._+2_8_8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----";
    private static NVPair[] dummy;
    private byte[] boundary = "\r\n----------ieoau._._+2_8_8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----".getBytes("8859_1");
    private byte[] cont_disp = "\r\nContent-Disposition: form-data; name=\"".getBytes("8859_1");
    private byte[] cont_type = "\r\nContent-Type: ".getBytes("8859_1");
    private byte[] filename = "\"; filename=\"".getBytes("8859_1");
    private long encodedLength;
    private NVPair[] opts;
    private NVPair[] files;
    private FilenameMangler mangler;
    private NVPair content_header = null;

    public MultipartForm(NVPair[] opts, NVPair[] files, FilenameMangler mangler) throws IOException {
        this.opts = opts;
        this.files = files;
        this.mangler = mangler;
        this.encodedLength = this.calculateLength();
    }

    public MultipartForm(NVPair[] opts, NVPair[] files) throws IOException {
        this(opts, files, null);
    }

    private long calculateLength() throws IOException {
        int len = 0;
        int hdr_len = this.boundary.length + this.cont_disp.length + 1 + 2 + 2;
        if (this.opts == null) {
            this.opts = dummy;
        }
        if (this.files == null) {
            this.files = dummy;
        }
        int idx = 0;
        while (idx < this.opts.length) {
            if (this.opts[idx] != null) {
                len += hdr_len + this.opts[idx].getName().length() + this.opts[idx].getValue().length();
            }
            ++idx;
        }
        int idx2 = 0;
        while (idx2 < this.files.length) {
            if (this.files[idx2] != null) {
                File file = new File(this.files[idx2].getValue());
                String fname = file.getName();
                if (this.mangler != null) {
                    fname = this.mangler.mangleFilename(fname, this.files[idx2].getName());
                }
                if (fname != null) {
                    len += hdr_len + this.files[idx2].getName().length() + this.filename.length;
                    len = (int)((long)len + ((long)fname.length() + file.length()));
                    String ct = CT.getContentType(file.getName());
                    if (ct != null) {
                        len += this.cont_type.length + ct.length();
                    }
                }
            }
            ++idx2;
        }
        if (len == 0) {
            this.content_header = new NVPair("Content-Type", "application/octet-stream");
            return len;
        }
        this.content_header = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(this.boundary, 4, this.boundary.length - 4, "8859_1"));
        len -= 2;
        return len += this.boundary.length + 2 + 2;
    }

    public void writeEncodedMultipartForm(OutputStream out) throws IOException {
        this.writeEncodedMultipartForm(out, 4096);
    }

    public void writeEncodedMultipartForm(OutputStream out, int bufferSize) throws IOException {
        int pos = 0;
        int new_c = 0x30303030;
        if (new_c != 0x7A7A7A7A) {
            pos = 0;
            while (!BoundChar.get(new_c & 0xFF)) {
                ++new_c;
            }
            while (!BoundChar.get(new_c >> 8 & 0xFF)) {
                new_c += 256;
            }
            while (!BoundChar.get(new_c >> 16 & 0xFF)) {
                new_c += 65536;
            }
            while (!BoundChar.get(new_c >> 24 & 0xFF)) {
                new_c += 0x1000000;
            }
            int off = 2;
            int idx = 0;
            while (idx < this.opts.length) {
                if (this.opts[idx] != null) {
                    out.write(this.boundary, off, this.boundary.length - off);
                    off = 0;
                    int start = pos += this.boundary.length - off;
                    out.write(this.cont_disp, 0, this.cont_disp.length);
                    pos += this.cont_disp.length;
                    int nlen = this.opts[idx].getName().length();
                    out.write(this.opts[idx].getName().getBytes("8859_1"), 0, nlen);
                    pos += nlen;
                    out.write(34);
                    ++pos;
                    out.write(13);
                    ++pos;
                    out.write(10);
                    ++pos;
                    out.write(13);
                    ++pos;
                    out.write(10);
                    ++pos;
                    out.flush();
                    int vlen = this.opts[idx].getValue().length();
                    out.write(this.opts[idx].getValue().getBytes("8859_1"), 0, vlen);
                    out.flush();
                    pos += vlen;
                }
                ++idx;
            }
            int idx2 = 0;
            while (idx2 < this.files.length) {
                if (this.files[idx2] != null) {
                    File file = new File(this.files[idx2].getValue());
                    String fname = file.getName();
                    if (this.mangler != null) {
                        fname = this.mangler.mangleFilename(fname, this.files[idx2].getName());
                    }
                    if (fname != null) {
                        out.write(this.boundary, off, this.boundary.length - off);
                        off = 0;
                        int start = pos += this.boundary.length - off;
                        out.write(this.cont_disp, 0, this.cont_disp.length);
                        pos += this.cont_disp.length;
                        int nlen = this.files[idx2].getName().length();
                        out.write(this.files[idx2].getName().getBytes("8859_1"), 0, nlen);
                        pos += nlen;
                        out.write(this.filename, 0, this.filename.length);
                        pos += this.filename.length;
                        nlen = fname.length();
                        out.write(fname.getBytes("8859_1"), 0, nlen);
                        pos += nlen;
                        out.write(34);
                        ++pos;
                        String ct = CT.getContentType(file.getName());
                        if (ct != null) {
                            out.write(this.cont_type, 0, this.cont_type.length);
                            pos += this.cont_type.length;
                            out.write(ct.getBytes("8859_1"), 0, ct.length());
                            pos += ct.length();
                        }
                        out.write(13);
                        ++pos;
                        out.write(10);
                        ++pos;
                        out.write(13);
                        ++pos;
                        out.write(10);
                        ++pos;
                        out.flush();
                        FileInputStream fs = new FileInputStream(file);
                        byte[] buf = new byte[bufferSize];
                        int cnt = 0;
                        while (cnt != -1) {
                            cnt = fs.read(buf);
                            if (cnt == -1) continue;
                            out.write(buf, 0, cnt);
                            out.flush();
                            pos += cnt;
                        }
                        fs.close();
                    }
                }
                ++idx2;
            }
        }
        out.write(this.boundary, 0, this.boundary.length);
        pos += this.boundary.length;
        out.write(45);
        ++pos;
        out.write(45);
        ++pos;
        out.write(13);
        ++pos;
        out.write(10);
        out.flush();
        out.close();
        if ((long)(++pos) != this.getLength()) {
            throw new Error("Calculated " + this.getLength() + " bytes but wrote " + pos + " bytes!");
        }
        this.content_header = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(this.boundary, 4, this.boundary.length - 4, "8859_1"));
    }

    public long getLength() {
        return this.encodedLength;
    }

    public String getContentType() {
        return this.content_header.getValue();
    }

    static {
        dummy = new NVPair[0];
        BoundChar = new BitSet(256);
        int ch = 48;
        while (ch <= 57) {
            BoundChar.set(ch);
            ++ch;
        }
        int ch2 = 65;
        while (ch2 <= 90) {
            BoundChar.set(ch2);
            ++ch2;
        }
        int ch3 = 97;
        while (ch3 <= 122) {
            BoundChar.set(ch3);
            ++ch3;
        }
        BoundChar.set(43);
        BoundChar.set(95);
        BoundChar.set(45);
        BoundChar.set(46);
    }

    private static class CT
    extends URLConnection {
        protected static final String getContentType(String fname) {
            return URLConnection.guessContentTypeFromName(fname);
        }

        private CT() {
            super(null);
        }

        public void connect() {
        }
    }
}

