/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLProperties {
    private Node root;
    private Document doc;
    private File xmlPropsFile;
    private InputStream xmlPropsSource;
    private static String OUTPUT_FORMAT = "UTF-8";
    private final StringBuffer propResultBuff = new StringBuffer();
    private Iterator emptyIterator = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    };

    public void load(InputStream xmlPropsSource) throws IOException {
        this.xmlPropsSource = xmlPropsSource;
        this.init(xmlPropsSource);
    }

    private void init(InputStream xmlPropsSource) throws IOException {
        InputStreamReader sr = new InputStreamReader(xmlPropsSource);
        this.root = XMLUtilities.getXMLReaderAsDOMTreeRootNode(sr);
    }

    public String[] getProperty(String keyXPath) throws TransformerException {
        NodeList nl = XMLUtilities.getNodeListWithXPath(this.root, keyXPath);
        if (nl == null) {
            return null;
        }
        int totChildren = nl.getLength();
        if (totChildren < 1) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Node nextChild = null;
        int i = 0;
        while (i < nl.getLength()) {
            NodeList cnl = nl.item(i).getChildNodes();
            if (cnl != null && cnl.getLength() >= 1) {
                this.propResultBuff.delete(0, this.propResultBuff.length());
                int ci = 0;
                while (ci < cnl.getLength()) {
                    nextChild = cnl.item(ci);
                    if (nextChild.getNodeType() == 3 || nextChild.getNodeType() == 4) {
                        this.propResultBuff.append(nextChild.getNodeValue().trim());
                    }
                    ++ci;
                }
                resultList.add(this.propResultBuff.toString());
            }
            ++i;
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public String setProperty(String key, String value) throws TransformerException {
        String[] resultArray = this.getProperty(key);
        XMLUtilities.addTextNodeToDOMTree(this.root, key, value);
        return resultArray != null ? resultArray[0] : null;
    }

    public void store() {
        FileOutputStream out = null;
        if (!this.xmlPropsFile.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot write to properties file: " + this.xmlPropsFile.getName() + " !", "alert", 0);
        } else {
            try {
                out = new FileOutputStream(this.xmlPropsFile);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Cannot write to properties file: " + this.xmlPropsFile.getName() + " !", "alert", 0);
            }
        }
        this.store(out);
    }

    public void store(OutputStream out) {
        PrintWriter pw = new PrintWriter(out, true);
        this.list(pw);
    }

    public void list(PrintWriter out) {
        XMLUtilities.print(this.root, out, OUTPUT_FORMAT);
    }

    public void list(PrintStream out) {
        this.store(out);
    }

    public Iterator propertyNames() {
        OrderedMap nvpMap = XMLUtilities.getDOMTreeAsXPathMap(this.root);
        if (nvpMap == null) {
            return this.emptyIterator;
        }
        Set nvpSet = nvpMap.keySet();
        if (nvpSet == null) {
            return this.emptyIterator;
        }
        return nvpSet.iterator();
    }
}

