/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class CERTRecord
extends Record {
    public static final int PKIX = 1;
    public static final int SPKI = 2;
    public static final int PGP = 3;
    public static final int URL = 253;
    public static final int OID = 254;
    private static CERTRecord member = new CERTRecord();
    private short certType;
    private short keyTag;
    private byte alg;
    private byte[] cert;

    private CERTRecord() {
    }

    private CERTRecord(Name name, short dclass, int ttl) {
        super(name, (short)37, dclass, ttl);
    }

    static CERTRecord getMember() {
        return member;
    }

    public CERTRecord(Name name, short dclass, int ttl, int certType, int keyTag, int alg, byte[] cert) {
        this(name, dclass, ttl);
        this.certType = (short)certType;
        this.keyTag = (short)keyTag;
        this.alg = (byte)alg;
        this.cert = cert;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        CERTRecord rec = new CERTRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.certType = in.readShort();
        rec.keyTag = (short)in.readUnsignedShort();
        rec.alg = in.readByte();
        if (length > 5) {
            rec.cert = new byte[length - 5];
            in.read(rec.cert);
        }
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        CERTRecord rec = new CERTRecord(name, dclass, ttl);
        rec.certType = (short)Integer.parseInt(st.nextToken());
        rec.keyTag = (short)Integer.parseInt(st.nextToken());
        rec.alg = (byte)Integer.parseInt(st.nextToken());
        rec.cert = base64.fromString(st.remainingTokens());
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.cert != null) {
            sb.append(this.certType);
            sb.append(" ");
            sb.append(this.keyTag & 0xFFFF);
            sb.append(" ");
            sb.append(this.alg);
            if (this.cert != null) {
                sb.append(" (\n");
                sb.append(base64.formatString(this.cert, 64, "\t", true));
            }
        }
        return sb.toString();
    }

    public short getCertType() {
        return this.certType;
    }

    public short getKeyTag() {
        return this.keyTag;
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public byte[] getCert() {
        return this.cert;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.cert == null) {
            return;
        }
        out.writeShort(this.certType);
        out.writeShort(this.keyTag);
        out.writeByte(this.alg);
        out.writeArray(this.cert);
    }
}

