/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class KEYRecord
extends Record {
    private static KEYRecord member = new KEYRecord();
    private short flags;
    private byte proto;
    private byte alg;
    private byte[] key;
    private int footprint = -1;
    public static final int FLAG_NOCONF = 32768;
    public static final int FLAG_NOAUTH = 16384;
    public static final int FLAG_NOKEY = 49152;
    public static final int OWNER_ZONE = 256;
    public static final int OWNER_HOST = 512;
    public static final int OWNER_USER = 0;
    public static final int PROTOCOL_TLS = 1;
    public static final int PROTOCOL_EMAIL = 2;
    public static final int PROTOCOL_DNSSEC = 3;
    public static final int PROTOCOL_IPSEC = 4;
    public static final int PROTOCOL_ANY = 255;

    private KEYRecord() {
    }

    private KEYRecord(Name name, short dclass, int ttl) {
        super(name, (short)25, dclass, ttl);
    }

    static KEYRecord getMember() {
        return member;
    }

    public KEYRecord(Name name, short dclass, int ttl, int flags, int proto, int alg, byte[] key) {
        this(name, dclass, ttl);
        this.flags = (short)flags;
        this.proto = (byte)proto;
        this.alg = (byte)alg;
        this.key = key;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        KEYRecord rec = new KEYRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.flags = in.readShort();
        rec.proto = in.readByte();
        rec.alg = in.readByte();
        if (length > 4) {
            rec.key = new byte[length - 4];
            in.read(rec.key);
        }
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        KEYRecord rec = new KEYRecord(name, dclass, ttl);
        rec.flags = (short)Integer.decode(st.nextToken()).intValue();
        rec.proto = (byte)Integer.parseInt(st.nextToken());
        rec.alg = (byte)Integer.parseInt(st.nextToken());
        rec.key = (byte[])((rec.flags & 0xC000) != 49152 ? base64.fromString(st.remainingTokens()) : null);
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.key != null || (this.flags & 0xC000) == 49152) {
            if (!Options.check("nohex")) {
                sb.append("0x");
                sb.append(Integer.toHexString(this.flags & 0xFFFF));
            } else {
                sb.append(this.flags & 0xFFFF);
            }
            sb.append(" ");
            sb.append(this.proto & 0xFF);
            sb.append(" ");
            sb.append(this.alg & 0xFF);
            if (this.key != null) {
                sb.append(" (\n");
                sb.append(base64.formatString(this.key, 64, "\t", true));
                sb.append(" ; key_tag = ");
                sb.append(this.getFootprint() & 0xFFFF);
            }
        }
        return sb.toString();
    }

    public short getFlags() {
        return this.flags;
    }

    public byte getProtocol() {
        return this.proto;
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public byte[] getKey() {
        return this.key;
    }

    public short getFootprint() {
        if (this.footprint >= 0) {
            return (short)this.footprint;
        }
        int foot = 0;
        DataByteOutputStream out = new DataByteOutputStream();
        this.rrToWire(out, null, false);
        byte[] rdata = out.toByteArray();
        if (this.alg == 1) {
            int d1 = rdata[rdata.length - 3] & 0xFF;
            int d2 = rdata[rdata.length - 2] & 0xFF;
            foot = (d1 << 8) + d2;
        } else {
            int d1;
            int i = 0;
            while (i < rdata.length - 1) {
                d1 = rdata[i] & 0xFF;
                int d2 = rdata[i + 1] & 0xFF;
                foot += (d1 << 8) + d2;
                i += 2;
            }
            if (i < rdata.length) {
                d1 = rdata[i] & 0xFF;
                foot += d1 << 8;
            }
            foot += foot >> 16 & 0xFFFF;
        }
        this.footprint = foot & 0xFFFF;
        return (short)this.footprint;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.key == null && (this.flags & 0xC000) != 49152) {
            return;
        }
        out.writeShort(this.flags);
        out.writeByte(this.proto);
        out.writeByte(this.alg);
        if (this.key != null) {
            out.writeArray(this.key);
        }
    }
}

