/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.client;

import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatAuthException;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.utilities.HttpMessage;
import edu.ucsb.nceas.utilities.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;

public class MetacatClient
implements Metacat {
    private String metacatUrl = null;
    private String sessionId = null;

    protected MetacatClient() {
    }

    public String login(String string, String string2) throws MetacatAuthException, MetacatInaccessibleException {
        Properties properties = new Properties();
        properties.put("action", "login");
        properties.put("qformat", "xml");
        properties.put("username", string);
        properties.put("password", string2);
        String string3 = null;
        try {
            string3 = this.sendDataForString(properties);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string3.indexOf("<login>") == -1) {
            this.setSessionId("");
            throw new MetacatAuthException(string3);
        }
        int n = string3.indexOf("<sessionId>") + 11;
        int n2 = string3.indexOf("</sessionId>");
        if (n != -1 && n2 != -1) {
            this.setSessionId(string3.substring(n, n2));
        }
        return string3;
    }

    public String logout() throws MetacatInaccessibleException, MetacatException {
        Properties properties = new Properties();
        properties.put("action", "logout");
        properties.put("qformat", "xml");
        String string = null;
        try {
            string = this.sendDataForString(properties);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string.indexOf("<logout>") == -1) {
            throw new MetacatException(string);
        }
        this.setSessionId("");
        return string;
    }

    public Reader read(String string) throws InsufficientKarmaException, MetacatInaccessibleException, MetacatException {
        PushbackReader pushbackReader = null;
        Properties properties = new Properties();
        properties.put("action", "read");
        properties.put("qformat", "xml");
        properties.put("docid", string);
        InputStream inputStream = null;
        try {
            inputStream = this.sendData(properties);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        pushbackReader = new PushbackReader(new InputStreamReader(inputStream), 512);
        try {
            char[] cArray = new char[512];
            int n = pushbackReader.read(cArray, 0, 512);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(cArray, 0, n);
            String string2 = stringWriter.toString();
            stringWriter.close();
            pushbackReader.unread(cArray, 0, n);
            if (string2.indexOf("<error>") != -1) {
                if (string2.indexOf("does not have permission") != -1) {
                    throw new InsufficientKarmaException(string2);
                }
                throw new MetacatException(string2);
            }
        }
        catch (IOException iOException) {
            throw new MetacatException("MetacatClient: Error converting Reader to String." + iOException.getMessage());
        }
        return pushbackReader;
    }

    public Reader query(Reader reader) throws MetacatInaccessibleException, IOException {
        InputStreamReader inputStreamReader = null;
        String string = null;
        string = IOUtil.getAsString((Reader)reader, (boolean)true);
        Properties properties = new Properties();
        properties.put("action", "squery");
        properties.put("qformat", "xml");
        properties.put("query", string);
        InputStream inputStream = null;
        try {
            inputStream = this.sendData(properties);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        inputStreamReader = new InputStreamReader(inputStream);
        return inputStreamReader;
    }

    public String insert(String string, Reader reader, Reader reader2) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        Object var4_4 = null;
        String string2 = null;
        String string3 = null;
        string2 = IOUtil.getAsString((Reader)reader, (boolean)true);
        if (reader2 != null) {
            string3 = IOUtil.getAsString((Reader)reader2, (boolean)true);
        }
        Properties properties = new Properties();
        properties.put("action", "insert");
        properties.put("docid", string);
        properties.put("doctext", string2);
        if (string3 != null) {
            properties.put("dtdtext", string3);
        }
        String string4 = null;
        try {
            string4 = this.sendDataForString(properties);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string4.indexOf("<error>") != -1) {
            if (string4.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string4);
            }
            throw new MetacatException(string4);
        }
        return string4;
    }

    public String update(String string, Reader reader, Reader reader2) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        Object var4_4 = null;
        String string2 = null;
        String string3 = null;
        string2 = IOUtil.getAsString((Reader)reader, (boolean)true);
        if (reader2 != null) {
            string3 = IOUtil.getAsString((Reader)reader2, (boolean)true);
        }
        Properties properties = new Properties();
        properties.put("action", "update");
        properties.put("docid", string);
        properties.put("doctext", string2);
        if (string3 != null) {
            properties.put("dtdtext", string3);
        }
        String string4 = null;
        try {
            string4 = this.sendDataForString(properties);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string4.indexOf("<error>") != -1) {
            if (string4.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string4);
            }
            throw new MetacatException(string4);
        }
        return string4;
    }

    public String delete(String string) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException {
        Properties properties = new Properties();
        properties.put("action", "delete");
        properties.put("docid", string);
        String string2 = null;
        try {
            string2 = this.sendDataForString(properties);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string2.indexOf("<error>") != -1) {
            if (string2.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string2);
            }
            throw new MetacatException(string2);
        }
        return string2;
    }

    public void setMetacatUrl(String string) {
        this.metacatUrl = string;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    private synchronized InputStream sendDataOnce(Properties properties) throws Exception {
        InputStream inputStream = null;
        URL uRL = new URL(this.metacatUrl);
        HttpMessage httpMessage = new HttpMessage(uRL);
        HttpMessage.setCookie((String)("JSESSIONID=" + this.sessionId));
        inputStream = httpMessage.sendPostData(properties);
        return inputStream;
    }

    private synchronized InputStream sendData(Properties properties) throws Exception {
        Object var2_2 = null;
        try {
            return this.sendDataOnce(properties);
        }
        catch (Exception exception) {
            try {
                return this.sendDataOnce(properties);
            }
            catch (Exception exception2) {
                try {
                    return this.sendDataOnce(properties);
                }
                catch (Exception exception3) {
                    System.err.println("Failed to send data to metacat 3 times.");
                    throw exception3;
                }
            }
        }
    }

    private synchronized String sendDataForString(Properties properties) throws Exception {
        int n;
        String string = null;
        InputStreamReader inputStreamReader = new InputStreamReader(this.sendData(properties));
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[512];
        while ((n = inputStreamReader.read(cArray, 0, 512)) != -1) {
            stringWriter.write(cArray, 0, n);
        }
        inputStreamReader.close();
        string = stringWriter.toString();
        stringWriter.close();
        return string;
    }
}

