/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.ParseException;
import HTTPClient.RoRequest;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.Date;
import java.util.StringTokenizer;

public class Cookie2
extends Cookie {
    private static final long serialVersionUID = 2208203902820875917L;
    protected int version;
    protected boolean discard;
    protected String comment;
    protected URI comment_url;
    protected int[] port_list;
    protected String port_list_str;
    protected boolean path_set;
    protected boolean port_set;
    protected boolean domain_set;

    public Cookie2(String name, String value, String domain, int[] port_list, String path, Date expires, boolean discard, boolean secure, String comment, URI comment_url) {
        super(name, value, domain, path, expires, secure);
        this.discard = discard;
        this.port_list = port_list;
        this.comment = comment;
        this.comment_url = comment_url;
        this.path_set = true;
        this.domain_set = true;
        if (port_list != null && port_list.length > 0) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(port_list[0]);
            int idx = 1;
            while (idx < port_list.length) {
                tmp.append(',');
                tmp.append(port_list[idx]);
                ++idx;
            }
            this.port_list_str = tmp.toString();
            this.port_set = true;
        }
        this.version = 1;
    }

    protected Cookie2(RoRequest req) {
        super(req);
        this.path = Util.getPath(req.getRequestURI());
        int slash = this.path.lastIndexOf(47);
        if (slash != -1) {
            this.path = this.path.substring(0, slash + 1);
        }
        if (this.domain.indexOf(46) == -1) {
            this.domain = String.valueOf(this.domain) + ".local";
        }
        this.version = -1;
        this.discard = false;
        this.comment = null;
        this.comment_url = null;
        this.port_list = null;
        this.port_list_str = null;
        this.path_set = false;
        this.port_set = false;
        this.domain_set = false;
    }

    /*
     * Unable to fully structure code
     */
    protected static Cookie[] parse(String set_cookie, RoRequest req) throws ProtocolException {
        try {
            cookies = Util.parseHeader(set_cookie);
        }
        catch (ParseException pe) {
            throw new ProtocolException(pe.getMessage());
        }
        cookie_arr = new Cookie[cookies.size()];
        cidx = 0;
        idx = 0;
        while (idx < cookie_arr.length) {
            block50: {
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                c_elem = (HttpHeaderElement)cookies.elementAt(idx);
                                if (c_elem.getValue() == null) {
                                    throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nMissing value " + "for cookie '" + c_elem.getName() + "'");
                                }
                                curr = new Cookie2(req);
                                curr.name = c_elem.getName();
                                curr.value = c_elem.getValue();
                                params = c_elem.getParams();
                                discard_set = false;
                                secure_set = false;
                                idx2 = 0;
                                while (idx2 < params.length) {
                                    name = params[idx2].getName().toLowerCase();
                                    if ((name.equals("version") || name.equals("max-age") || name.equals("domain") || name.equals("path") || name.equals("comment") || name.equals("commenturl")) && params[idx2].getValue() == null) {
                                        throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nMissing value " + "for " + params[idx2].getName() + " attribute in cookie '" + c_elem.getName() + "'");
                                    }
                                    if (name.equals("version")) {
                                        if (curr.version == -1) {
                                            try {
                                                curr.version = Integer.parseInt(params[idx2].getValue());
                                            }
                                            catch (NumberFormatException v0) {
                                                throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nVersion '" + params[idx2].getValue() + "' not a number");
                                            }
                                        }
                                    } else if (name.equals("path")) {
                                        if (!curr.path_set) {
                                            curr.path = params[idx2].getValue();
                                            curr.path_set = true;
                                        }
                                    } else if (name.equals("domain")) {
                                        if (!curr.domain_set) {
                                            d = params[idx2].getValue().toLowerCase();
                                            curr.domain = d.charAt(0) != '.' && d.equals(curr.domain) == false ? "." + d : d;
                                            curr.domain_set = true;
                                        }
                                    } else if (name.equals("max-age")) {
                                        if (curr.expires == null) {
                                            try {
                                                age = Integer.parseInt(params[idx2].getValue());
                                            }
                                            catch (NumberFormatException v1) {
                                                throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nMax-Age '" + params[idx2].getValue() + "' not a number");
                                            }
                                            curr.expires = new Date(System.currentTimeMillis() + (long)age * 1000L);
                                        }
                                    } else if (name.equals("port")) {
                                        if (!curr.port_set) {
                                            if (params[idx2].getValue() == null) {
                                                curr.port_list = new int[1];
                                                curr.port_list[0] = req.getConnection().getPort();
                                                curr.port_set = true;
                                            } else {
                                                curr.port_list_str = params[idx2].getValue();
                                                tok = new StringTokenizer(params[idx2].getValue(), ",");
                                                curr.port_list = new int[tok.countTokens()];
                                                idx3 = 0;
                                                while (idx3 < curr.port_list.length) {
                                                    port = tok.nextToken().trim();
                                                    try {
                                                        curr.port_list[idx3] = Integer.parseInt(port);
                                                    }
                                                    catch (NumberFormatException v2) {
                                                        throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nPort '" + port + "' not a number");
                                                    }
                                                    ++idx3;
                                                }
                                                curr.port_set = true;
                                            }
                                        }
                                    } else if (name.equals("discard")) {
                                        if (!discard_set) {
                                            curr.discard = true;
                                            discard_set = true;
                                        }
                                    } else if (name.equals("secure")) {
                                        if (!secure_set) {
                                            curr.secure = true;
                                            secure_set = true;
                                        }
                                    } else if (name.equals("comment")) {
                                        if (curr.comment == null) {
                                            try {
                                                curr.comment = new String(params[idx2].getValue().getBytes("8859_1"), "UTF8");
                                            }
                                            catch (UnsupportedEncodingException usee) {
                                                throw new Error(usee.toString());
                                            }
                                        }
                                    } else if (name.equals("commenturl") && curr.comment_url == null) {
                                        try {
                                            curr.comment_url = new URI(params[idx2].getValue());
                                        }
                                        catch (ParseException v3) {
                                            throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nCommentURL '" + params[idx2].getValue() + "' not a valid URL");
                                        }
                                    }
                                    ++idx2;
                                }
                                if (curr.version == -1) break block50;
                                if (curr.expires == null) {
                                    curr.discard = true;
                                }
                                if (Util.getPath(req.getRequestURI()).startsWith(curr.path)) break block51;
                                Log.write(16, "Cook2: Bad Set-Cookie2 header: " + set_cookie + "\n       path `" + curr.path + "' is not a prefix of the " + "request uri `" + req.getRequestURI() + "'");
                                break block50;
                            }
                            eff_host = req.getConnection().getHost();
                            if (eff_host.indexOf(46) == -1) {
                                eff_host = String.valueOf(eff_host) + ".local";
                            }
                            if (curr.domain.equals(".local") || curr.domain.indexOf(46, 1) != -1) break block52;
                            Log.write(16, "Cook2: Bad Set-Cookie2 header: " + set_cookie + "\n       domain `" + curr.domain + "' is not `.local' and " + "doesn't contain two `.'s");
                            break block50;
                        }
                        if (eff_host.endsWith(curr.domain)) break block53;
                        Log.write(16, "Cook2: Bad Set-Cookie2 header: " + set_cookie + "\n       domain `" + curr.domain + "' does not match current" + "host `" + eff_host + "'");
                        break block50;
                    }
                    if (eff_host.substring(0, eff_host.length() - curr.domain.length()).indexOf(46) == -1) break block54;
                    Log.write(16, "Cook2: Bad Set-Cookie2 header: " + set_cookie + "\n       domain `" + curr.domain + "' is more than one `.'" + "away from host `" + eff_host + "'");
                    break block50;
                }
                if (!curr.port_set) ** GOTO lbl-1000
                idx2 = 0;
                idx2 = 0;
                while (idx2 < curr.port_list.length) {
                    if (curr.port_list[idx2] == req.getConnection().getPort()) break;
                    ++idx2;
                }
                if (idx2 == curr.port_list.length) {
                    Log.write(16, "Cook2: Bad Set-Cookie2 header: " + set_cookie + "\n       port list " + "does include current port " + req.getConnection().getPort());
                } else lbl-1000:
                // 2 sources

                {
                    cookie_arr[cidx++] = curr;
                }
            }
            ++idx;
        }
        if (cidx < cookie_arr.length) {
            cookie_arr = Util.resizeArray(cookie_arr, cidx);
        }
        return cookie_arr;
    }

    public int getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public URI getCommentURL() {
        return this.comment_url;
    }

    public int[] getPorts() {
        return this.port_list;
    }

    public boolean discard() {
        return this.discard;
    }

    protected boolean sendWith(RoRequest req) {
        String eff_host;
        boolean port_match;
        HTTPConnection con = req.getConnection();
        boolean bl = port_match = !this.port_set;
        if (this.port_set) {
            int idx = 0;
            while (idx < this.port_list.length) {
                if (this.port_list[idx] == con.getPort()) {
                    port_match = true;
                    break;
                }
                ++idx;
            }
        }
        if ((eff_host = con.getHost()).indexOf(46) == -1) {
            eff_host = String.valueOf(eff_host) + ".local";
        }
        return (this.domain.charAt(0) == '.' && eff_host.endsWith(this.domain) || this.domain.charAt(0) != '.' && eff_host.equals(this.domain)) && port_match && Util.getPath(req.getRequestURI()).startsWith(this.path) && (!this.secure || con.getProtocol().equals("https") || con.getProtocol().equals("shttp"));
    }

    protected String toExternalForm() {
        StringBuffer cookie = new StringBuffer();
        if (this.version == 1) {
            cookie.append(this.name);
            cookie.append("=");
            cookie.append(this.value);
            if (this.path_set) {
                cookie.append("; ");
                cookie.append("$Path=");
                cookie.append(this.path);
            }
            if (this.domain_set) {
                cookie.append("; ");
                cookie.append("$Domain=");
                cookie.append(this.domain);
            }
            if (this.port_set) {
                cookie.append("; ");
                cookie.append("$Port");
                if (this.port_list_str != null) {
                    cookie.append("=\"");
                    cookie.append(this.port_list_str);
                    cookie.append('\"');
                }
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return cookie.toString();
    }

    public String toString() {
        StringBuffer res = new StringBuffer(this.name.length() + this.value.length() + 50);
        res.append(this.name).append('=').append(this.value);
        if (this.version == 1) {
            res.append("; Version=").append(this.version);
            res.append("; Path=").append(this.path);
            res.append("; Domain=").append(this.domain);
            if (this.port_set) {
                res.append("; Port=\"").append(this.port_list[0]);
                int idx = 1;
                while (idx < this.port_list.length) {
                    res.append(',').append(this.port_list[idx]);
                    ++idx;
                }
                res.append('\"');
            }
            if (this.expires != null) {
                res.append("; Max-Age=").append((this.expires.getTime() - System.currentTimeMillis()) / 1000L);
            }
            if (this.discard) {
                res.append("; Discard");
            }
            if (this.secure) {
                res.append("; Secure");
            }
            if (this.comment != null) {
                res.append("; Comment=\"").append(this.comment).append('\"');
            }
            if (this.comment_url != null) {
                res.append("; CommentURL=\"").append(this.comment_url).append('\"');
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return res.toString();
    }
}

