/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.LSID;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.client.cache.LSIDCacheException;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import java.io.InputStream;
import java.util.Map;

public class CachingMetadataService
implements LSIDMetadataService {
    private LSIDMetadataService service;
    private LSIDCache cache;

    public CachingMetadataService(LSIDMetadataService service) {
        this.service = service;
    }

    public MetadataResponse getMetadata(LSIDRequestContext req, String[] formats) throws LSIDServerException {
        LSID lsid = req.getLsid();
        Map headers = req.getProtocalHeaders();
        if (!(req.getHint() != null && req.getHint().equals("foreignAuthorities") || this.cache == null || headers.containsValue("no-cache"))) {
            try {
                MetadataResponse response = this.cache.readMetadata(lsid.getAuthority(), lsid, "servercache", req.getHint(), formats);
                if (response != null) {
                    return response;
                }
                response = this.service.getMetadata(req, formats);
                if (response == null) {
                    throw new LSIDServerException(500, "getMetaData should not return null");
                }
                InputStream stream = this.cache.writeMetadata(lsid.getAuthority(), lsid, "servercache", req.getHint(), response.getMetadata(), response.getExpires(), response.getFormat());
                return new MetadataResponse((Object)stream, response.getExpires(), response.getFormat());
            }
            catch (LSIDCacheException e) {
                throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "cache exception in metadata lookup");
            }
        }
        return this.service.getMetadata(req, formats);
    }

    public void initService(LSIDServiceConfig config) throws LSIDServerException {
        this.cache = LSIDResolver.getCache();
        if (this.cache == null) {
            throw new LSIDServerException(521, "Unable to load Authority Cache - environmental variable not set");
        }
        if (this.service == null) {
            throw new LSIDServerException(521, "Unable to load Authority Service");
        }
    }
}

