/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.wsdl;

import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.wsdl.LSIDAuthorityPort;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import java.util.HashMap;
import java.util.Map;

public class HTTPLocation
implements LSIDDataPort,
LSIDMetadataPort,
LSIDAuthorityPort {
    private String hostname = null;
    private String dataPath = null;
    private int port = -1;
    private String serviceName = null;
    private String portName = null;
    private LSIDCredentials lsidCredentials = null;
    private Map headers = new HashMap();
    private String pathType = "urlEncoded";

    public void addProtocolHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Map getProtocolHeaders() {
        return this.headers;
    }

    public LSIDCredentials getLsidCredentials() {
        LSIDCredentials portCreds;
        if (this.lsidCredentials == null && (portCreds = new LSIDCredentials(this)).keys().hasMoreElements()) {
            this.lsidCredentials = portCreds;
        }
        return this.lsidCredentials;
    }

    public void setLsidCredentials(LSIDCredentials lsidCredentials) {
        this.lsidCredentials = lsidCredentials;
    }

    public HTTPLocation(String hostname, int port, String dataPath) {
        this.hostname = hostname;
        this.port = port;
        this.dataPath = dataPath;
        if (this.dataPath == null) {
            this.dataPath = "";
        } else if (!this.dataPath.startsWith("/")) {
            this.dataPath = "/" + this.dataPath;
        }
    }

    public HTTPLocation(String portName, String hostname, int port, String dataPath) {
        this.portName = portName;
        this.hostname = hostname;
        this.port = port;
        this.dataPath = dataPath;
        if (this.dataPath == null) {
            this.dataPath = "";
        } else if (!this.dataPath.startsWith("/")) {
            this.dataPath = "/" + this.dataPath;
        }
    }

    public HTTPLocation(String serviceName, String portName, String hostname, int port, String dataPath) {
        this.serviceName = serviceName;
        this.portName = portName;
        this.hostname = hostname;
        this.port = port;
        this.dataPath = dataPath;
        if (this.dataPath == null) {
            this.dataPath = "";
        } else if (!this.dataPath.startsWith("/")) {
            this.dataPath = "/" + this.dataPath;
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getName() {
        return this.portName;
    }

    public String getLocation() {
        if (this.port < 0) {
            return "http://" + this.hostname + this.dataPath;
        }
        return "http://" + this.hostname + ":" + this.port + this.dataPath;
    }

    public String getPath() {
        return this.pathType;
    }

    public String getProtocol() {
        return "http";
    }

    public void setPathType(String pathType) {
        this.pathType = pathType;
    }
}

