/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.BasicCookieBox;
import HTTPClient.Cookie;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;

class DefaultCookiePolicyHandler
implements CookiePolicyHandler {
    private String[] accept_domains = new String[0];
    private String[] reject_domains = new String[0];
    private BasicCookieBox popup;

    DefaultCookiePolicyHandler() {
        String list;
        try {
            list = System.getProperty("HTTPClient.cookies.hosts.accept");
        }
        catch (Exception exception) {
            list = null;
        }
        String[] domains = Util.splitProperty(list);
        int idx = 0;
        while (idx < domains.length) {
            this.addAcceptDomain(domains[idx].toLowerCase());
            ++idx;
        }
        try {
            list = System.getProperty("HTTPClient.cookies.hosts.reject");
        }
        catch (Exception exception) {
            list = null;
        }
        domains = Util.splitProperty(list);
        int idx2 = 0;
        while (idx2 < domains.length) {
            this.addRejectDomain(domains[idx2].toLowerCase());
            ++idx2;
        }
    }

    public boolean acceptCookie(Cookie cookie, RoRequest req, RoResponse resp) {
        String server = req.getConnection().getHost();
        if (server.indexOf(46) == -1) {
            server = String.valueOf(server) + ".local";
        }
        int idx = 0;
        while (idx < this.reject_domains.length) {
            if (this.reject_domains[idx].length() == 0 || this.reject_domains[idx].charAt(0) == '.' && server.endsWith(this.reject_domains[idx]) || this.reject_domains[idx].charAt(0) != '.' && server.equals(this.reject_domains[idx])) {
                return false;
            }
            ++idx;
        }
        int idx2 = 0;
        while (idx2 < this.accept_domains.length) {
            if (this.accept_domains[idx2].length() == 0 || this.accept_domains[idx2].charAt(0) == '.' && server.endsWith(this.accept_domains[idx2]) || this.accept_domains[idx2].charAt(0) != '.' && server.equals(this.accept_domains[idx2])) {
                return true;
            }
            ++idx2;
        }
        if (!req.allowUI()) {
            return true;
        }
        if (this.popup == null) {
            this.popup = new BasicCookieBox();
        }
        return this.popup.accept(cookie, this, server);
    }

    public boolean sendCookie(Cookie cookie, RoRequest req) {
        return true;
    }

    void addAcceptDomain(String domain) {
        if (domain.indexOf(46) == -1 && domain.length() > 0) {
            domain = String.valueOf(domain) + ".local";
        }
        int idx = 0;
        while (idx < this.accept_domains.length) {
            if (domain.endsWith(this.accept_domains[idx])) {
                return;
            }
            if (this.accept_domains[idx].endsWith(domain)) {
                this.accept_domains[idx] = domain;
                return;
            }
            ++idx;
        }
        this.accept_domains = Util.resizeArray(this.accept_domains, this.accept_domains.length + 1);
        this.accept_domains[this.accept_domains.length - 1] = domain;
    }

    void addRejectDomain(String domain) {
        if (domain.indexOf(46) == -1 && domain.length() > 0) {
            domain = String.valueOf(domain) + ".local";
        }
        int idx = 0;
        while (idx < this.reject_domains.length) {
            if (domain.endsWith(this.reject_domains[idx])) {
                return;
            }
            if (this.reject_domains[idx].endsWith(domain)) {
                this.reject_domains[idx] = domain;
                return;
            }
            ++idx;
        }
        this.reject_domains = Util.resizeArray(this.reject_domains, this.reject_domains.length + 1);
        this.reject_domains[this.reject_domains.length - 1] = domain;
    }
}

