/**
 *  '$RCSfile: TestDigirQuery.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *    Authors: @Rod SPears@
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-07-26 22:59:38 $'
 * '$Revision: 1.5 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

import edu.ucsb.nceas.utilities.HttpMessage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

import java.io.*;
import java.net.*;
import java.util.*;

import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.EcogridQueryParser;
import org.ecoinformatics.ecogrid.EcogridResultsetTransformer;
import org.ecoinformatics.ecogrid.digir.impl.EcogridJavaToDigirJavaQueryTransformer;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.ResultsetType;

import org.ecoinformatics.ecogrid.digir.impl.DigirProxyImpl;

/**
 * A JUnit test for testing Step class processing
 */
public class TestDigirQuery extends TestCase
{
    private boolean        _doTests   = @DO.QUERY.TESTS@;
    private DigirProxyImpl _proxyImpl = null;

    /**************************************************************************
     ** Reads a ecogrid query, transforms it into a digir query
     *************************************************************************/
    public boolean checkDigirQuery(String aFileName) {

        boolean status = false;

        if (_proxyImpl == null) {
            _proxyImpl = new DigirProxyImpl();
        }

        try
        {
            QueryType query = EcogridUtils.readEcogridXMLQuery(aFileName);

            ResultsetType results = _proxyImpl.query(query);

            //String digirQuery = _proxyImpl.getDigirQuery();

            status = _proxyImpl.getStatus() == DigirProxyImpl.kNoError;

            EcogridUtils.debugMessage("===================================================");
            if (results != null)
            {
              String resultsStr = EcogridResultsetTransformer.toXMLString(results);
              EcogridUtils.debugMessage(resultsStr);
            }
            else
            {
              EcogridUtils.debugMessage("** Resultset was null!");
            }
            EcogridUtils.debugMessage("===================================================");

        } 
        catch (Exception e) {
            EcogridUtils.debugMessage("===================================================");
            EcogridUtils.debugMessage("Failed in checkDigirQuery");
            EcogridUtils.debugMessage(e.toString());
            e.printStackTrace();
            EcogridUtils.debugMessage("===================================================");
            status = false;
        }
        return status;
    }

    
    /** Creates a new instance of DigirQueryResults and runs the tests */
    public void testEcogridDigirEngineWithDarwin() {
        
        if(_doTests)
        {
          assertTrue(checkDigirQuery("testfiles/query-digir.xml"));
        }

    }

    /*public void testEcogridDigirEngineWithManis() {
        

        assertTrue(checkDigirQuery("testfiles/manis_peromyscus-query.xml"));

    }*/

}
