/**
 *  '$RCSfile: MetacatImplTest.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-01-29 18:17:58 $'
 * '$Revision: 1.2 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.ecogridtest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.ecoinformatics.ecogrid.EcogridObjType;
import org.ecoinformatics.ecogrid.client.AuthenticationServiceClient;
import org.ecoinformatics.ecogrid.client.PutServiceClient;
import org.ecoinformatics.ecogrid.queryservice.QueryServiceClient;
import org.ecoinformatics.ecogrid.queryservice.QueryServiceGetToStreamClient;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetTransformer;


/**
 * A JUnit test for testing the indexing routines for XML Paths
 */
public class MetacatImplTest extends TestCase
{
    private String username = "uid=xxxx,o=NCEAS,dc=ecoinformatics,dc=org";
    private String password = "xxxx";
    private String wrongpassword = "anything";
    private String prefix = "test";
    private String newdocid = null;
    private String authenURL = "http://localhost:8080/knb/services/AuthenticationService";//"@baseURL@/@authen.service.name@";
    private String putURL    = "http://localhost:8080/knb/services/PutService";//"@baseURL@/@put.service.name@";
    private String queryURL  = "http://localhost:8080/knb/services/QueryService";//"@baseURL@/@service.name@";
    private String sessionId = null;
    private String metadataFileName = "projects/ecogrid/tests/testfiles/eml-sample.xml";
    private String dataFileName     = "projects/ecogrid/tests/testfiles/dataset.txt";
    private String queryFileName    = "projects/ecogrid/tests/testfiles/query-test.xml";   
    private String metadataDocId    = "";
    private String dataDocId        = "";
    
    
    private static final String METADATA = "metadata";
    private static final String DATA     = "data";

    /**
     * Constructor to build the test
     *
     * @param name the name of the test method
     */
    public MetacatImplTest(String name)
    {
        super(name);
    }

    /**
     * Establish a testing framework by initializing appropriate objects
     */
    public void setUp()
    {
       
    }

    /**
     * Release any objects after tests are complete
     */
    public void tearDown()
    {
    }

    /**
     * Create a suite of tests to be run together
     */
    public static Test suite()
    {
        TestSuite suite = new TestSuite();
        suite.addTest(new MetacatImplTest("initialize"));
        suite.addTest(new MetacatImplTest("loginUnsuccess"));
        suite.addTest(new MetacatImplTest("writeMetadataFileSuccess"));
        suite.addTest(new MetacatImplTest("writeMetadataFileUnsucess"));
        suite.addTest(new MetacatImplTest("writeDataFileSuccess"));
        suite.addTest(new MetacatImplTest("writeDataFileUnsucess"));
        suite.addTest(new MetacatImplTest("writeMetadataVector"));
        suite.addTest(new MetacatImplTest("writeDataVector"));
        suite.addTest(new MetacatImplTest("query"));
        suite.addTest(new MetacatImplTest("updateMetadata"));
        suite.addTest(new MetacatImplTest("updateData"));
        return suite;
    }

    /**
     * Run an initial test that always passes to check that the test
     * harness is working.
     */
    public void initialize()
    {
        assertTrue(1 == 1);
    }
    
    /**
     * Method to test login success method
     */
    public void loginSuccess()
    {
      try
      {
        //URL GSH = new URL(authenURL);
        // create a client object
        AuthenticationServiceClient client = new AuthenticationServiceClient(authenURL);
        //client.createEcoGridAuthLevelOnePortType();
        sessionId = client.login_action(username, password);
        assertFalse(sessionId.equals("an unknown error"));
      }
      catch(Exception e)
      {
        fail("Authentication exception:\n" + e.getMessage());
      }
    }//login
    
    /**
     * Method to test login unsuccess method
     */
    public void loginUnsuccess()
    {
      try
      {
        //URL GSH = new URL(authenURL);
        // create a client object
        AuthenticationServiceClient client = new AuthenticationServiceClient(authenURL);
        //client.createEcoGridAuthLevelOnePortType();
        sessionId = client.login_action(username, wrongpassword);
        assertTrue(sessionId.equals("an unknown error"));
      }
      catch(Exception e)
      {
        System.err.println("Wrong password couldn't login:\n" + e.getMessage());
        assertTrue(1==1);
      }

    }
    
    /**
     * Method to test logout method
     */
    public void logout()
    {
      try
      {
        URL GSH = new URL(authenURL);
        // create a client object
        AuthenticationServiceClient client = new AuthenticationServiceClient(authenURL);
        //client.createEcoGridAuthLevelOnePortType();
        client.logout_action(sessionId);
        assertTrue(1==1);
      }
      catch(Exception e)
      {
        fail("Authentication exception:\n" + e.getMessage());
      }

    }
    
    public void writeMetadataFileSuccess()
    {
      loginSuccess();
      try
      {
        // create a client object
        URL GSH = new URL(putURL);
        PutServiceClient client = new PutServiceClient(putURL);
        //client.createEcoGridPutLevelOnePortType();
        metadataDocId = generateDocid()+ ".1";
        int objType = EcogridObjType.METADATA;
        System.err.println("doicd is "+ metadataDocId);
        System.err.println("session id is "+ sessionId);
        client.put(metadataFileName, metadataDocId, objType, sessionId);
        //readMetadata(metadataDocId);
        System.err.println("successfully insert metadata " + metadataDocId);
        assertTrue(1==1);
      }
      catch(Exception e)
      {
        fail("Write excepiton:\n"+ e.getMessage());
      }
      logout();
    }
    
    public void writeMetadataFileUnsucess()
    {
      try
      {
       // create a client object
       URL GSH = new URL(putURL);
       PutServiceClient client = new PutServiceClient(putURL);
       //client.createEcoGridPutLevelOnePortType();
       String docId = generateDocid()+ ".1";;
       int objType = EcogridObjType.METADATA;
       client.put(metadataFileName, docId, objType, sessionId);
       assertFalse(1==1);
      }
      catch(Exception e)
      {
        System.err.println("Public try to write metacat should fail:\n"+ e.getMessage());
        assertTrue(1==1);
      }

    }
    
    public void writeDataFileSuccess()
   {
     loginSuccess();
     try
     {
       // create a client object
       URL GSH = new URL(putURL);
       PutServiceClient client = new PutServiceClient(putURL);
       //client.createEcoGridPutLevelOnePortType();
       dataDocId = generateDocid()+ ".1";;
       int objType = EcogridObjType.DATA;
       System.err.println("doicd is "+ dataDocId);
       System.err.println("session id is "+ sessionId);
       client.put(dataFileName, dataDocId, objType, sessionId);
       System.err.println("successfully insert data " + dataDocId);
       assertTrue(1==1);
     }
     catch(Exception e)
     {
       fail("Write excepiton:\n"+ e.getMessage());
     }
     logout();
   }

   public void writeDataFileUnsucess()
   {
     try
     {
      // create a client object
      URL GSH = new URL(putURL);
      PutServiceClient client = new PutServiceClient(putURL);
      //client.createEcoGridPutLevelOnePortType();
      String docId = generateDocid()+ ".1";;
      int objType = EcogridObjType.DATA;
      client.put(dataFileName, docId, objType, sessionId);
      assertFalse(1==1);
     }
     catch(Exception e)
     {
       System.err.println("public user should fail to load data:\n"+ e.getMessage());
       assertTrue(1==1);
     }

   }
   
   public void writeMetadataVector()
   {
      loginSuccess();
      try
      {
        // create a client object
        URL GSH = new URL(putURL);
        PutServiceClient client = new PutServiceClient(putURL);
        //client.createEcoGridPutLevelOnePortType();
        metadataDocId = generateDocid() + ".1"; //was 2
        int objType = EcogridObjType.METADATA;
        byte [] metadataVector = getBytesFromFile(metadataFileName);
        client.put(metadataVector, metadataDocId, objType, sessionId);
        //readMetadata(metadataDocId);
        System.err.println("successfully insert metadata " + metadataDocId);
        assertTrue(1==1);
      }
      catch(Exception e)
      {
        fail("Write excepiton:\n"+ e.getMessage());
      }
      logout();
   }
   
   public void writeDataVector()
   {
     loginSuccess();
     try
     {
       // create a client object
       URL GSH = new URL(putURL);
       PutServiceClient client = new PutServiceClient(putURL);
       //client.createEcoGridPutLevelOnePortType();
       dataDocId = generateDocid()+ ".2";
       int objType = EcogridObjType.DATA;
       byte[] dataVector = getBytesFromFile(dataFileName);
       client.put(dataVector, dataDocId, objType, sessionId);
       System.err.println("successfully insert data " + dataDocId);
       assertTrue(1==1);
     }
     catch(Exception e)
     {
       fail("Write excepiton:\n"+ e.getMessage());
     }
     logout();

   }
   
   public void query()
   {
      try
      {
        // create a client object
        System.err.println("query url is "+ queryURL);
        URL GSH = new URL(queryURL);
        QueryServiceClient client = new QueryServiceClient(queryURL);
        // create ecogrid query interface porty type
        //client.createEcoGridQueryLevelOnePortType();
  
        // call query service
        // read qurery xml file
        File queryXMLFile = new File(queryFileName);
        FileReader xmlReader = new FileReader(queryXMLFile);
        ResultsetType result = client.query(xmlReader);
        // print out the result set
        String resultXML = EcogridResultsetTransformer.toXMLString(result);
        System.err.println(""+resultXML);
        assertTrue(1==1);
      }
      catch (Exception e)
      {
        fail("Failed to query:\n"+ e.getMessage());
      }

   }
   
   public void updateMetadata()
   {
     loginSuccess();
     try
     {
       // create a client object
       URL GSH = new URL(putURL);
       PutServiceClient client = new PutServiceClient(putURL);
       //client.createEcoGridPutLevelOnePortType();
       String newId = generateDocid();
       metadataDocId = newId + ".1";
       int objType = EcogridObjType.METADATA;
       System.err.println("doicd is "+ metadataDocId);
       System.err.println("session id is "+ sessionId);
       client.put(metadataFileName, metadataDocId, objType, sessionId);
       //readMetadata(metadataDocId);
       System.err.println("successfully insert metadata " + metadataDocId);
       try {
           System.out.println("waiting for metacat before trying the update");
    	   //let the metacat instance churn on the new doc id...some index building or such?
    	   Thread.sleep(3000);
       }
       catch (Exception e) {
		// TODO: handle exception
    	   e.printStackTrace();
       }
       
       
       metadataDocId = newId + ".2";
       System.err.println("doicd is "+ metadataDocId);
       System.err.println("session id is "+ sessionId);
       client.put(metadataFileName, metadataDocId, objType, sessionId);
       System.err.println("successfully update metadata " + metadataDocId);
       //readMetadata(metadataDocId);
       assertTrue(1==1);
     }
     catch(Exception e)
     {
       fail("Write excepiton:\n"+ e.getMessage());
     }
     logout();
   }
   
   public void updateData()
  {
   loginSuccess();
   try
   {
     // create a client object
     URL GSH = new URL(putURL);
     PutServiceClient client = new PutServiceClient(putURL);
     //client.createEcoGridPutLevelOnePortType();
     String newId = generateDocid();
     dataDocId = newId + ".1";
     int objType = EcogridObjType.DATA;
     System.err.println("data doicd is "+ dataDocId);
     System.err.println("session id is "+ sessionId);
     client.put(dataFileName, dataDocId, objType, sessionId);
      System.err.println("successfully insert data " + dataDocId);
      try {
          System.out.println("waiting for metacat before trying the update");
   	   //let the metacat instance churn on the new doc id...some index building or such?
   	   Thread.sleep(3000);
      }
      catch (Exception e) {
   	   e.printStackTrace();
      }
      dataDocId = newId + ".2";
     System.err.println("doicd is "+ dataDocId);
     System.err.println("session id is "+ sessionId);
     client.put(dataFileName, dataDocId, objType, sessionId);
      System.err.println("successfully updte data " + dataDocId);
     assertTrue(1==1);
   }
   catch(Exception e)
   {
     fail("Write excepiton:\n"+ e.getMessage());
   }
   logout();
 }

   
   private void readMetadata(String id)
   {
     try
     {
       // create a client object
       URL GSH = new URL(queryURL);
       QueryServiceGetToStreamClient client = new QueryServiceGetToStreamClient(GSH);
       // create ecogrid query interface porty type
       //client.createEcoGridQueryLevelOnePortType();
       byte[] content = client.get(id);
       String text = new String(content);
       System.err.println(""+text);
      
     }
     catch (Exception e)
     {
       fail("Failed to query:\n"+ e.getMessage());
     }

   }
   

    
   
    /**
     * Create a hopefully unique docid for testing insert and update. Does
     * not include the 'revision' part of the id.
     *
     * @return a String docid based on the current date and time
     */
    private String generateDocid()
    {
        StringBuffer docid = new StringBuffer(prefix);
        docid.append(".");

        // Create a calendar to get the date formatted properly
        String[] ids = TimeZone.getAvailableIDs(-8 * 60 * 60 * 1000);
        SimpleTimeZone pdt = new SimpleTimeZone(-8 * 60 * 60 * 1000, ids[0]);
        pdt.setStartRule(Calendar.APRIL, 1, Calendar.SUNDAY, 2*60*60*1000);
        pdt.setEndRule(Calendar.OCTOBER, -1, Calendar.SUNDAY, 2*60*60*1000);
        Calendar calendar = new GregorianCalendar(pdt);
        Date trialTime = new Date();
        calendar.setTime(trialTime);
        docid.append(calendar.get(Calendar.YEAR));
        docid.append(calendar.get(Calendar.DAY_OF_YEAR));
        docid.append(calendar.get(Calendar.HOUR_OF_DAY));
        docid.append(calendar.get(Calendar.MINUTE));
        docid.append(calendar.get(Calendar.SECOND));

        return docid.toString();
    }
    
    byte[] getBytesFromFile(String fileName)
   {
     byte[] readBytes = new byte[2000];
     int n,i;

     byte[] total_bytes=null;
     byte[] tmp_bytes=null;
     int cur_byte_cnt;
     try
     {
        FileInputStream file = new FileInputStream(fileName);
        n = file.read(readBytes,0, 2000);
        cur_byte_cnt = 0;
        while(n > 0)
        {
           if(total_bytes == null)
           {
              total_bytes = new byte[n];
              for(i=0;i<n;i++)
                total_bytes[i] = readBytes[i];
           }
           else
           {
              tmp_bytes = new byte[total_bytes.length];
              for(i=0;i<total_bytes.length;i++)
                tmp_bytes[i] = total_bytes[i];

              total_bytes = null;
              total_bytes = new byte[tmp_bytes.length + n];
              for(i=0;i<tmp_bytes.length;i++)
                total_bytes[i] = tmp_bytes[i];
              for(i=0;i<n;i++)
                total_bytes[tmp_bytes.length + i] = readBytes[i];             

              tmp_bytes = null;
           }

           n = file.read(readBytes,0, 2000);
        }

        file.close();
     }
     catch (Exception e)
     {
        System.out.println("Exception in reading data from file: "+ e.getMessage());
        System.exit(1);
     }


     return total_bytes;
  }

}
