/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.ToStream;
import org.xml.sax.SAXException;

public class ToXMLStream
extends ToStream {
    private boolean m_cdataTagOpen = false;
    protected static CharInfo m_xmlcharInfo = CharInfo.getCharInfo(CharInfo.XML_ENTITIES_RESOURCE);

    public ToXMLStream() {
        this.m_charInfo = m_xmlcharInfo;
        this.initCDATA();
        this.m_prefixMap = new NamespaceMappings();
    }

    public void CopyFrom(ToXMLStream xmlListener) {
        this.m_writer = xmlListener.m_writer;
        String encoding = xmlListener.getEncoding();
        this.setEncoding(encoding);
        this.setOmitXMLDeclaration(xmlListener.getOmitXMLDeclaration());
        this.m_startTagOpen = xmlListener.m_startTagOpen;
        this.m_ispreserve = xmlListener.m_ispreserve;
        this.m_preserves = xmlListener.m_preserves;
        this.m_isprevtext = xmlListener.m_isprevtext;
        this.m_doIndent = xmlListener.m_doIndent;
        this.m_currentElemDepth = xmlListener.m_currentElemDepth;
        this.setIndentAmount(xmlListener.getIndentAmount());
        this.m_startNewLine = xmlListener.m_startNewLine;
        this.m_needToOutputDocTypeDecl = xmlListener.m_needToOutputDocTypeDecl;
        this.setDoctypeSystem(xmlListener.getDoctypeSystem());
        this.setDoctypePublic(xmlListener.getDoctypePublic());
        this.setStandalone(xmlListener.getStandalone());
        this.setMediaType(xmlListener.getMediaType());
        this.m_maxCharacter = xmlListener.m_maxCharacter;
        this.m_spaceBeforeClose = xmlListener.m_spaceBeforeClose;
        this.m_cdataStartCalled = xmlListener.m_cdataStartCalled;
    }

    public void startDocumentInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            super.startDocumentInternal();
            this.m_needToCallStartDocument = false;
            if (this.m_inEntityRef) {
                return;
            }
            this.m_needToOutputDocTypeDecl = true;
            this.m_startNewLine = false;
            if (!this.getOmitXMLDeclaration()) {
                String encoding = Encodings.getMimeEncoding(this.getEncoding());
                String version = this.getVersion();
                if (version == null) {
                    version = "1.0";
                }
                String standalone = this.m_standaloneWasSpecified ? " standalone=\"" + this.getStandalone() + "\"" : "";
                try {
                    this.m_writer.write("<?xml version=\"");
                    this.m_writer.write(version);
                    this.m_writer.write("\" encoding=\"");
                    this.m_writer.write(encoding);
                    this.m_writer.write(34);
                    this.m_writer.write(standalone);
                    this.m_writer.write("?>");
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }
    }

    public void endDocument() throws SAXException {
        this.flushPending();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startPreserving() throws SAXException {
        this.m_preserves.push(true);
        this.m_ispreserve = true;
    }

    public void endPreserving() throws SAXException {
        this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.flushPending();
        if (target.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (target.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                int indexOfQLT;
                if (this.m_startTagOpen) {
                    this.closeStartTag();
                    this.m_startTagOpen = false;
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.m_writer.write(60);
                this.m_writer.write(63);
                this.m_writer.write(target);
                if (data.length() > 0 && !Character.isSpaceChar(data.charAt(0))) {
                    this.m_writer.write(32);
                }
                if ((indexOfQLT = data.indexOf("?>")) >= 0) {
                    if (indexOfQLT > 0) {
                        this.m_writer.write(data.substring(0, indexOfQLT));
                    }
                    this.m_writer.write("? >");
                    if (indexOfQLT + 2 < data.length()) {
                        this.m_writer.write(data.substring(indexOfQLT + 2));
                    }
                } else {
                    this.m_writer.write(data);
                }
                this.m_writer.write(63);
                this.m_writer.write(62);
                if (this.m_currentElemDepth <= 0) {
                    this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                }
                this.m_startNewLine = true;
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(target, data);
        }
    }

    public void entityReference(String name) throws SAXException {
        if (this.m_startTagOpen) {
            this.closeStartTag();
            this.m_startTagOpen = false;
        }
        try {
            if (this.shouldIndent()) {
                this.indent();
            }
            this.m_writer.write("&");
            this.m_writer.write(name);
            this.m_writer.write(";");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        if (this.m_tracer != null) {
            super.fireEntityReference(name);
        }
    }

    public void addAttribute(String uri, String localName, String rawName, String type, String value) throws SAXException {
        if (this.m_startTagOpen) {
            String prefixUsed;
            if (!rawName.startsWith("xmlns") && (prefixUsed = this.ensureAttributesNamespaceIsDeclared(uri, localName, rawName)) != null && rawName != null && !rawName.startsWith(prefixUsed)) {
                rawName = prefixUsed + ":" + localName;
            }
            this.addAttributeAlways(uri, localName, rawName, type, value);
        } else {
            String msg = XMLMessages.createXMLMessage("ER_ILLEGAL_ATTRIBUTE_POSITION", new Object[]{localName});
            try {
                Transformer tran = super.getTransformer();
                ErrorListener errHandler = tran.getErrorListener();
                if (null != errHandler && this.m_sourceLocator != null) {
                    errHandler.warning(new TransformerException(msg, this.m_sourceLocator));
                } else {
                    System.out.println(msg);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private String escapeString(String value) {
        char[] ch = value.toCharArray();
        int limit = ch.length;
        StringBuffer result = new StringBuffer();
        int offset = 0;
        int i = 0;
        while (i < limit) {
            switch (ch[i]) {
                case '&': {
                    result.append(ch, offset, i - offset).append("&amp;");
                    offset = i + 1;
                    break;
                }
                case '\"': {
                    result.append(ch, offset, i - offset).append("&quot;");
                    offset = i + 1;
                    break;
                }
                case '<': {
                    result.append(ch, offset, i - offset).append("&lt;");
                    offset = i + 1;
                    break;
                }
                case '>': {
                    result.append(ch, offset, i - offset).append("&gt;");
                    offset = i + 1;
                    break;
                }
                case '\n': {
                    result.append(ch, offset, i - offset).append("&#xA;");
                    offset = i + 1;
                }
            }
            ++i;
        }
        if (offset < limit) {
            result.append(ch, offset, limit - offset);
        }
        return result.toString();
    }

    public void endElement(String elemName) throws SAXException {
        this.endElement(null, null, elemName);
    }

    public void namespaceAfterStartElement(String prefix, String uri) throws SAXException {
        String prefix1;
        if (this.m_elementURI == null && (prefix1 = SerializerBase.getPrefixPart(this.m_elementName)) == null && "".equals(prefix)) {
            this.m_elementURI = uri;
        }
        this.startPrefixMapping(prefix, uri, false);
    }

    protected boolean pushNamespace(String prefix, String uri) {
        try {
            if (this.m_prefixMap.pushNamespace(prefix, uri, this.m_currentElemDepth)) {
                this.startPrefixMapping(prefix, uri);
                return true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    public boolean reset() {
        boolean wasReset = false;
        if (super.reset()) {
            this.resetToXMLStream();
            wasReset = true;
        }
        return wasReset;
    }

    private void resetToXMLStream() {
        this.m_cdataTagOpen = false;
    }
}

