/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Address {
    private String line1;
    private String line2;
    private String city;
    private String state;
    private String postalCode;
    private String country;

    public Address() {
    }

    public Address(String json) throws IOException {
        if (!json.equals("{}")) {
            Address address = (Address)new ObjectMapper().readValue(json, Address.class);
            this.line1 = address.line1;
            this.line2 = address.line2;
            this.city = address.city;
            this.state = address.state;
            this.postalCode = address.postalCode;
            this.country = address.country;
        }
    }

    public Address(String line1, String line2, String city, String state, String postalCode, String country) {
        this.line1 = line1;
        this.line2 = line2;
        this.city = city;
        this.state = state;
        this.postalCode = postalCode;
        this.country = country;
    }

    public String getLine1() {
        return this.line1;
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public String getLine2() {
        return this.line2;
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.getLine1(), address.getLine1()) && Objects.equals(this.getLine2(), address.getLine2()) && Objects.equals(this.getCity(), address.getCity()) && Objects.equals(this.getState(), address.getState()) && Objects.equals(this.getPostalCode(), address.getPostalCode()) && Objects.equals(this.getCountry(), address.getCountry());
    }

    public int hashCode() {
        return Objects.hash(this.getLine1(), this.getLine2(), this.getCity(), this.getState(), this.getPostalCode(), this.getCountry());
    }
}

