/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.annotator.matcher.orcid;

import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.xpath.XPathAPI;
import org.dataone.annotator.matcher.ConceptItem;
import org.dataone.annotator.matcher.ConceptMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OrcidService
implements ConceptMatcher {
    private static Log log = LogFactory.getLog(OrcidService.class);
    private static final String REST_URL = "http://pub.orcid.org/v1.1/search/orcid-bio";

    @Override
    public List<ConceptItem> getConcepts(String text, String unit, String context) throws Exception {
        return OrcidService.lookupOrcid(text, null, null, null);
    }

    @Override
    public List<ConceptItem> getConcepts(Map<String, String> queryItems) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (String value : queryItems.values()) {
            sb.append(value);
            sb.append(" ");
        }
        return OrcidService.lookupOrcid(sb.toString(), null, null, null);
    }

    public static List<ConceptItem> lookupOrcid(String text, String surName, List<String> givenNames, List<String> otherNames) {
        String url = null;
        ArrayList<ConceptItem> results = null;
        try {
            String urlParameters = "";
            if (text != null) {
                urlParameters = urlParameters + "\"" + text + "\"";
            } else {
                if (surName != null) {
                    urlParameters = urlParameters + "+family-name:\"" + surName + "\"";
                }
                if (otherNames != null) {
                    for (String otherName : otherNames) {
                        urlParameters = urlParameters + "+other-names:\"" + otherName + "\"";
                    }
                }
                if (givenNames != null) {
                    for (String givenName : givenNames) {
                        urlParameters = urlParameters + "+given-names:\"" + givenName + "\"";
                    }
                }
            }
            urlParameters = URLEncoder.encode(urlParameters, "UTF-8");
            url = "http://pub.orcid.org/v1.1/search/orcid-bio?q=" + urlParameters + "&rows=1";
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet method = new HttpGet(url);
            method.addHeader("Accept", "application/orcid+xml");
            HttpResponse response = client.execute((HttpUriRequest)method);
            InputStream is = response.getEntity().getContent();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            NodeList orcidSearchResultList = XPathAPI.selectNodeList((Node)doc, (String)"//*[local-name()=\"orcid-search-result\"]");
            if (orcidSearchResultList != null) {
                results = new ArrayList<ConceptItem>();
                for (int i = 0; i < orcidSearchResultList.getLength(); ++i) {
                    Node resultNode = orcidSearchResultList.item(i);
                    Node score = XPathAPI.selectSingleNode((Node)resultNode, (String)"*[local-name()=\"relevancy-score\"]");
                    Node orcidUriNode = XPathAPI.selectSingleNode((Node)resultNode, (String)"*[local-name()=\"orcid-profile\"]/*[local-name()=\"orcid-identifier\"]/*[local-name()=\"uri\"]");
                    if (orcidUriNode == null) {
                        log.warn((Object)"Skipping ORCID result - no identifier URI");
                        continue;
                    }
                    String orcidUri = orcidUriNode.getFirstChild().getNodeValue();
                    log.info((Object)("Found ORCID URI: " + orcidUri));
                    double weight = Double.parseDouble(score.getFirstChild().getNodeValue());
                    ConceptItem item = new ConceptItem(new URI(orcidUri), weight);
                    results.add(item);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not lookup ORCID using: " + url), (Throwable)e);
        }
        return results;
    }
}

