/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.FileRetryInfo;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Set;

class RotationSelector
implements FileSelector {
    private EnvironmentImpl env;
    private Long previousFileNum;
    private Long currentFileNum;
    static final /* synthetic */ boolean $assertionsDisabled;

    RotationSelector(EnvironmentImpl env) {
        if (!$assertionsDisabled && env == null) {
            throw new AssertionError();
        }
        this.env = env;
    }

    public FileRetryInfo getFileToClean(Set excludeFiles, boolean aggressive) {
        if (this.currentFileNum == null) {
            this.moveToNextFile();
        }
        if (this.currentFileNum != null) {
            return new RetryInfo(this.currentFileNum);
        }
        return null;
    }

    private void moveToNextFile() {
        Long nextTarget;
        DbLsn firstActiveLsn = this.env.getCheckpointer().getFirstActiveLsn();
        if (firstActiveLsn == null) {
            return;
        }
        long firstActiveFileNum = firstActiveLsn.getFileNumber();
        FileManager fileManager = this.env.getFileManager();
        if (this.previousFileNum == null) {
            nextTarget = fileManager.getFirstFileNum();
        } else {
            nextTarget = fileManager.getFollowingFileNum(this.previousFileNum, true);
            if (nextTarget == null || nextTarget >= firstActiveFileNum) {
                nextTarget = fileManager.getFirstFileNum();
            }
        }
        if (nextTarget != null && nextTarget < firstActiveFileNum) {
            this.currentFileNum = nextTarget;
        }
    }

    static {
        $assertionsDisabled = !RotationSelector.class.desiredAssertionStatus();
    }

    private class RetryInfo
    implements FileRetryInfo {
        private Long fileNum;
        private boolean fullyProcessed;
        private boolean hasPendingLNs;
        static final /* synthetic */ boolean $assertionsDisabled;

        RetryInfo(Long fileNum) {
            this.fileNum = fileNum;
        }

        public Long getFileNumber() {
            return this.fileNum;
        }

        public void endProcessing(boolean deleted) {
            RotationSelector.this.previousFileNum = RotationSelector.this.currentFileNum;
            RotationSelector.this.currentFileNum = null;
        }

        public boolean canFileBeDeleted() {
            return !this.hasPendingLNs && this.fullyProcessed;
        }

        public void setFileFullyProcessed() {
            this.fullyProcessed = true;
        }

        public boolean isFileFullyProcessed() {
            return this.fullyProcessed;
        }

        public void setFirstUnprocessedLsn(DbLsn lsn) {
            if (!$assertionsDisabled && lsn.getFileNumber() != this.fileNum.longValue()) {
                throw new AssertionError();
            }
        }

        public DbLsn getFirstUnprocessedLsn() {
            return null;
        }

        public DbLsn[] getPendingLsns() {
            return null;
        }

        public boolean isObsoleteLN(DbLsn lsn, long nodeId) {
            if (!$assertionsDisabled && lsn.getFileNumber() != this.fileNum.longValue()) {
                throw new AssertionError();
            }
            return false;
        }

        public void setObsoleteLN(DbLsn lsn, long nodeId) {
            if (!$assertionsDisabled && lsn.getFileNumber() != this.fileNum.longValue()) {
                throw new AssertionError();
            }
        }

        public void setPendingLN(DbLsn lsn, long nodeId) {
            if (!$assertionsDisabled && lsn.getFileNumber() != this.fileNum.longValue()) {
                throw new AssertionError();
            }
            this.hasPendingLNs = true;
        }

        static {
            $assertionsDisabled = !(class$com$sleepycat$je$cleaner$RotationSelector == null ? (class$com$sleepycat$je$cleaner$RotationSelector = RotationSelector.class$("com.sleepycat.je.cleaner.RotationSelector")) : class$com$sleepycat$je$cleaner$RotationSelector).desiredAssertionStatus();
        }
    }
}

