/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DatabaseUtil;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.Tracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class Environment {
    private static final String PROPFILE_NAME = "je.properties";
    private EnvironmentImpl environmentImpl = null;
    private TransactionConfig defaultTxnConfig;
    private EnvironmentMutableConfig handleConfig;
    private Set referringDbs = Collections.synchronizedSet(new HashSet());
    private Set referringDbTxns = Collections.synchronizedSet(new HashSet());
    private boolean valid = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment(File envHome, EnvironmentConfig configuration) throws DatabaseException {
        DatabaseUtil.checkForNullParam(envHome, "dbEnvHome");
        EnvironmentConfig baseConfig = configuration == null ? EnvironmentConfig.DEFAULT : configuration;
        EnvironmentConfig useConfig = baseConfig.cloneConfig();
        this.applyFileConfig(envHome, useConfig);
        this.copyToHandleConfig(useConfig);
        DbEnvPool.EnvironmentImplInfo envInfo = DbEnvPool.getInstance().getEnvironment(envHome, useConfig);
        this.environmentImpl = envInfo.envImpl;
        this.environmentImpl.checkIfInvalid();
        if (!envInfo.firstHandle && configuration != null) {
            EnvironmentImpl environmentImpl = this.environmentImpl;
            synchronized (environmentImpl) {
                this.environmentImpl.checkImmutablePropsForEquality(useConfig);
            }
        }
        if (!this.valid) {
            this.valid = true;
        }
        this.environmentImpl.incReferenceCount();
    }

    private void applyFileConfig(File envHome, EnvironmentMutableConfig useConfig) throws IllegalArgumentException {
        if (useConfig.getLoadPropertyFile()) {
            File paramFile = null;
            try {
                paramFile = new File(envHome, PROPFILE_NAME);
                Properties fileProps = new Properties();
                fileProps.load(new FileInputStream(paramFile));
                useConfig.validateProperties(fileProps);
                Iterator<Map.Entry<Object, Object>> iter = fileProps.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Object, Object> propPair = iter.next();
                    String name = (String)propPair.getKey();
                    String value = (String)propPair.getValue();
                    useConfig.setConfigParam(name, value);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                IllegalArgumentException e2 = new IllegalArgumentException("An error occurred when reading " + paramFile);
                e2.initCause(e);
                throw e2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void close() throws DatabaseException {
        this.checkHandleIsValid();
        try {
            this.checkEnv();
        }
        catch (RunRecoveryException e) {
            if (this.environmentImpl == null) return;
            this.environmentImpl.closeAfterRunRecovery();
            return;
        }
        StringBuffer errors = new StringBuffer();
        try {
            int nTxns;
            int nDbs = this.referringDbs.size();
            if (nDbs != 0) {
                errors.append("There ");
                if (nDbs == 1) {
                    errors.append("is 1 open Database in the Environment.\n");
                } else {
                    errors.append("are ");
                    errors.append(nDbs);
                    errors.append(" open Database in the Environment.\n");
                }
                errors.append("Closing the following databases:\n");
                Iterator iter = this.referringDbs.iterator();
                while (iter.hasNext()) {
                    Database db = (Database)iter.next();
                    String dbName = db.getDatabaseName();
                    errors.append(dbName).append(" ");
                    try {
                        db.close();
                    }
                    catch (RunRecoveryException e) {
                        throw e;
                    }
                    catch (DatabaseException DBE) {
                        errors.append("\nWhile closing Database ");
                        errors.append(dbName);
                        errors.append(" encountered exception: ");
                        errors.append(DBE).append("\n");
                    }
                }
            }
            if ((nTxns = this.referringDbTxns.size()) != 0) {
                Iterator iter = this.referringDbTxns.iterator();
                errors.append("There ");
                if (nTxns == 1) {
                    errors.append("is 1 existing transaction opened against");
                    errors.append(" the Environment.\n");
                } else {
                    errors.append("are ");
                    errors.append(nTxns);
                    errors.append(" existing transactions opened against");
                    errors.append(" the Environment.\n");
                }
                errors.append("Aborting open transactions ...\n");
                while (iter.hasNext()) {
                    Transaction txn = (Transaction)iter.next();
                    try {
                        txn.abort();
                    }
                    catch (RunRecoveryException e) {
                        throw e;
                    }
                    catch (DatabaseException DBE) {
                        errors.append("\nWhile aborting transaction ");
                        errors.append(txn.getId());
                        errors.append(" encountered exception: ");
                        errors.append(DBE).append("\n");
                    }
                }
            }
            try {
                this.environmentImpl.close();
            }
            catch (RunRecoveryException e) {
                throw e;
            }
            catch (DatabaseException DBE) {
                errors.append("\nWhile closing Environment encountered exception: ");
                errors.append(DBE).append("\n");
            }
            Object var8_15 = null;
            this.environmentImpl = null;
            this.valid = false;
            if (errors.length() <= 0) return;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            this.environmentImpl = null;
            this.valid = false;
            if (errors.length() <= 0) throw throwable;
            throw new DatabaseException(errors.toString());
        }
        throw new DatabaseException(errors.toString());
    }

    public synchronized Database openDatabase(Transaction txn, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        if (dbConfig == null) {
            dbConfig = DatabaseConfig.DEFAULT;
        }
        Database db = new Database(this);
        this.openDb(txn, db, databaseName, dbConfig, false);
        return db;
    }

    public synchronized SecondaryDatabase openSecondaryDatabase(Transaction txn, String databaseName, Database primaryDatabase, SecondaryConfig dbConfig) throws DatabaseException {
        if (dbConfig == null) {
            dbConfig = SecondaryConfig.DEFAULT;
        }
        SecondaryDatabase db = new SecondaryDatabase(this, dbConfig, primaryDatabase);
        this.openDb(txn, db, databaseName, dbConfig, dbConfig.getAllowPopulate());
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openDb(Transaction txn, Database newDb, String databaseName, DatabaseConfig dbConfig, boolean needWritableLockerForInit) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        Tracer.trace(Level.FINEST, this.environmentImpl, "Environment.open:  name=" + databaseName + " dbConfig=" + dbConfig);
        this.validateDbConfigAgainstEnv(dbConfig, databaseName);
        Locker locker = null;
        boolean operationOk = false;
        try {
            boolean databaseExists;
            boolean isWritableLocker;
            if (needWritableLockerForInit) {
                locker = DatabaseUtil.getWritableLocker(this, txn, dbConfig.getTransactional(), true);
                isWritableLocker = true;
            } else {
                locker = DatabaseUtil.getReadableLocker(this, txn, dbConfig.getTransactional(), true);
                isWritableLocker = !dbConfig.getTransactional() || txn != null && locker == txn.getLocker();
            }
            DatabaseImpl database = this.environmentImpl.getDb(locker, databaseName, newDb);
            boolean bl = database == null ? false : (databaseExists = !database.getIsDeleted());
            if (databaseExists) {
                if (dbConfig.getAllowCreate() && dbConfig.getExclusiveCreate()) {
                    throw new DatabaseException("Database " + database + " already exists");
                }
                newDb.initExisting(this, locker, database, dbConfig);
            } else {
                if (!dbConfig.getAllowCreate()) throw new DatabaseNotFoundException("Database " + databaseName + " not found.");
                if (!isWritableLocker) {
                    locker.operationEnd(OperationStatus.SUCCESS);
                    locker = DatabaseUtil.getWritableLocker(this, txn, dbConfig.getTransactional(), true);
                    isWritableLocker = true;
                }
                newDb.initNew(this, locker, databaseName, dbConfig);
            }
            operationOk = true;
            this.addReferringHandle(newDb);
            Object var12_11 = null;
            if (locker == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (locker == null) throw throwable;
            locker.setHandleLockOwner(operationOk, newDb, false);
            locker.operationEnd(operationOk);
            throw throwable;
        }
        locker.setHandleLockOwner(operationOk, newDb, false);
        locker.operationEnd(operationOk);
    }

    private void validateDbConfigAgainstEnv(DatabaseConfig dbConfig, String databaseName) throws DatabaseException {
        if (dbConfig.getTransactional() && !this.environmentImpl.isTransactional()) {
            throw new DatabaseException("Attempted to open Database " + databaseName + " transactionally, but parent Environment is" + " not transactional");
        }
        if (this.environmentImpl.isReadOnly() && !dbConfig.getReadOnly()) {
            throw new DatabaseException("Attempted to open Database " + databaseName + " as writable but parent Environment is read only ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabase(Transaction txn, String databaseName) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        Locker locker = null;
        boolean operationOk = false;
        try {
            locker = DatabaseUtil.getWritableLocker(this, txn, this.environmentImpl.isTransactional(), true);
            this.environmentImpl.dbRemove(locker, databaseName);
            operationOk = true;
        }
        finally {
            if (locker != null) {
                locker.operationEnd(operationOk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameDatabase(Transaction txn, String databaseName, String newName) throws DatabaseException {
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        DatabaseUtil.checkForNullParam(newName, "newName");
        this.checkHandleIsValid();
        this.checkEnv();
        Locker locker = null;
        boolean operationOk = false;
        try {
            locker = DatabaseUtil.getWritableLocker(this, txn, this.environmentImpl.isTransactional(), true);
            this.environmentImpl.dbRename(locker, databaseName, newName);
            operationOk = true;
        }
        finally {
            if (locker != null) {
                locker.operationEnd(operationOk);
            }
        }
    }

    long getMemoryUsage() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        return this.environmentImpl.getMemoryBudget().getCacheMemoryUsage();
    }

    public File getHome() throws DatabaseException {
        this.checkHandleIsValid();
        return this.environmentImpl.getEnvironmentHome();
    }

    TransactionConfig getDefaultTxnConfig() {
        return this.defaultTxnConfig;
    }

    private void copyToHandleConfig(EnvironmentMutableConfig useConfig) {
        EnvironmentMutableConfig newHandleConfig = new EnvironmentMutableConfig();
        useConfig.copyHandlePropsTo(newHandleConfig);
        this.handleConfig = newHandleConfig;
        TransactionConfig newTxnConfig = TransactionConfig.DEFAULT.cloneConfig();
        newTxnConfig.setNoSync(this.handleConfig.getTxnNoSync());
        this.defaultTxnConfig = newTxnConfig;
    }

    public Transaction beginTransaction(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        TransactionConfig useConfig;
        this.checkHandleIsValid();
        this.checkEnv();
        if (!this.environmentImpl.isTransactional()) {
            throw new DatabaseException("Transactions can not be used in a non-transactional environment");
        }
        if (txnConfig == null) {
            useConfig = this.defaultTxnConfig;
        } else if (this.defaultTxnConfig.getNoSync() && !txnConfig.getNoSync() && !txnConfig.getSync()) {
            useConfig = txnConfig.cloneConfig();
            useConfig.setNoSync(true);
        } else {
            useConfig = txnConfig;
        }
        Transaction txn = new Transaction(this, this.environmentImpl.txnBegin(parent, useConfig), null);
        this.addReferringHandle(txn);
        return txn;
    }

    public void checkpoint(CheckpointConfig ckptConfig) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        CheckpointConfig useConfig = ckptConfig == null ? CheckpointConfig.DEFAULT : ckptConfig;
        this.environmentImpl.invokeCheckpoint(useConfig, false);
    }

    public void sync() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        CheckpointConfig config = new CheckpointConfig();
        config.setForce(true);
        this.environmentImpl.invokeCheckpoint(config, true);
    }

    public int cleanLog() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        return this.environmentImpl.invokeCleaner();
    }

    public void evictMemory() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        this.environmentImpl.invokeEvictor();
    }

    public void compress() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        this.environmentImpl.invokeCompressor();
    }

    public EnvironmentConfig getConfig() throws DatabaseException {
        this.checkHandleIsValid();
        EnvironmentConfig config = this.environmentImpl.cloneConfig();
        this.handleConfig.copyHandlePropsTo(config);
        config.fillInEnvironmentGeneratedProps(this.environmentImpl);
        return config;
    }

    public void setMutableConfig(EnvironmentMutableConfig mutableConfig) throws DatabaseException {
        this.checkHandleIsValid();
        DatabaseUtil.checkForNullParam(mutableConfig, "mutableConfig");
        this.environmentImpl.setMutableConfig(mutableConfig);
        this.copyToHandleConfig(mutableConfig);
    }

    public EnvironmentMutableConfig getMutableConfig() throws DatabaseException {
        this.checkHandleIsValid();
        EnvironmentMutableConfig config = this.environmentImpl.cloneMutableConfig();
        this.handleConfig.copyHandlePropsTo(config);
        return config;
    }

    void upgrade() throws DatabaseException {
    }

    public EnvironmentStats getStats(StatsConfig config) throws DatabaseException {
        StatsConfig useConfig;
        StatsConfig statsConfig = useConfig = config == null ? StatsConfig.DEFAULT : config;
        if (this.environmentImpl != null) {
            return this.environmentImpl.loadStats(useConfig);
        }
        return new EnvironmentStats();
    }

    public LockStats getLockStats(StatsConfig config) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
        return this.environmentImpl.lockStat(useConfig);
    }

    public TransactionStats getTransactionStats(StatsConfig config) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
        return this.environmentImpl.txnStat(useConfig);
    }

    public List getDatabaseNames() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        return this.environmentImpl.getDbNames();
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        VerifyConfig useConfig = config == null ? VerifyConfig.DEFAULT : config;
        return this.environmentImpl.verify(useConfig, out);
    }

    void addReferringHandle(Database db) {
        this.referringDbs.add(db);
    }

    void addReferringHandle(Transaction txn) {
        this.referringDbTxns.add(txn);
    }

    void removeReferringHandle(Database db) {
        this.referringDbs.remove(db);
    }

    void removeReferringHandle(Transaction txn) {
        this.referringDbTxns.remove(txn);
    }

    EnvironmentImpl getEnvironmentImpl() {
        return this.environmentImpl;
    }

    private void checkHandleIsValid() throws DatabaseException {
        if (!this.valid) {
            throw new DatabaseException("Attempt to use non-open Environment object().");
        }
    }

    private void checkEnv() throws DatabaseException, RunRecoveryException {
        if (this.environmentImpl == null) {
            return;
        }
        this.environmentImpl.checkIfInvalid();
        this.environmentImpl.checkNotClosed();
    }
}

