/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.BooleanBinding;
import com.sleepycat.bind.tuple.ByteBinding;
import com.sleepycat.bind.tuple.CharacterBinding;
import com.sleepycat.bind.tuple.DoubleBinding;
import com.sleepycat.bind.tuple.FloatBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.ShortBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;
import java.util.HashMap;
import java.util.Map;

public abstract class TupleBinding
implements EntryBinding {
    private static final Map primitives = new HashMap();

    public Object entryToObject(DatabaseEntry entry) {
        return this.entryToObject(TupleBinding.entryToInput(entry));
    }

    public void objectToEntry(Object object, DatabaseEntry entry) {
        TupleOutput output = TupleBinding.newOutput();
        this.objectToEntry(object, output);
        TupleBinding.outputToEntry(output, entry);
    }

    public static TupleOutput newOutput() {
        return new TupleOutput();
    }

    public static TupleOutput newOutput(byte[] buffer) {
        return new TupleOutput(buffer);
    }

    public static void outputToEntry(TupleOutput output, DatabaseEntry entry) {
        entry.setData(output.getBufferBytes(), output.getBufferOffset(), output.getBufferLength());
    }

    public static void inputToEntry(TupleInput input, DatabaseEntry entry) {
        entry.setData(input.getBufferBytes(), input.getBufferOffset(), input.getBufferLength());
    }

    public static TupleInput entryToInput(DatabaseEntry entry) {
        return new TupleInput(entry.getData(), entry.getOffset(), entry.getSize());
    }

    public abstract Object entryToObject(TupleInput var1);

    public abstract void objectToEntry(Object var1, TupleOutput var2);

    public static TupleBinding getPrimitiveBinding(Class cls) {
        return (TupleBinding)primitives.get(cls);
    }

    static {
        primitives.put(String.class, new StringBinding());
        primitives.put(Character.class, new CharacterBinding());
        primitives.put(Boolean.class, new BooleanBinding());
        primitives.put(Byte.class, new ByteBinding());
        primitives.put(Short.class, new ShortBinding());
        primitives.put(Integer.class, new IntegerBinding());
        primitives.put(Long.class, new LongBinding());
        primitives.put(Float.class, new FloatBinding());
        primitives.put(Double.class, new DoubleBinding());
    }
}

