/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.impl.AbstractProfile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class RDFSProfile
extends AbstractProfile {
    private static Object[][] s_supportsCheckTable = new Object[][]{{OntClass.class, new SupportsCheck(){

        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), RDFS.Class.asNode()) || g.asGraph().contains(n, RDF.type.asNode(), RDFS.Datatype.asNode()) || n.equals(RDFS.Resource.asNode()) || g.asGraph().contains(Node.ANY, RDFS.domain.asNode(), n) || g.asGraph().contains(Node.ANY, RDFS.range.asNode(), n);
        }
    }}, {RDFList.class, new SupportsCheck(){

        public boolean doCheck(Node n, EnhGraph g) {
            return n.equals(RDF.nil.asNode()) || g.asGraph().contains(n, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {OntProperty.class, new SupportsCheck(){

        public boolean doCheck(Node n, EnhGraph g) {
            return g.asGraph().contains(n, RDF.type.asNode(), RDF.Property.asNode());
        }
    }}};
    protected static HashMap s_supportsChecks = new HashMap();

    public String NAMESPACE() {
        return RDFS.getURI();
    }

    public Resource CLASS() {
        return RDFS.Class;
    }

    public Resource RESTRICTION() {
        return null;
    }

    public Resource THING() {
        return null;
    }

    public Resource NOTHING() {
        return null;
    }

    public Resource PROPERTY() {
        return RDF.Property;
    }

    public Resource OBJECT_PROPERTY() {
        return null;
    }

    public Resource DATATYPE_PROPERTY() {
        return null;
    }

    public Resource TRANSITIVE_PROPERTY() {
        return null;
    }

    public Resource SYMMETRIC_PROPERTY() {
        return null;
    }

    public Resource FUNCTIONAL_PROPERTY() {
        return null;
    }

    public Resource INVERSE_FUNCTIONAL_PROPERTY() {
        return null;
    }

    public Resource ALL_DIFFERENT() {
        return null;
    }

    public Resource ONTOLOGY() {
        return null;
    }

    public Resource DEPRECATED_CLASS() {
        return null;
    }

    public Resource DEPRECATED_PROPERTY() {
        return null;
    }

    public Resource ANNOTATION_PROPERTY() {
        return null;
    }

    public Resource ONTOLOGY_PROPERTY() {
        return null;
    }

    public Resource LIST() {
        return RDF.List;
    }

    public Resource NIL() {
        return RDF.nil;
    }

    public Resource DATARANGE() {
        return null;
    }

    public Property EQUIVALENT_PROPERTY() {
        return null;
    }

    public Property EQUIVALENT_CLASS() {
        return null;
    }

    public Property DISJOINT_WITH() {
        return null;
    }

    public Property SAME_INDIVIDUAL_AS() {
        return null;
    }

    public Property SAME_AS() {
        return null;
    }

    public Property DIFFERENT_FROM() {
        return null;
    }

    public Property DISTINCT_MEMBERS() {
        return null;
    }

    public Property UNION_OF() {
        return null;
    }

    public Property INTERSECTION_OF() {
        return null;
    }

    public Property COMPLEMENT_OF() {
        return null;
    }

    public Property ONE_OF() {
        return null;
    }

    public Property ON_PROPERTY() {
        return null;
    }

    public Property ALL_VALUES_FROM() {
        return null;
    }

    public Property HAS_VALUE() {
        return null;
    }

    public Property SOME_VALUES_FROM() {
        return null;
    }

    public Property MIN_CARDINALITY() {
        return null;
    }

    public Property MAX_CARDINALITY() {
        return null;
    }

    public Property CARDINALITY() {
        return null;
    }

    public Property INVERSE_OF() {
        return null;
    }

    public Property IMPORTS() {
        return null;
    }

    public Property PRIOR_VERSION() {
        return null;
    }

    public Property BACKWARD_COMPATIBLE_WITH() {
        return null;
    }

    public Property INCOMPATIBLE_WITH() {
        return null;
    }

    public Property SUB_PROPERTY_OF() {
        return RDFS.subPropertyOf;
    }

    public Property SUB_CLASS_OF() {
        return RDFS.subClassOf;
    }

    public Property DOMAIN() {
        return RDFS.domain;
    }

    public Property RANGE() {
        return RDFS.range;
    }

    public Property FIRST() {
        return RDF.first;
    }

    public Property REST() {
        return RDF.rest;
    }

    public Property MIN_CARDINALITY_Q() {
        return null;
    }

    public Property MAX_CARDINALITY_Q() {
        return null;
    }

    public Property CARDINALITY_Q() {
        return null;
    }

    public Property HAS_CLASS_Q() {
        return null;
    }

    public Property VERSION_INFO() {
        return null;
    }

    public Property LABEL() {
        return RDFS.label;
    }

    public Property COMMENT() {
        return RDFS.comment;
    }

    public Property SEE_ALSO() {
        return RDFS.seeAlso;
    }

    public Property IS_DEFINED_BY() {
        return RDFS.isDefinedBy;
    }

    protected Resource[][] aliasTable() {
        return new Resource[][]{new Resource[0]};
    }

    public Iterator getAxiomTypes() {
        return Arrays.asList(new Resource[0]).iterator();
    }

    public Iterator getAnnotationProperties() {
        return Arrays.asList(RDFS.label, RDFS.seeAlso, RDFS.comment, RDFS.isDefinedBy).iterator();
    }

    public Iterator getClassDescriptionTypes() {
        return Arrays.asList(RDFS.Class).iterator();
    }

    public boolean isSupported(Node n, EnhGraph g, Class type) {
        if (g instanceof OntModel) {
            OntModel m = (OntModel)((Object)g);
            if (!m.strictMode()) {
                return true;
            }
            SupportsCheck check = (SupportsCheck)s_supportsChecks.get(type);
            return check == null || check.doCheck(n, g);
        }
        return false;
    }

    public String getLabel() {
        return "RDFS";
    }

    static {
        for (int i = 0; i < s_supportsCheckTable.length; ++i) {
            s_supportsChecks.put(s_supportsCheckTable[i][0], s_supportsCheckTable[i][1]);
        }
    }

    protected static class SupportsCheck {
        protected SupportsCheck() {
        }

        public boolean doCheck(Node n, EnhGraph g) {
            return true;
        }
    }
}

