/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.ConnectionDescription;
import com.hp.hpl.jena.assembler.Content;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.ModelExpansion;
import com.hp.hpl.jena.assembler.assemblers.RDBModelAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.ReificationStyle;
import junit.framework.Assert;

public class TestRDBModelAssembler
extends AssemblerTestBase {
    public TestRDBModelAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return RDBModelAssembler.class;
    }

    public void testRDBModelAssemblerType() {
        this.testDemandsMinimalType((Assembler)new RDBModelAssembler(), JA.RDBModel);
    }

    public void testRDBModelVocabulary() {
        Model m = this.model("x rdf:type ja:Connectable; x rdf:type ja:NamedModel");
        Model answer = ModelExpansion.withSchema((Model)m, (Model)JA.getSchema());
        TestRDBModelAssembler.assertTrue((String)"should infer x rdf:type ja:RDBModel", (boolean)answer.contains(TestRDBModelAssembler.statement("x rdf:type ja:RDBModel")));
    }

    public void testInvokesCreateModel() {
        Resource root = this.resourceInModel("x rdf:type ja:RDBModel; x ja:modelName 'spoo'; x ja:connection C");
        final ConnectionDescription C = ConnectionDescription.create((String)"eh:/x", (String)"A", (String)"B", (String)"C", (String)"D");
        final Model fake = ModelFactory.createDefaultModel();
        final Mode theMode = new Mode(true, true);
        RDBModelAssembler a = new RDBModelAssembler(){

            public Model openModel(Resource root, ConnectionDescription c, String name, ReificationStyle style, Content initial, Mode mode) {
                Assert.assertSame((Object)C, (Object)c);
                Assert.assertSame((Object)theMode, (Object)mode);
                return fake;
            }
        };
        AssemblerTestBase.NamedObjectAssembler foo = new AssemblerTestBase.NamedObjectAssembler(TestRDBModelAssembler.resource("C"), C);
        TestRDBModelAssembler.assertSame((Object)fake, (Object)a.open((Assembler)foo, root, theMode));
    }
}

