/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestRDFNodes
extends ModelTestBase {
    public TestRDFNodes(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDFNodes.class);
    }

    public void testRDFVisitor() {
        final ArrayList history = new ArrayList();
        Model m = ModelFactory.createDefaultModel();
        Resource S = m.createResource();
        Property P = m.createProperty("eh:PP");
        Literal O = m.createLiteral("LL");
        RDFVisitor rv = new RDFVisitor((RDFNode)S, (RDFNode)P, (RDFNode)O){
            private final /* synthetic */ RDFNode val$S;
            private final /* synthetic */ RDFNode val$P;
            private final /* synthetic */ RDFNode val$O;
            {
                this.val$S = rDFNode;
                this.val$P = rDFNode2;
                this.val$O = rDFNode3;
            }

            public Object visitBlank(Resource R, AnonId id) {
                history.add("blank");
                Assert.assertTrue((String)"must visit correct node", (R == this.val$S ? 1 : 0) != 0);
                Assert.assertEquals((String)"must have correct field", (Object)R.getId(), (Object)id);
                return "blank result";
            }

            public Object visitURI(Resource R, String uri) {
                history.add("uri");
                Assert.assertTrue((String)"must visit correct node", (R == this.val$P ? 1 : 0) != 0);
                Assert.assertEquals((String)"must have correct field", (String)R.getURI(), (String)uri);
                return "uri result";
            }

            public Object visitLiteral(Literal L) {
                history.add("literal");
                Assert.assertTrue((String)"must visit correct node", (L == this.val$O ? 1 : 0) != 0);
                return "literal result";
            }
        };
        TestRDFNodes.assertEquals((Object)"blank result", (Object)S.visitWith(rv));
        TestRDFNodes.assertEquals((Object)"uri result", (Object)P.visitWith(rv));
        TestRDFNodes.assertEquals((Object)"literal result", (Object)O.visitWith(rv));
        TestRDFNodes.assertEquals((Object)TestRDFNodes.listOfStrings("blank uri literal"), history);
    }

    public void testRemoveAllRemoves() {
        String ps = "x P a; x P b";
        String rest = "x Q c; y P a; y Q b";
        Model m = TestRDFNodes.modelWithStatements(ps + "; " + rest);
        Resource r = TestRDFNodes.resource(m, "x");
        Resource r2 = r.removeAll(TestRDFNodes.property(m, "P"));
        TestRDFNodes.assertSame((String)"removeAll should deliver its receiver", (Object)r, (Object)r2);
        TestRDFNodes.assertIsoModels("x's P-values should go", TestRDFNodes.modelWithStatements(rest), m);
    }

    public void testRemoveAllBoring() {
        Model m1 = TestRDFNodes.modelWithStatements("x P a; y Q b");
        Model m2 = TestRDFNodes.modelWithStatements("x P a; y Q b");
        TestRDFNodes.resource(m2, "x").removeAll(TestRDFNodes.property(m2, "Z"));
        TestRDFNodes.assertIsoModels("m2 should be unchanged", m1, m2);
    }

    public void testInModel() {
        Model m1 = TestRDFNodes.modelWithStatements("");
        Model m2 = TestRDFNodes.modelWithStatements("");
        Resource r1 = TestRDFNodes.resource(m1, "r1");
        Resource r2 = TestRDFNodes.resource(m1, "_r2");
        TestRDFNodes.assertTrue((r1.getModel() == m1 ? 1 : 0) != 0);
        TestRDFNodes.assertTrue((r2.getModel() == m1 ? 1 : 0) != 0);
        TestRDFNodes.assertFalse((boolean)r1.isAnon());
        TestRDFNodes.assertTrue((boolean)r2.isAnon());
        TestRDFNodes.assertTrue((((Resource)r1.inModel(m2)).getModel() == m2 ? 1 : 0) != 0);
        TestRDFNodes.assertTrue((((Resource)r2.inModel(m2)).getModel() == m2 ? 1 : 0) != 0);
        TestRDFNodes.assertEquals((Object)r1, (Object)r1.inModel(m2));
        TestRDFNodes.assertEquals((Object)r2, (Object)r2.inModel(m2));
    }

    public void testIsAnon() {
        Model m = TestRDFNodes.modelWithStatements("");
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createResource("eh:/foo").isAnon());
        TestRDFNodes.assertEquals((boolean)true, (boolean)m.createResource().isAnon());
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createTypedLiteral(17).isAnon());
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createTypedLiteral("hello").isAnon());
    }

    public void testIsLiteral() {
        Model m = TestRDFNodes.modelWithStatements("");
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createResource("eh:/foo").isLiteral());
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createResource().isLiteral());
        TestRDFNodes.assertEquals((boolean)true, (boolean)m.createTypedLiteral(17).isLiteral());
        TestRDFNodes.assertEquals((boolean)true, (boolean)m.createTypedLiteral("hello").isLiteral());
    }

    public void testIsURIResource() {
        Model m = TestRDFNodes.modelWithStatements("");
        TestRDFNodes.assertEquals((boolean)true, (boolean)m.createResource("eh:/foo").isURIResource());
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createResource().isURIResource());
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createTypedLiteral(17).isURIResource());
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createTypedLiteral("hello").isURIResource());
    }

    public void testIsResource() {
        Model m = TestRDFNodes.modelWithStatements("");
        TestRDFNodes.assertEquals((boolean)true, (boolean)m.createResource("eh:/foo").isResource());
        TestRDFNodes.assertEquals((boolean)true, (boolean)m.createResource().isResource());
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createTypedLiteral(17).isResource());
        TestRDFNodes.assertEquals((boolean)false, (boolean)m.createTypedLiteral("hello").isResource());
    }
}

