/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SimpleClassLoader
extends ClassLoader {
    private static final int debug = 0;
    protected URL[] urls;
    protected ClassLoader parent;
    protected String[] reserved;
    SecurityManager sm;

    public SimpleClassLoader(URL[] urls) {
        this.urls = urls;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public SimpleClassLoader(URL[] urls, ClassLoader parent) {
        this.urls = urls;
        this.parent = parent;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    public SimpleClassLoader(URL[] urls, ClassLoader parent, String[] reserved) {
        this.urls = urls;
        this.parent = parent;
        this.reserved = reserved;
        this.sm = System.getSecurityManager();
        this.checkURLs();
    }

    private void checkURLs() {
        boolean cnt = false;
        int i = 0;
        while (i < this.urls.length) {
            URL cp = this.urls[i];
            String fileN = cp.getFile();
            File file = new File(fileN);
            if (!file.exists()) {
                this.urls[i] = null;
            }
            if (file.isDirectory() && !fileN.endsWith("/")) {
                try {
                    this.urls[i] = new URL("file", null, String.valueOf(fileN) + "/");
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
    }

    private Resource doFindResource(String name) {
        Resource r = new Resource();
        int i = 0;
        while (i < this.urls.length) {
            URL cp = this.urls[i];
            if (cp != null) {
                String fileN = cp.getFile();
                File file = new File(fileN);
                if (fileN.endsWith("/")) {
                    String fileName = name.replace('/', File.separatorChar);
                    File resFile = new File(file, fileName);
                    if (resFile.exists()) {
                        r.file = resFile;
                        r.repository = file;
                        return r;
                    }
                } else {
                    try {
                        ZipFile zf = new ZipFile(file.getAbsolutePath());
                        ZipEntry ze = zf.getEntry(name);
                        if (ze != null) {
                            r.zipEntry = ze;
                            r.zipFile = zf;
                            r.repository = file;
                            return r;
                        }
                        zf.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        System.out.println("Name= " + name + " " + file);
                        return null;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public ClassLoader getParentLoader() {
        return this.parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getResource(String name) {
        URL uRL;
        URL u = null;
        if (this.parent != null && (u = this.parent.getResource(name)) != null) {
            return u;
        }
        u = ClassLoader.getSystemResource(name);
        if (u != null) {
            return u;
        }
        Resource r = this.doFindResource(name);
        if (r == null) {
            return null;
        }
        if (r.file != null) {
            try {
                return new URL("file", null, r.file.getAbsolutePath());
            }
            catch (MalformedURLException badurl) {
                badurl.printStackTrace();
                return null;
            }
        }
        if (r.zipEntry == null) return null;
        try {
            try {
                uRL = new URL("jar:file:" + r.repository.getPath() + "!/" + name);
                Object var6_7 = null;
            }
            catch (MalformedURLException badurl) {
                badurl.printStackTrace();
                URL uRL2 = null;
                Object var6_8 = null;
                try {
                    r.zipFile.close();
                    return uRL2;
                }
                catch (IOException iOException) {}
                return uRL2;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {}
            catch (IOException iOException) {}
            r.zipFile.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        r.zipFile.close();
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getResourceAsStream(String name) {
        Resource r;
        InputStream s;
        block14: {
            ByteArrayInputStream byteArrayInputStream;
            s = null;
            if (this.parent != null && (s = this.parent.getResourceAsStream(name)) != null) {
                return s;
            }
            s = ClassLoader.getSystemResourceAsStream(name);
            if (s != null) {
                return s;
            }
            r = this.doFindResource(name);
            if (r == null) {
                return null;
            }
            if (r.file != null) {
                try {
                    return new FileInputStream(r.file);
                }
                catch (IOException shouldnothappen) {
                    shouldnothappen.printStackTrace();
                    return null;
                }
            }
            if (r.zipEntry == null) return s;
            try {
                try {
                    ByteArrayInputStream istream;
                    byte[] data = this.loadBytesFromStream(r.zipFile.getInputStream(r.zipEntry), (int)r.zipEntry.getSize());
                    if (data == null) break block14;
                    byteArrayInputStream = istream = new ByteArrayInputStream(data);
                    Object var6_9 = null;
                    if (r.zipFile == null) return byteArrayInputStream;
                }
                catch (IOException iOException) {
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (r.zipFile == null) throw throwable;
                try {
                    r.zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            r.zipFile.close();
            return byteArrayInputStream;
        }
        Object var6_10 = null;
        if (r.zipFile == null) return s;
        try {}
        catch (IOException iOException) {
            return s;
        }
        r.zipFile.close();
        return s;
    }

    public URL[] getURLs() {
        return this.urls;
    }

    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count = 0;
        while (length > 0 && (nRead = in.read(buf, count, length)) != -1) {
            count += nRead;
            length -= nRead;
        }
        return buf;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] classData;
        Class<?> c;
        block42: {
            Resource r;
            block44: {
                int i;
                c = null;
                c = this.findLoadedClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
                if (this.parent != null) {
                    try {
                        c = this.parent.loadClass(name);
                        if (c != null) {
                            if (resolve) {
                                this.resolveClass(c);
                            }
                            return c;
                        }
                    }
                    catch (Exception exception) {
                        c = null;
                    }
                }
                try {
                    c = this.findSystemClass(name);
                    if (c != null) {
                        if (resolve) {
                            this.resolveClass(c);
                        }
                        return c;
                    }
                }
                catch (Exception exception) {
                    c = null;
                }
                if (this.sm != null && (i = name.lastIndexOf(46)) >= 0) {
                    this.sm.checkPackageAccess(name.substring(0, i));
                    this.sm.checkPackageDefinition(name.substring(0, i));
                }
                if (this.reserved != null) {
                    i = 0;
                    while (i < this.reserved.length) {
                        if (name.startsWith(this.reserved[i])) {
                            throw new ClassNotFoundException(name);
                        }
                        ++i;
                    }
                }
                if (this.urls == null) {
                    throw new ClassNotFoundException(name);
                }
                String classFileName = String.valueOf(name.replace('.', '/')) + ".class";
                r = this.doFindResource(classFileName);
                if (r == null) {
                    throw new ClassNotFoundException(name);
                }
                classData = null;
                if (r.file == null) break block44;
                FileInputStream in = null;
                try {
                    try {
                        in = new FileInputStream(r.file);
                        classData = this.loadBytesFromStream(in, (int)r.file.length());
                    }
                    catch (IOException iOException) {
                        Class clazz = null;
                        Object var10_13 = null;
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (IOException iOException2) {}
                        return clazz;
                    }
                    Object var10_14 = null;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    break block42;
                }
                catch (IOException iOException) {}
                break block42;
            }
            if (r.zipEntry != null) {
                try {
                    try {
                        classData = this.loadBytesFromStream(r.zipFile.getInputStream(r.zipEntry), (int)r.zipEntry.getSize());
                    }
                    catch (IOException iOException) {
                        Class in = null;
                        Object var9_17 = null;
                        try {
                            r.zipFile.close();
                        }
                        catch (IOException iOException3) {}
                        return in;
                    }
                    Object var9_18 = null;
                }
                catch (Throwable throwable) {
                    Object var9_19 = null;
                    try {
                        r.zipFile.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    r.zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (classData != null) {
            try {
                c = this.defineClass(name, classData, 0, classData.length);
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        throw new ClassNotFoundException(name);
    }

    void log(String s) {
        System.out.println("SimpleClassLoader: " + s);
    }

    private class Resource {
        File repository;
        File file;
        ZipEntry zipEntry;
        ZipFile zipFile;

        Resource() {
        }
    }
}

