/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.InputConfigFlags;
import com.ctc.wstx.dtd.DTDId;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.sr.BasicStreamReader;
import com.ctc.wstx.sr.ReaderCreator;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

public class MinimalInputFactory
implements ReaderCreator,
InputConfigFlags {
    protected final boolean mIsMinimal;
    protected final ReaderConfig mConfig;
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    SymbolTable mSymbols = mRootSymbols;

    public MinimalInputFactory() {
        this(true);
    }

    protected MinimalInputFactory(boolean minimal) {
        this.mConfig = ReaderConfig.createJ2MEDefaults();
        this.mIsMinimal = minimal;
    }

    public static MinimalInputFactory newMinimalInstance() {
        return new MinimalInputFactory();
    }

    public DTDSubset findCachedDTD(DTDId id) {
        return null;
    }

    public synchronized void updateSymbolTable(SymbolTable t) {
        SymbolTable curr = mRootSymbols;
        if (t.isDirectChildOf(curr)) {
            this.mSymbols = t;
        }
    }

    public synchronized void addCachedDTD(DTDId id, DTDSubset extSubset) {
    }

    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return this.createSR(null, StreamBootstrapper.getInstance((InputStream)in, null, null));
    }

    public XMLStreamReader createXMLStreamReader(InputStream in, String enc) throws XMLStreamException {
        if (enc == null || enc.length() == 0) {
            return this.createXMLStreamReader(in);
        }
        try {
            return this.createSR(null, ReaderBootstrapper.getInstance((Reader)new InputStreamReader(in, enc), null, null, (String)enc));
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public XMLStreamReader createXMLStreamReader(Reader r) throws XMLStreamException {
        return this.createXMLStreamReader(null, r);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.createSR(source);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        return this.createSR(systemId, StreamBootstrapper.getInstance((InputStream)in, null, (String)systemId));
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader r) throws XMLStreamException {
        return this.createSR(systemId, ReaderBootstrapper.getInstance((Reader)r, null, (String)systemId, null));
    }

    public Object getProperty(String name) {
        Object ob = this.mConfig.getProperty(name);
        if (ob == null && name.equals("javax.xml.stream.allocator")) {
            throw new IllegalArgumentException("Event allocator not usable with J2ME subset.");
        }
        return ob;
    }

    public void setProperty(String propName, Object value) {
        if (!this.mConfig.setProperty(propName, value) && "javax.xml.stream.allocator".equals(propName)) {
            throw new IllegalArgumentException("Event allocator not usable with J2ME subset.");
        }
    }

    public XMLReporter getXMLReporter() {
        return this.mConfig.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.mConfig.getXMLResolver();
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setXMLReporter(XMLReporter r) {
        this.mConfig.setXMLReporter(r);
    }

    public void setXMLResolver(XMLResolver r) {
        this.mConfig.setXMLResolver(r);
    }

    public ReaderConfig getConfig() {
        return this.mConfig;
    }

    protected XMLStreamReader doCreateSR(BranchingReaderSource input, ReaderConfig cfg, InputBootstrapper bs) throws IOException, XMLStreamException {
        return BasicStreamReader.createBasicStreamReader((BranchingReaderSource)input, (ReaderCreator)this, (ReaderConfig)cfg, (InputBootstrapper)bs, (boolean)false);
    }

    private XMLStreamReader createSR(String systemId, InputBootstrapper bs) throws XMLStreamException {
        Reader r;
        URL src = this.mConfig.getBaseURL();
        if (src == null && systemId != null && systemId.length() > 0) {
            try {
                src = URLUtil.urlFromSystemId(systemId);
            }
            catch (IOException ie) {
                throw new WstxIOException(ie);
            }
        }
        ReaderConfig cfg = this.mConfig.createNonShared(this.mSymbols.makeChild());
        try {
            r = bs.bootstrapInput(cfg, true, 0);
            if (bs.declaredXml11()) {
                cfg.enableXml11(true);
            }
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
        BranchingReaderSource input = InputSourceFactory.constructDocumentSource((ReaderConfig)cfg, (InputBootstrapper)bs, null, (String)systemId, (URL)src, (Reader)r, (boolean)false);
        try {
            return this.doCreateSR(input, cfg, bs);
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    private XMLStreamReader createSR(Source src) throws XMLStreamException {
        if (src instanceof StreamSource) {
            InputBootstrapper bs;
            StreamSource ss = (StreamSource)src;
            Reader r = ss.getReader();
            if (r == null) {
                InputStream in = ss.getInputStream();
                if (in == null) {
                    throw new XMLStreamException("Can not create StAX reader for a StreamSource -- neither reader nor input stream was set.");
                }
                bs = StreamBootstrapper.getInstance((InputStream)in, (String)ss.getPublicId(), (String)ss.getSystemId());
            } else {
                bs = ReaderBootstrapper.getInstance((Reader)r, (String)ss.getPublicId(), (String)ss.getSystemId(), null);
            }
            return this.createSR(src.getSystemId(), bs);
        }
        if (src instanceof SAXSource) {
            throw new XMLStreamException("Can not create a STaX reader for a SAXSource -- not (yet) implemented.");
        }
        if (src instanceof DOMSource) {
            throw new XMLStreamException("Can not create a STaX reader for a DOMSource -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate StAX reader for XML source type " + src.getClass() + " (unknown type)");
    }

    private void throwUnsupported(String msg) {
        throw new IllegalArgumentException("MinimalInputFactory has no DTD support: can not call " + msg);
    }

    static {
        mRootSymbols.setInternStrings(true);
    }
}

