/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommandProcessor;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.memcache.SimpleCommand;
import com.hazelcast.logging.ILogger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCommandProcessor
extends AbstractTextCommandProcessor<SimpleCommand> {
    private final ILogger logger;

    public SimpleCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
        this.logger = textCommandService.getNode().getLogger(this.getClass().getName());
    }

    @Override
    public void handle(SimpleCommand command) {
        if (command.getType() == TextCommandConstants.TextCommandType.QUIT) {
            try {
                command.getSocketTextReader().closeConnection();
            }
            catch (Exception e2) {
                this.logger.log(Level.WARNING, e2.getMessage(), e2);
            }
        } else if (command.getType() == TextCommandConstants.TextCommandType.UNKNOWN) {
            command.setResponse(ERROR);
            this.textCommandService.sendResponse(command);
        }
    }

    @Override
    public void handleRejection(SimpleCommand command) {
        this.handle(command);
    }
}

