/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.RuleSet;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.shared.BrokenException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TestRuleSet
extends AssemblerTestBase {
    public TestRuleSet(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        throw new BrokenException("TestAssemblers does not need this method");
    }

    public void testEmpty() {
        TestRuleSet.assertEquals(Collections.EMPTY_LIST, RuleSet.empty.getRules());
        TestRuleSet.assertEquals(RuleSet.empty, RuleSet.create(Collections.EMPTY_LIST));
    }

    public void testEmptyRuleSet() {
        RuleSet s = RuleSet.create(Collections.EMPTY_LIST);
        TestRuleSet.assertEquals(Collections.EMPTY_LIST, s.getRules());
        TestRuleSet.assertNotSame(Collections.EMPTY_LIST, s.getRules());
    }

    public void testSingleRuleSet() {
        Rule rule = Rule.parseRule("[(?a P b) -> (?a rdf:type T)]");
        List list = TestRuleSet.listOfOne(rule);
        RuleSet s = RuleSet.create(list);
        TestRuleSet.assertEquals(list, s.getRules());
        TestRuleSet.assertNotSame(list, s.getRules());
    }

    public void testMultipleRuleSet() {
        Rule A = Rule.parseRule("[(?a P b) -> (?a rdf:type T)]");
        Rule B = Rule.parseRule("[(?a Q b) -> (?a rdf:type U)]");
        List<Rule> rules = Arrays.asList(A, B);
        RuleSet s = RuleSet.create(rules);
        TestRuleSet.assertEquals(rules, s.getRules());
        TestRuleSet.assertNotSame(rules, s.getRules());
    }

    public void testFactoryForString() {
        String ruleString = "[(?a P b) -> (?a rdf:type T)]";
        RuleSet s = RuleSet.create(ruleString);
        TestRuleSet.assertEquals(Rule.parseRules(ruleString), s.getRules());
    }
}

