/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Intersection;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestIntersection
extends GraphTestBase {
    public TestIntersection(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestIntersection.class);
    }

    public void testIntersection() {
        Graph g1 = TestIntersection.graphWith("x R y; p R q");
        Graph g2 = TestIntersection.graphWith("r A s; x R y");
        Intersection i = new Intersection(g1, g2);
        TestIntersection.assertContains("Intersection", "x R y", i);
        TestIntersection.assertOmits("Intersection", i, "p R q");
        TestIntersection.assertOmits("Intersection", i, "r A s");
        if (i.size() != 1) {
            TestIntersection.fail("oops: size of intersection is not 1");
        }
        i.add(TestIntersection.triple("cats eat cheese"));
        TestIntersection.assertContains("Intersection.L", "cats eat cheese", g1);
        TestIntersection.assertContains("Intersection.R", "cats eat cheese", g2);
    }

    public void testDeleteDoesNotUpdateR() {
        Graph L = TestIntersection.graphWith("a pings b; b pings c; c pings a");
        Graph R = TestIntersection.graphWith("c pings a; b pings c; x captures y");
        Intersection join = new Intersection(L, R);
        L.getBulkUpdateHandler().delete(join);
        TestIntersection.assertIsomorphic("R should not change", TestIntersection.graphWith("c pings a; b pings c; x captures y"), R);
        TestIntersection.assertIsomorphic(TestIntersection.graphWith("a pings b"), L);
    }
}

