/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import java.util.ArrayList;
import junit.framework.TestSuite;

public class TestDomain
extends QueryTestBase {
    public TestDomain(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDomain.class);
    }

    public void testDomainGet() {
        Domain d = this.domain("a 'b' 17 _x");
        TestDomain.assertEquals(TestDomain.node("a"), d.get(0));
        TestDomain.assertEquals(TestDomain.node("'b'"), d.get(1));
        TestDomain.assertEquals(TestDomain.node("17"), d.get(2));
        TestDomain.assertEquals(TestDomain.node("_x"), d.get(3));
    }

    public void testDomainGetElement() {
        Domain d = this.domain("X 'why' 42 _z9m9z");
        TestDomain.assertEquals(TestDomain.node("X"), d.getElement(0));
        TestDomain.assertEquals(TestDomain.node("'why'"), d.getElement(1));
        TestDomain.assertEquals(TestDomain.node("42"), d.getElement(2));
        TestDomain.assertEquals(TestDomain.node("_z9m9z"), d.getElement(3));
    }

    public void testSetElement() {
        Domain d = this.domain("A B C D");
        d.setElement(0, TestDomain.node("X"));
        TestDomain.assertEquals(TestDomain.node("X"), d.getElement(0));
        d.setElement(2, TestDomain.node("Z"));
        TestDomain.assertEquals(TestDomain.node("Z"), d.getElement(2));
        TestDomain.assertEquals(TestDomain.node("X"), d.getElement(0));
    }

    public void testEqualsList() {
        Domain d = new Domain(2);
        ArrayList<Node> L = new ArrayList<Node>();
        d.setElement(0, TestDomain.node("a"));
        L.add(TestDomain.node("a"));
        d.setElement(1, TestDomain.node("b"));
        L.add(TestDomain.node("b"));
        TestDomain.assertEquals(L, d);
        TestDomain.assertEquals(d, L);
    }

    public void testSize() {
        TestDomain.assertEquals(0, this.domain("").size());
        TestDomain.assertEquals(1, this.domain("X").size());
        TestDomain.assertEquals(5, this.domain("a song in the wind").size());
    }

    public void testCopiesDistinctButEqual() {
        Domain d = this.domain("a lot of bottle");
        TestDomain.assertNotSame(d, d.copy());
        TestDomain.assertEquals(d, d.copy());
    }

    private Domain domain(String string) {
        return new Domain(TestDomain.nodeArray(string));
    }
}

