/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestReificationPredicates
extends GraphTestBase {
    public TestReificationPredicates(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestReificationPredicates.class);
    }

    public void testSubject() {
        TestReificationPredicates.assertTrue(Reifier.Util.isReificationPredicate(RDF.Nodes.subject));
    }

    public void testPredicate() {
        TestReificationPredicates.assertTrue(Reifier.Util.isReificationPredicate(RDF.Nodes.predicate));
    }

    public void testObject() {
        TestReificationPredicates.assertTrue(Reifier.Util.isReificationPredicate(RDF.Nodes.object));
    }

    public void testRest() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationPredicate(RDF.Nodes.rest));
    }

    public void testFirst() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationPredicate(RDF.Nodes.first));
    }

    public void testType() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationPredicate(RDF.Nodes.type));
    }

    public void testValue() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationPredicate(RDF.Nodes.value));
    }

    public void testSubjectInOtherNamespace() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationPredicate(TestReificationPredicates.node("subject")));
    }

    public void testStatementCouldBeStatement() {
        TestReificationPredicates.assertTrue(Reifier.Util.couldBeStatement(RDF.Nodes.Statement));
    }

    public void testVariableCouldBeStatement() {
        TestReificationPredicates.assertTrue(Reifier.Util.couldBeStatement(TestReificationPredicates.node("?x")));
    }

    public void testANYCouldBeStatement() {
        TestReificationPredicates.assertTrue(Reifier.Util.couldBeStatement(Node.ANY));
    }

    public void testPropertyCouldNotBeStatement() {
        TestReificationPredicates.assertFalse(Reifier.Util.couldBeStatement(RDF.Nodes.Property));
    }

    public void testOtherStatementCouldBeStatement() {
        TestReificationPredicates.assertFalse(Reifier.Util.couldBeStatement(TestReificationPredicates.node("Statement")));
    }

    public void testAltIsntIsReificationType() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationType(RDF.Nodes.type, RDF.Nodes.Alt));
    }

    public void testBagIsntIsReificationType() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationType(RDF.Nodes.type, RDF.Nodes.Bag));
    }

    public void testOtherStatementIsntIsReificationType() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationType(RDF.Nodes.type, TestReificationPredicates.node("Statement")));
    }

    public void testValueIsNtReificationType() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationType(RDF.Nodes.value, RDF.Nodes.Statement));
    }

    public void testValuePropertyIsntreificationType() {
        TestReificationPredicates.assertFalse(Reifier.Util.isReificationType(RDF.Nodes.value, RDF.Nodes.Property));
    }

    public void testStatementIsReificationType() {
        TestReificationPredicates.assertTrue(Reifier.Util.isReificationType(RDF.Nodes.type, RDF.Nodes.Statement));
    }

    public void testVariableIsReificationType() {
        TestReificationPredicates.assertTrue(Reifier.Util.isReificationType(RDF.Nodes.type, TestReificationPredicates.node("?x")));
    }

    public void testANYIsReificationType() {
        TestReificationPredicates.assertTrue(Reifier.Util.isReificationType(RDF.Nodes.type, Node.ANY));
    }
}

