/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.RDFNode;
import junit.framework.TestSuite;

public class TestAllDifferent
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;

    public static TestSuite suite() {
        return new TestAllDifferent("TestAllDifferent");
    }

    public TestAllDifferent(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("AllDifferent.distinctMembers", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                AllDifferent a = m.createAllDifferent();
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestAllDifferent.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource c = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#c").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestAllDifferent.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                a.addDistinctMember(b);
                1.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.DISTINCT_MEMBERS()));
                1.assertEquals("List size should be 1", 1, a.getDistinctMembers().size());
                1.assertTrue("a should have b as distinct", a.hasDistinctMember(b));
                a.addDistinctMember(c);
                1.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.DISTINCT_MEMBERS()));
                1.assertEquals("List size should be 2", 2, a.getDistinctMembers().size());
                this.iteratorTest(a.listDistinctMembers(), new Object[]{b, c});
                1.assertTrue("a should have b as distinct", a.hasDistinctMember(b));
                1.assertTrue("a should have c as distinct", a.hasDistinctMember(c));
                a.setDistinctMembers(m.createList(new RDFNode[]{b}));
                1.assertEquals("Cardinality should be 1", 1, a.getCardinality(prof.DISTINCT_MEMBERS()));
                1.assertEquals("List size should be 1", 1, a.getDistinctMembers().size());
                1.assertTrue("a should have b as distinct", a.hasDistinctMember(b));
                1.assertTrue("a should not have c as distinct", !a.hasDistinctMember(c));
                a.removeDistinctMember(b);
                1.assertTrue("a should have not b as distinct", !a.hasDistinctMember(b));
            }
        }};
    }
}

