/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestProperty
extends OntTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntResource;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    public static TestSuite suite() {
        return new TestProperty("TestProperty");
    }

    public TestProperty(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntProperty.super-property", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty q = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty r = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.addSuperProperty(q);
                1.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.SUB_PROPERTY_OF()));
                1.assertEquals("p have super-prop q", q, p.getSuperProperty());
                p.addSuperProperty(r);
                1.assertEquals("Cardinality should be 2", 2, p.getCardinality(prof.SUB_PROPERTY_OF()));
                this.iteratorTest(p.listSuperProperties(), new Object[]{q, r});
                p.setSuperProperty(r);
                1.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.SUB_PROPERTY_OF()));
                1.assertEquals("p shuold have super-prop r", r, p.getSuperProperty());
                p.removeSuperProperty(q);
                1.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.SUB_PROPERTY_OF()));
                p.removeSuperProperty(r);
                1.assertEquals("Cardinality should be 0", 0, p.getCardinality(prof.SUB_PROPERTY_OF()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.sub-property", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty q = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty r = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.addSubProperty(q);
                2.assertEquals("Cardinality should be 1", 1, q.getCardinality(prof.SUB_PROPERTY_OF()));
                2.assertEquals("p have sub-prop q", q, p.getSubProperty());
                p.addSubProperty(r);
                2.assertEquals("Cardinality should be 2", 2, q.getCardinality(prof.SUB_PROPERTY_OF()) + r.getCardinality(prof.SUB_PROPERTY_OF()));
                this.iteratorTest(p.listSubProperties(), new Object[]{q, r});
                this.iteratorTest(q.listSuperProperties(), new Object[]{p});
                this.iteratorTest(r.listSuperProperties(), new Object[]{p});
                p.setSubProperty(r);
                2.assertEquals("Cardinality should be 1", 1, q.getCardinality(prof.SUB_PROPERTY_OF()) + r.getCardinality(prof.SUB_PROPERTY_OF()));
                2.assertEquals("p should have sub-prop r", r, p.getSubProperty());
                p.removeSubProperty(q);
                2.assertTrue("Should have sub-prop r", p.hasSubProperty(r, false));
                p.removeSubProperty(r);
                2.assertTrue("Should not have sub-prop r", !p.hasSubProperty(r, false));
            }
        }, new OntTestBase.OntTestCase("OntProperty.domain", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                p.addDomain(a);
                3.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.DOMAIN()));
                3.assertEquals("p have domain a", a, p.getDomain());
                p.addDomain(b);
                3.assertEquals("Cardinality should be 2", 2, p.getCardinality(prof.DOMAIN()));
                this.iteratorTest(p.listDomain(), new Object[]{a, b});
                p.setDomain(b);
                3.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.DOMAIN()));
                3.assertEquals("p should have domain b", b, p.getDomain());
                p.removeDomain(a);
                3.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.DOMAIN()));
                p.removeDomain(b);
                3.assertEquals("Cardinality should be 0", 0, p.getCardinality(prof.DOMAIN()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.range", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(class$com$hp$hpl$jena$ontology$OntResource == null ? (class$com$hp$hpl$jena$ontology$OntResource = TestProperty.class$("com.hp.hpl.jena.ontology.OntResource")) : class$com$hp$hpl$jena$ontology$OntResource);
                p.addRange(a);
                4.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.RANGE()));
                4.assertEquals("p have range a", a, p.getRange());
                p.addRange(b);
                4.assertEquals("Cardinality should be 2", 2, p.getCardinality(prof.RANGE()));
                this.iteratorTest(p.listRange(), new Object[]{a, b});
                p.setRange(b);
                4.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.RANGE()));
                4.assertEquals("p should have range b", b, p.getRange());
                p.removeRange(a);
                4.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.RANGE()));
                p.removeRange(b);
                4.assertEquals("Cardinality should be 0", 0, p.getCardinality(prof.RANGE()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.equivalentProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.addEquivalentProperty(q);
                5.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.EQUIVALENT_PROPERTY()));
                5.assertEquals("p have equivalentProperty q", q, p.getEquivalentProperty());
                p.addEquivalentProperty(r);
                5.assertEquals("Cardinality should be 2", 2, p.getCardinality(prof.EQUIVALENT_PROPERTY()));
                this.iteratorTest(p.listEquivalentProperties(), new Object[]{q, r});
                p.setEquivalentProperty(r);
                5.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.EQUIVALENT_PROPERTY()));
                5.assertEquals("p should have equivalentProperty r", r, p.getEquivalentProperty());
                p.removeEquivalentProperty(q);
                5.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.EQUIVALENT_PROPERTY()));
                p.removeEquivalentProperty(r);
                5.assertEquals("Cardinality should be 0", 0, p.getCardinality(prof.EQUIVALENT_PROPERTY()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.inverseOf", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.addInverseOf(q);
                6.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.INVERSE_OF()));
                6.assertEquals("p should have inverse q", q, p.getInverseOf());
                p.addInverseOf(r);
                6.assertEquals("Cardinality should be 2", 2, p.getCardinality(prof.INVERSE_OF()));
                this.iteratorTest(p.listInverseOf(), new Object[]{q, r});
                p.setInverseOf(r);
                6.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.INVERSE_OF()));
                6.assertEquals("p should have inverse r", r, p.getInverseOf());
                p.removeInverseProperty(q);
                6.assertEquals("Cardinality should be 1", 1, p.getCardinality(prof.INVERSE_OF()));
                p.removeInverseProperty(r);
                6.assertEquals("Cardinality should be 0", 0, p.getCardinality(prof.INVERSE_OF()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.subproperty.fromFile", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty q = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "q").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                this.iteratorTest(p.listSuperProperties(), new Object[]{q});
                this.iteratorTest(q.listSubProperties(), new Object[]{p});
            }
        }, new OntTestBase.OntTestCase("OntProperty.domain.fromFile", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntClass A = (OntClass)m.getResource("http://jena.hpl.hp.com/testing/ontology#ClassA").as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestProperty.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
                8.assertTrue("p should have domain A", p.hasDomain(A));
            }
        }, new OntTestBase.OntTestCase("OntProperty.range.fromFile", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntClass B = (OntClass)m.getResource("http://jena.hpl.hp.com/testing/ontology#ClassB").as(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = TestProperty.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
                9.assertTrue("p should have domain B", p.hasRange(B));
            }
        }, new OntTestBase.OntTestCase("OntProperty.equivalentProeprty.fromFile", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty r = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "r").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                10.assertTrue("p should have equiv prop r", p.hasEquivalentProperty(r));
            }
        }, new OntTestBase.OntTestCase("OntProperty.inversePropertyOf.fromFile", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                OntProperty s = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "s").as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                11.assertTrue("p should have inv prop s", p.isInverseOf(s));
            }
        }, new OntTestBase.OntTestCase("OntProperty.isFunctionalProperty dt", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                DatatypeProperty p = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
                12.assertTrue("isFunctionalProperty not correct", p.isFunctionalProperty());
                12.assertTrue("isDatatypeProperty not correct", p.isDatatypeProperty());
                12.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                12.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                12.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    12.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isFunctionalProperty object", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
                13.assertTrue("isFunctionalProperty not correct", p.isFunctionalProperty());
                13.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                13.assertTrue("isObjectProperty not correct", p.isObjectProperty());
                13.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                13.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    13.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                DatatypeProperty p = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
                14.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                14.assertTrue("isDatatypeProperty not correct", p.isDatatypeProperty());
                14.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                14.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                14.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    14.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isObjectProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
                15.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                15.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                15.assertTrue("isObjectProperty not correct", p.isObjectProperty());
                15.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                15.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    15.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isTransitiveProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                TransitiveProperty p = m.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p");
                16.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                16.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                16.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                16.assertTrue("isTransitiveProperty not correct", p.isTransitiveProperty());
                16.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    16.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isInverseFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                InverseFunctionalProperty p = m.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p");
                17.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                17.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                17.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                17.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                17.assertTrue("isInverseFunctionalProperty not correct", p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    17.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isSymmetricProperty", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                SymmetricProperty p = m.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p");
                18.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                18.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                18.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                18.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                18.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    18.assertTrue("isSymmetricProperty not correct", p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                19.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                19.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                19.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                19.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                19.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    19.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
                p = p.convertToFunctionalProperty();
                19.assertTrue("isFunctionalProperty not correct", p.isFunctionalProperty());
                19.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                19.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                19.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                19.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    19.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                20.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                20.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                20.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                20.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                20.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    20.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
                20.assertTrue("isFunctionalProperty not correct", !(p = p.convertToDatatypeProperty()).isFunctionalProperty());
                20.assertTrue("isDatatypeProperty not correct", p.isDatatypeProperty());
                20.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                20.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                20.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    20.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToObjectProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                21.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                21.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                21.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                21.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                21.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    21.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
                21.assertTrue("isFunctionalProperty not correct", !(p = p.convertToObjectProperty()).isFunctionalProperty());
                21.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                21.assertTrue("isObjectProperty not correct", p.isObjectProperty());
                21.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                21.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    21.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToTransitiveProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                22.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                22.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                22.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                22.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                22.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    22.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
                22.assertTrue("isFunctionalProperty not correct", !(p = p.convertToTransitiveProperty()).isFunctionalProperty());
                22.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                22.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                22.assertTrue("isTransitiveProperty not correct", p.isTransitiveProperty());
                22.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    22.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToInverseFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                23.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                23.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                23.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                23.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                23.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    23.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
                23.assertTrue("isFunctionalProperty not correct", !(p = p.convertToInverseFunctionalProperty()).isFunctionalProperty());
                23.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                23.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                23.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                23.assertTrue("isInverseFunctionalProperty not correct", p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    23.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToSymmetricProperty", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = TestProperty.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
                24.assertTrue("isFunctionalProperty not correct", !p.isFunctionalProperty());
                24.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                24.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                24.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                24.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    24.assertTrue("isSymmetricProperty not correct", !p.isSymmetricProperty());
                }
                24.assertTrue("isFunctionalProperty not correct", !(p = p.convertToSymmetricProperty()).isFunctionalProperty());
                24.assertTrue("isDatatypeProperty not correct", !p.isDatatypeProperty());
                24.assertTrue("isObjectProperty not correct", !p.isObjectProperty());
                24.assertTrue("isTransitiveProperty not correct", !p.isTransitiveProperty());
                24.assertTrue("isInverseFunctionalProperty not correct", !p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    24.assertTrue("isSymmetricProperty not correct", p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.inverse", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                25.assertFalse("No inverse of p", p.hasInverse());
                q.addInverseOf(p);
                25.assertTrue("Inverse of p", p.hasInverse());
                25.assertEquals("inverse of p ", q, p.getInverse());
                r.addInverseOf(p);
                this.iteratorTest(p.listInverse(), new Object[]{q, r});
            }
        }, new OntTestBase.OntTestCase("OntProperty.listReferringRestrictions", true, true, true, false){

            protected void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                CardinalityRestriction r0 = m.createCardinalityRestriction(null, p, 2);
                CardinalityRestriction r1 = m.createCardinalityRestriction(null, p, 3);
                CardinalityRestriction r2 = m.createCardinalityRestriction(null, q, 2);
                CardinalityRestriction r3 = m.createCardinalityRestriction(null, q, 3);
                26.assertTrue(this.iteratorContains(p.listReferringRestrictions(), r0));
                26.assertTrue(this.iteratorContains(p.listReferringRestrictions(), r1));
                26.assertFalse(this.iteratorContains(p.listReferringRestrictions(), r2));
                26.assertFalse(this.iteratorContains(p.listReferringRestrictions(), r3));
                26.assertTrue(p.listReferringRestrictions().next() instanceof Restriction);
            }
        }};
    }
}

