/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphExtract;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelExtract;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StatementBoundary;
import com.hp.hpl.jena.rdf.model.StatementBoundaryBase;
import com.hp.hpl.jena.rdf.model.StatementTripleBoundary;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestModelExtract
extends ModelTestBase {
    protected static final StatementBoundary sbTrue = new StatementBoundaryBase(){

        public boolean stopAt(Statement s) {
            return true;
        }
    };
    protected static final StatementBoundary sbFalse = new StatementBoundaryBase(){

        public boolean stopAt(Statement s) {
            return false;
        }
    };

    public TestModelExtract(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelExtract.class);
    }

    public void testAsTripleBoundary() {
        Model m = ModelFactory.createDefaultModel();
        TestModelExtract.assertTrue(sbTrue.asTripleBoundary(m).stopAt(TestModelExtract.triple("x R y")));
        TestModelExtract.assertFalse(sbFalse.asTripleBoundary(m).stopAt(TestModelExtract.triple("x R y")));
    }

    public void testStatementTripleBoundaryAnon() {
        TripleBoundary anon = TripleBoundary.stopAtAnonObject;
        TestModelExtract.assertSame(anon, new StatementTripleBoundary(anon).asTripleBoundary(null));
        TestModelExtract.assertFalse(new StatementTripleBoundary(anon).stopAt(TestModelExtract.statement("s P o")));
        TestModelExtract.assertTrue(new StatementTripleBoundary(anon).stopAt(TestModelExtract.statement("s P _o")));
    }

    public void testStatementContinueWith() {
        StatementBoundaryBase sb = new StatementBoundaryBase(){

            public boolean continueWith(Statement s) {
                return false;
            }
        };
        TestModelExtract.assertTrue(sb.stopAt(TestModelExtract.statement("x pings y")));
    }

    public void testStatementTripleBoundaryNowhere() {
        TripleBoundary nowhere = TripleBoundary.stopNowhere;
        TestModelExtract.assertSame(nowhere, new StatementTripleBoundary(nowhere).asTripleBoundary(null));
        TestModelExtract.assertFalse(new StatementTripleBoundary(nowhere).stopAt(TestModelExtract.statement("s P _o")));
        TestModelExtract.assertFalse(new StatementTripleBoundary(nowhere).stopAt(TestModelExtract.statement("s P o")));
    }

    public void testRemembersBoundary() {
        TestModelExtract.assertSame(sbTrue, new MockModelExtract(sbTrue).getStatementBoundary());
        TestModelExtract.assertSame(sbFalse, new MockModelExtract(sbFalse).getStatementBoundary());
    }

    public void testInvokesExtract() {
        MockModelExtract mock = new MockModelExtract(sbTrue);
        Model source = TestModelExtract.modelWithStatements("a R b");
        Model m = mock.extract(TestModelExtract.resource("a"), source);
        TestModelExtract.assertEquals(TestModelExtract.node("a"), mock.root);
        TestModelExtract.assertSame(mock.result, m.getGraph());
        TestModelExtract.assertSame(mock.subject, source.getGraph());
    }

    public boolean stopAt(Statement s) {
        return false;
    }

    public TripleBoundary asTripleBoundary(Model m) {
        return null;
    }

    static class MockModelExtract
    extends ModelExtract {
        Node root;
        Graph result;
        Graph subject;

        public MockModelExtract(StatementBoundary b) {
            super(b);
        }

        public StatementBoundary getStatementBoundary() {
            return this.boundary;
        }

        protected GraphExtract getGraphExtract(TripleBoundary b) {
            return new GraphExtract(b){

                public Graph extractInto(Graph toUpdate, Node n, Graph source) {
                    MockModelExtract.this.root = n;
                    MockModelExtract.this.subject = source;
                    MockModelExtract.this.result = super.extractInto(toUpdate, n, MockModelExtract.this.subject);
                    return MockModelExtract.this.result;
                }
            };
        }
    }
}

