/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryInstancesTranslator
extends DIGQueryTranslator {
    public DIGQueryInstancesTranslator(String predicate) {
        super("*", predicate, null);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element instances = da.createQueryElement(query2, "instances");
        da.addClassDescription(instances, pattern.getObject());
        return query2;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element instances = da.createQueryElement(query2, "instances");
        if (pattern.getObject().isBlank()) {
            da.addClassDescription(instances, pattern.getObject(), premises);
        } else {
            da.addClassDescription(instances, pattern.getObject());
        }
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        return this.translateIndividualSetResponse(response, query2, false);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return da.isConcept(object, premises);
    }
}

