/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRDFS9
extends TestCase {
    public TestRDFS9(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDFS9.class);
    }

    public void testRDFSInheritance() {
        Triple t;
        Node C1 = Node.createURI("C1");
        Node C2 = Node.createURI("C2");
        Node C3 = Node.createURI("C3");
        Node C4 = Node.createURI("C4");
        Node D = Node.createURI("D");
        Node a = Node.createURI("a");
        Node b = Node.createURI("b");
        Node p = Node.createURI("p");
        Node q = Node.createURI("q");
        Node r = Node.createURI("r");
        Node sC = RDFS.subClassOf.asNode();
        Node ty = RDF.type.asNode();
        Graph tdata = Factory.createGraphMem();
        tdata.add(new Triple(C1, sC, C2));
        tdata.add(new Triple(C2, sC, C3));
        tdata.add(new Triple(p, RDFS.subPropertyOf.asNode(), q));
        tdata.add(new Triple(q, RDFS.subPropertyOf.asNode(), r));
        tdata.add(new Triple(r, RDFS.domain.asNode(), D));
        Graph data = Factory.createGraphMem();
        data.add(new Triple(a, p, b));
        InfGraph igraph = ReasonerRegistry.getRDFSReasoner().bind(new Union(tdata, data));
        TestUtil.assertIteratorValues(this, igraph.find(a, ty, null), new Object[]{new Triple(a, ty, D), new Triple(a, ty, RDFS.Resource.asNode())});
        boolean ok = false;
        Triple target = new Triple(a, ty, D);
        ExtendedIterator i = igraph.find(null, ty, null);
        while (i.hasNext()) {
            t = (Triple)i.next();
            if (!t.equals(target)) continue;
            ok = true;
            break;
        }
        TestRDFS9.assertTrue(ok);
        igraph = ReasonerRegistry.getRDFSReasoner().bindSchema(tdata).bind(data);
        TestUtil.assertIteratorValues(this, igraph.find(a, ty, null), new Object[]{new Triple(a, ty, D), new Triple(a, ty, RDFS.Resource.asNode())});
        ok = false;
        target = new Triple(a, ty, D);
        i = igraph.find(null, ty, null);
        while (i.hasNext()) {
            t = (Triple)i.next();
            if (!t.equals(target)) continue;
            ok = true;
            break;
        }
        TestRDFS9.assertTrue(ok);
    }
}

