/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.RDF;

public class TestRestrictionsDontNeedTyping
extends ModelTestBase {
    static final Property ANY = null;

    public TestRestrictionsDontNeedTyping(String name) {
        super(name);
    }

    public void testAllValuesFromFullRules() {
        this.testAllValuesFrom(OntModelSpec.OWL_MEM_RULE_INF);
    }

    public void testAllValuesFromMiniRules() {
        this.testAllValuesFrom(OntModelSpec.OWL_MEM_MINI_RULE_INF);
    }

    public void testAllValuesFromMicroRules() {
    }

    private void testAllValuesFrom(OntModelSpec owlSpec) {
        Model m = this.model("V owl:equivalentClass _R; _R owl:onProperty P; _R owl:allValuesFrom T; X rdf:type V; X P t");
        OntModel ont = ModelFactory.createOntologyModel(owlSpec, m);
        TestRestrictionsDontNeedTyping.assertTrue(ont.contains(TestRestrictionsDontNeedTyping.resource("t"), RDF.type, TestRestrictionsDontNeedTyping.resource("T")));
    }

    public void testSomeValuesFromMiniRules() {
        this.testSomeValuesFrom(OntModelSpec.OWL_MEM_MINI_RULE_INF);
    }

    public void testSomeValuesFromMicroRules() {
        this.testSomeValuesFrom(OntModelSpec.OWL_MEM_MICRO_RULE_INF);
    }

    public void testSomeValuesFromFullRules() {
        this.testSomeValuesFrom(OntModelSpec.OWL_MEM_RULE_INF);
    }

    private void testSomeValuesFrom(OntModelSpec owlSpec) {
        Model m = this.model("V owl:equivalentClass _R; _R owl:onProperty P; _R owl:someValuesFrom T; X P t; t rdf:type T");
        OntModel ont = ModelFactory.createOntologyModel(owlSpec, m);
        TestRestrictionsDontNeedTyping.assertTrue(ont.contains(TestRestrictionsDontNeedTyping.resource("X"), RDF.type, TestRestrictionsDontNeedTyping.resource("V")));
    }

    public void testCardinalityFullRules() {
        this.testCardinality(OntModelSpec.OWL_MEM_RULE_INF);
    }

    private void testCardinality(OntModelSpec owlSpec) {
        Model m = this.model("V owl:equivalentClass _R; _R rdf:type owl:Restriction; _R owl:onProperty P; _R owl:cardinality 1; X rdf:type V");
        OntModel ont = ModelFactory.createOntologyModel(owlSpec, m);
        TestRestrictionsDontNeedTyping.assertEquals(1, ont.listStatements(TestRestrictionsDontNeedTyping.resource("X"), TestRestrictionsDontNeedTyping.property("P"), ANY).toList().size());
    }

    Model model(String statements) {
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes(PrefixMapping.Extended);
        return TestRestrictionsDontNeedTyping.modelAdd(result, statements);
    }
}

