/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.regression.NewRegressionContainerMethods;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionAltMethods
extends NewRegressionContainerMethods {
    public NewRegressionAltMethods(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionAltMethods.class);
    }

    protected Container createContainer() {
        return this.m.createAlt();
    }

    protected Resource getContainerType() {
        return RDF.Alt;
    }

    public void testDefaults() {
        Alt a = this.m.createAlt();
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        Resource tvResObj = this.m.createResource(new Regression.ResTestObjF());
        Bag tvBag = this.m.createBag();
        Alt tvAlt = this.m.createAlt();
        Seq tvSeq = this.m.createSeq();
        Resource tvResource = this.m.createResource();
        NewRegressionAltMethods.assertEquals(tvLiteral, a.setDefault(tvLiteral).getDefault());
        NewRegressionAltMethods.assertEquals(tvLiteral, a.getDefaultLiteral());
        NewRegressionAltMethods.assertEquals(tvResource, a.setDefault(tvResource).getDefaultResource());
        NewRegressionAltMethods.assertEquals((byte)1, a.setDefault(1L).getDefaultByte());
        NewRegressionAltMethods.assertEquals((short)2, a.setDefault(2L).getDefaultShort());
        NewRegressionAltMethods.assertEquals(-1, a.setDefault(-1L).getDefaultInt());
        NewRegressionAltMethods.assertEquals(-2L, a.setDefault(-2L).getDefaultLong());
        NewRegressionAltMethods.assertEquals(123.456f, a.setDefault(123.456f).getDefaultFloat(), 5.0E-6f);
        NewRegressionAltMethods.assertEquals(-123.456, a.setDefault(-123.456).getDefaultDouble(), 5.0E-9);
        NewRegressionAltMethods.assertEquals('!', a.setDefault('!').getDefaultChar());
        NewRegressionAltMethods.assertEquals("test 12 string", a.setDefault("test 12 string").getDefaultString());
        NewRegressionAltMethods.assertEquals(tvResObj, a.setDefault(tvResObj).getDefaultResource());
        NewRegressionAltMethods.assertEquals(tvLitObj, a.setDefault(tvLitObj).getDefaultObject(new Regression.LitTestObjF()));
        NewRegressionAltMethods.assertEquals(tvAlt, a.setDefault(tvAlt).getDefaultAlt());
        NewRegressionAltMethods.assertEquals(tvBag, a.setDefault(tvBag).getDefaultBag());
        NewRegressionAltMethods.assertEquals(tvSeq, a.setDefault(tvSeq).getDefaultSeq());
    }
}

