/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.test;

import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTestPrefixMapping
extends GraphTestBase {
    static final String crispURI = "http://crisp.nosuch.net/";
    static final String ropeURI = "scheme:rope/string#";
    static final String butterURI = "ftp://ftp.nowhere.at.all/cream#";
    static final String[] badNames = new String[]{"<hello>", "foo:bar", "with a space", "-argument"};
    static final String[] dontChange = new String[]{"", "http://www.somedomain.something/whatever#", "crispy:cabbage", "cris:isOnInfiniteEarths", "rop:tangled/web", "roped:abseiling"};
    static final String[][] expansions = new String[][]{{"crisp:pathPart", "http://crisp.nosuch.net/pathPart"}, {"rope:partPath", "scheme:rope/string#partPath"}, {"crisp:path:part", "http://crisp.nosuch.net/path:part"}};

    public AbstractTestPrefixMapping(String name) {
        super(name);
    }

    protected abstract PrefixMapping getMapping();

    public void testEmptyPrefix() {
        PrefixMapping pm = this.getMapping();
        pm.setNsPrefix("", crispURI);
        AbstractTestPrefixMapping.assertEquals(crispURI, pm.getNsPrefixURI(""));
    }

    public void testCheckNames() {
        PrefixMapping ns = this.getMapping();
        for (int i = 0; i < badNames.length; ++i) {
            String bad = badNames[i];
            try {
                ns.setNsPrefix(bad, crispURI);
                AbstractTestPrefixMapping.fail("'" + bad + "' is an illegal prefix and should be trapped");
                continue;
            }
            catch (PrefixMapping.IllegalPrefixException e2) {
                AbstractTestPrefixMapping.pass();
            }
        }
    }

    public void testNullURITrapped() {
        try {
            this.getMapping().setNsPrefix("xy", null);
            AbstractTestPrefixMapping.fail("shouild trap null URI in setNsPrefix");
        }
        catch (NullPointerException e2) {
            AbstractTestPrefixMapping.pass();
        }
    }

    public void testPrefixMappingMapping() {
        String toast = "ftp://ftp.nowhere.not/";
        AbstractTestPrefixMapping.assertDiffer("crisp and toast must differ", crispURI, toast);
        PrefixMapping ns = this.getMapping();
        AbstractTestPrefixMapping.assertEquals("crisp should be unset", null, ns.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should be unset", null, ns.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should be unset", null, ns.getNsPrefixURI("butter"));
        ns.setNsPrefix("crisp", crispURI);
        AbstractTestPrefixMapping.assertEquals("crisp should be set", crispURI, ns.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should still be unset", null, ns.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should still be unset", null, ns.getNsPrefixURI("butter"));
        ns.setNsPrefix("toast", toast);
        AbstractTestPrefixMapping.assertEquals("crisp should be set", crispURI, ns.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals("toast should be set", toast, ns.getNsPrefixURI("toast"));
        AbstractTestPrefixMapping.assertEquals("butter should still be unset", null, ns.getNsPrefixURI("butter"));
    }

    public void testReversePrefixMapping() {
        PrefixMapping ns = this.getMapping();
        String uriA = "http://jena.hpl.hp.com/A#";
        String uriB = "http://jena.hpl.hp.com/";
        String uriC = "http://jena.hpl.hp.com/Csharp/";
        String prefixA = "aa";
        String prefixB = "bb";
        ns.setNsPrefix(prefixA, uriA).setNsPrefix(prefixB, uriB);
        AbstractTestPrefixMapping.assertEquals(null, ns.getNsURIPrefix(uriC));
        AbstractTestPrefixMapping.assertEquals(prefixA, ns.getNsURIPrefix(uriA));
        AbstractTestPrefixMapping.assertEquals(prefixB, ns.getNsURIPrefix(uriB));
    }

    public void testPrefixMappingMap() {
        PrefixMapping ns = this.getCrispyRope();
        Map map = ns.getNsPrefixMap();
        AbstractTestPrefixMapping.assertEquals("map should have two elements", 2, map.size());
        AbstractTestPrefixMapping.assertEquals((Object)crispURI, map.get("crisp"));
        AbstractTestPrefixMapping.assertEquals((Object)ropeURI, map.get("rope"));
    }

    public void testPrefixMappingSecret() {
        PrefixMapping ns = this.getCrispyRope();
        Map map = ns.getNsPrefixMap();
        map.put("crisp", "with/onions");
        map.put("sandwich", "with/cheese");
        AbstractTestPrefixMapping.assertEquals(crispURI, ns.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(ropeURI, ns.getNsPrefixURI("rope"));
        AbstractTestPrefixMapping.assertEquals(null, ns.getNsPrefixURI("sandwich"));
    }

    private PrefixMapping getCrispyRope() {
        PrefixMapping ns = this.getMapping();
        ns.setNsPrefix("crisp", crispURI);
        ns.setNsPrefix("rope", ropeURI);
        return ns;
    }

    public void testExpandPrefix() {
        int i;
        PrefixMapping ns = this.getMapping();
        ns.setNsPrefix("crisp", crispURI);
        ns.setNsPrefix("rope", ropeURI);
        for (i = 0; i < dontChange.length; ++i) {
            AbstractTestPrefixMapping.assertEquals("should be unchanged", dontChange[i], ns.expandPrefix(dontChange[i]));
        }
        for (i = 0; i < expansions.length; ++i) {
            AbstractTestPrefixMapping.assertEquals("should expand correctly", expansions[i][1], ns.expandPrefix(expansions[i][0]));
        }
    }

    public void testUseEasyPrefix() {
        AbstractTestPrefixMapping.testUseEasyPrefix("prefix mapping impl", this.getMapping());
        AbstractTestPrefixMapping.testShortForm("prefix mapping impl", this.getMapping());
    }

    public static void testUseEasyPrefix(String title, PrefixMapping ns) {
        AbstractTestPrefixMapping.testShortForm(title, ns);
    }

    public static void testShortForm(String title, PrefixMapping ns) {
        ns.setNsPrefix("crisp", crispURI);
        ns.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals(title, "", ns.shortForm(""));
        AbstractTestPrefixMapping.assertEquals(title, ropeURI, ns.shortForm(ropeURI));
        AbstractTestPrefixMapping.assertEquals(title, "crisp:tail", ns.shortForm("http://crisp.nosuch.net/tail"));
        AbstractTestPrefixMapping.assertEquals(title, "butter:here:we:are", ns.shortForm("ftp://ftp.nowhere.at.all/cream#here:we:are"));
    }

    public void testEasyQName() {
        PrefixMapping ns = this.getMapping();
        String alphaURI = "http://seasonal.song/preamble/";
        ns.setNsPrefix("alpha", alphaURI);
        AbstractTestPrefixMapping.assertEquals("alpha:rowboat", ns.qnameFor(alphaURI + "rowboat"));
    }

    public void testNoQNameNoPrefix() {
        PrefixMapping ns = this.getMapping();
        String alphaURI = "http://seasonal.song/preamble/";
        ns.setNsPrefix("alpha", alphaURI);
        AbstractTestPrefixMapping.assertEquals(null, ns.qnameFor("eg:rowboat"));
    }

    public void testNoQNameBadLocal() {
        PrefixMapping ns = this.getMapping();
        String alphaURI = "http://seasonal.song/preamble/";
        ns.setNsPrefix("alpha", alphaURI);
        AbstractTestPrefixMapping.assertEquals(null, ns.qnameFor(alphaURI + "12345"));
    }

    public void testQnameFromEmail() {
        String uri = "http://some.long.uri/for/a/namespace#";
        PrefixMapping ns = this.getMapping();
        ns.setNsPrefix("x", uri);
        AbstractTestPrefixMapping.assertEquals(null, ns.qnameFor(uri));
        AbstractTestPrefixMapping.assertEquals(null, ns.qnameFor(uri + "non/fiction"));
    }

    public void testAddOtherPrefixMapping() {
        PrefixMapping b;
        PrefixMapping a = this.getMapping();
        AbstractTestPrefixMapping.assertFalse("must have two diffferent maps", a == (b = this.getMapping()));
        a.setNsPrefix("crisp", crispURI);
        a.setNsPrefix("rope", ropeURI);
        b.setNsPrefix("butter", butterURI);
        AbstractTestPrefixMapping.assertEquals(null, b.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(null, b.getNsPrefixURI("rope"));
        b.setNsPrefixes(a);
        this.checkContainsMapping(b);
    }

    private void checkContainsMapping(PrefixMapping b) {
        AbstractTestPrefixMapping.assertEquals(crispURI, b.getNsPrefixURI("crisp"));
        AbstractTestPrefixMapping.assertEquals(ropeURI, b.getNsPrefixURI("rope"));
        AbstractTestPrefixMapping.assertEquals(butterURI, b.getNsPrefixURI("butter"));
    }

    public void testAddMap() {
        PrefixMapping b = this.getMapping();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("crisp", crispURI);
        map.put("rope", ropeURI);
        b.setNsPrefix("butter", butterURI);
        b.setNsPrefixes(map);
        this.checkContainsMapping(b);
    }

    public void testAddDefaultMap() {
        PrefixMapping pm = this.getMapping();
        PrefixMapping root = PrefixMapping.Factory.create();
        pm.setNsPrefix("a", "aPrefix:");
        pm.setNsPrefix("b", "bPrefix:");
        root.setNsPrefix("a", "pootle:");
        root.setNsPrefix("z", "bPrefix:");
        root.setNsPrefix("c", "cootle:");
        AbstractTestPrefixMapping.assertSame(pm, pm.withDefaultMappings(root));
        AbstractTestPrefixMapping.assertEquals("aPrefix:", pm.getNsPrefixURI("a"));
        AbstractTestPrefixMapping.assertEquals(null, pm.getNsPrefixURI("z"));
        AbstractTestPrefixMapping.assertEquals("bPrefix:", pm.getNsPrefixURI("b"));
        AbstractTestPrefixMapping.assertEquals("cootle:", pm.getNsPrefixURI("c"));
    }

    public void testSecondPrefixRetainsExistingMap() {
        PrefixMapping A = this.getMapping();
        A.setNsPrefix("a", crispURI);
        A.setNsPrefix("b", crispURI);
        AbstractTestPrefixMapping.assertEquals(crispURI, A.getNsPrefixURI("a"));
        AbstractTestPrefixMapping.assertEquals(crispURI, A.getNsPrefixURI("b"));
    }

    public void testSecondPrefixReplacesReverseMap() {
        PrefixMapping A = this.getMapping();
        A.setNsPrefix("a", crispURI);
        A.setNsPrefix("b", crispURI);
        AbstractTestPrefixMapping.assertEquals("b", A.getNsURIPrefix(crispURI));
    }

    public void testSecondPrefixDeletedUncoversPreviousMap() {
        PrefixMapping A = this.getMapping();
        A.setNsPrefix("x", crispURI);
        A.setNsPrefix("y", crispURI);
        A.removeNsPrefix("y");
        AbstractTestPrefixMapping.assertEquals("x", A.getNsURIPrefix(crispURI));
    }

    public void testEmptyDoesNotWipeURI() {
        PrefixMapping pm = this.getMapping();
        pm.setNsPrefix("frodo", ropeURI);
        pm.setNsPrefix("", ropeURI);
        AbstractTestPrefixMapping.assertEquals(ropeURI, pm.getNsPrefixURI("frodo"));
    }

    public void testSameURIKeepsDefault() {
        PrefixMapping A = this.getMapping();
        A.setNsPrefix("", crispURI);
        A.setNsPrefix("crisp", crispURI);
        AbstractTestPrefixMapping.assertEquals(crispURI, A.getNsPrefixURI(""));
    }

    public void testReturnsSelf() {
        PrefixMapping A = this.getMapping();
        AbstractTestPrefixMapping.assertSame(A, A.setNsPrefix("crisp", crispURI));
        AbstractTestPrefixMapping.assertSame(A, A.setNsPrefixes(A));
        AbstractTestPrefixMapping.assertSame(A, A.setNsPrefixes(new HashMap()));
        AbstractTestPrefixMapping.assertSame(A, A.removeNsPrefix("rhubarb"));
    }

    public void testRemovePrefix() {
        String hURI = "http://test.remove.prefixes/prefix#";
        String bURI = "http://other.test.remove.prefixes/prefix#";
        PrefixMapping A = this.getMapping();
        A.setNsPrefix("hr", hURI);
        A.setNsPrefix("br", bURI);
        A.removeNsPrefix("hr");
        AbstractTestPrefixMapping.assertEquals(null, A.getNsPrefixURI("hr"));
        AbstractTestPrefixMapping.assertEquals(bURI, A.getNsPrefixURI("br"));
    }

    public void testEquality() {
        this.testEquals("");
        this.testEquals("", "x=a", false);
        this.testEquals("x=a", "", false);
        this.testEquals("x=a");
        this.testEquals("x=a y=b", "y=b x=a", true);
        this.testEquals("x=a x=b", "x=b x=a", false);
    }

    protected void testEquals(String S) {
        this.testEquals(S, S, true);
    }

    protected void testEquals(String S, String T, boolean expected) {
        this.testEqualsBase(S, T, expected);
        this.testEqualsBase(T, S, expected);
    }

    public void testEqualsBase(String S, String T, boolean expected) {
        this.testEquals(S, T, expected, this.getMapping(), this.getMapping());
        this.testEquals(S, T, expected, PrefixMapping.Factory.create(), this.getMapping());
    }

    protected void testEquals(String S, String T, boolean expected, PrefixMapping A, PrefixMapping B) {
        this.fill(A, S);
        this.fill(B, T);
        String title = "usual: '" + S + "', testing: '" + T + "', should be " + (expected ? "equal" : "different");
        AbstractTestPrefixMapping.assertEquals(title, expected, A.samePrefixMappingAs(B));
        AbstractTestPrefixMapping.assertEquals(title, expected, B.samePrefixMappingAs(A));
    }

    protected void fill(PrefixMapping pm, String settings) {
        List L = AbstractTestPrefixMapping.listOfStrings(settings);
        for (int i = 0; i < L.size(); ++i) {
            String setting = (String)L.get(i);
            int eq = setting.indexOf(61);
            pm.setNsPrefix(setting.substring(0, eq), setting.substring(eq + 1));
        }
    }

    public void testAllowNastyNamespace() {
        this.getMapping().setNsPrefix("abc", "def");
    }

    public void testLock() {
        PrefixMapping A = this.getMapping();
        AbstractTestPrefixMapping.assertSame(A, A.lock());
        try {
            A.setNsPrefix("crisp", crispURI);
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException e2) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            A.setNsPrefixes(A);
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException e3) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            A.setNsPrefixes(new HashMap());
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException e4) {
            AbstractTestPrefixMapping.pass();
        }
        try {
            A.removeNsPrefix("toast");
            AbstractTestPrefixMapping.fail("mapping should be frozen");
        }
        catch (PrefixMapping.JenaLockedException e5) {
            AbstractTestPrefixMapping.pass();
        }
    }
}

