/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConvert;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import java.util.Iterator;

public class QueryIterExtend
extends QueryIterConvert {
    public QueryIterExtend(QueryIterator input, VarExprList exprs, ExecutionContext qCxt) {
        super(input, new Extend(exprs, qCxt), qCxt);
    }

    static class Extend
    implements QueryIterConvert.Converter {
        FunctionEnv funcEnv;
        VarExprList exprs;

        Extend(VarExprList exprs, ExecutionContext qCxt) {
            this.exprs = exprs;
            this.funcEnv = qCxt;
        }

        public Binding convert(Binding bind) {
            BindingMap b = new BindingMap(bind);
            Iterator iter = this.exprs.getVars().iterator();
            while (iter.hasNext()) {
                Var v = (Var)iter.next();
                if (b.contains(v)) {
                    throw new QueryExecException("Already set: " + v);
                }
                Node n = this.exprs.get(v, bind, this.funcEnv);
                if (n == null) continue;
                b.add(v, n);
            }
            return b;
        }
    }
}

