/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import java.util.HashSet;
import java.util.Set;

public class AggCountVarDistinct
implements AggregateFactory {
    private Var var;

    public AggCountVarDistinct(Var var) {
        this.var = var;
    }

    public Aggregator create() {
        return new AggCountVarDistinctWorker();
    }

    class AccCountVarDistinct
    implements Accumulator {
        private Set seen = new HashSet();

        public void accumulate(Binding binding) {
            Node n = binding.get(AggCountVarDistinct.this.var);
            if (n == null) {
                return;
            }
            this.seen.add(n);
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.seen.size());
        }
    }

    class AggCountVarDistinctWorker
    extends AggregatorBase {
        public String toString() {
            return "count(distinct " + AggCountVarDistinct.this.var + ")";
        }

        public String toPrefixString() {
            return "(count distinct " + AggCountVarDistinct.this.var + ")";
        }

        protected Accumulator createAccumulator() {
            return new AccCountVarDistinct();
        }

        public Node getValueEmpty() {
            return NodeValue.nodeIntZERO;
        }
    }
}

