/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.BadURIException;
import com.hp.hpl.jena.xmloutput.test.PrettyWriterTest;
import com.hp.hpl.jena.xmloutput.test.TestEntityOutput;
import com.hp.hpl.jena.xmloutput.test.TestLiteralEncoding;
import com.hp.hpl.jena.xmloutput.test.TestMacEncodings;
import com.hp.hpl.jena.xmloutput.test.testWriterAndReader;
import com.hp.hpl.jena.xmloutput.test.testWriterInterface;
import java.io.StringWriter;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPackage
extends TestCase {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(TestMacEncodings.suite());
        suite.addTestSuite(PrettyWriterTest.class);
        suite.addTest(new testWriterInterface("testInterface", null));
        suite.addTest(new testWriterInterface("testNoWriter", null));
        suite.addTest(new testWriterInterface("testAnotherWriter", null));
        suite.addTest(testWriterAndReader.suiteXML());
        suite.addTest(testWriterAndReader.suiteXML_ABBREV());
        suite.addTest(testWriterAndReader.suiteN_TRIPLE());
        suite.addTestSuite(TestURIExceptions.class);
        suite.addTestSuite(TestEntityOutput.class);
        suite.addTestSuite(TestLiteralEncoding.class);
        return suite;
    }

    public static class TestURIExceptions
    extends TestCase {
        public TestURIExceptions(String name) {
            super(name);
        }

        public void testBadURIExceptionContainsBadURIInMessage() {
            String badURI = "http:";
            Model m = ModelFactory.createDefaultModel();
            m.add(m.createResource(badURI), m.createProperty("eg:B C"), m.createResource("eg:C D"));
            try {
                m.write(new StringWriter());
                TestURIExceptions.fail("should detect bad URI " + badURI);
            }
            catch (BadURIException e2) {
                TestURIExceptions.assertTrue("message must contain failing URI", e2.getMessage().indexOf(badURI) > 0);
            }
        }
    }
}

