/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.portlet;

import java.io.IOException;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import org.apache.commons.fileupload.UploadContext;

public class PortletRequestContext
implements UploadContext {
    private final ActionRequest request;

    public PortletRequestContext(ActionRequest request) {
        this.request = request;
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    @Deprecated
    public int getContentLength() {
        return this.request.getContentLength();
    }

    public long contentLength() {
        long size;
        try {
            size = Long.parseLong(this.request.getProperty("Content-length"));
        }
        catch (NumberFormatException e2) {
            size = this.request.getContentLength();
        }
        return size;
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getPortletInputStream();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.contentLength(), this.getContentType());
    }
}

