/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommitPoint;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;

final class IndexFileDeleter {
    private List deletable;
    private Map refCounts = new HashMap();
    private List commits = new ArrayList();
    private List lastFiles = new ArrayList();
    private List commitsToDelete = new ArrayList();
    private PrintStream infoStream;
    private Directory directory;
    private IndexDeletionPolicy policy;

    void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    private void message(String message) {
        this.infoStream.println(this + " " + Thread.currentThread().getName() + ": " + message);
    }

    public IndexFileDeleter(Directory directory, IndexDeletionPolicy policy, SegmentInfos segmentInfos, PrintStream infoStream) throws CorruptIndexException, IOException {
        String fileName;
        this.infoStream = infoStream;
        this.policy = policy;
        this.directory = directory;
        long currentGen = segmentInfos.getGeneration();
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        String[] files = directory.list();
        if (files == null) {
            throw new IOException("cannot read directory " + directory + ": list() returned null");
        }
        CommitPoint currentCommitPoint = null;
        for (int i = 0; i < files.length; ++i) {
            fileName = files[i];
            if (!filter.accept(null, fileName) || fileName.equals("segments.gen")) continue;
            this.getRefCount(fileName);
            if (!fileName.startsWith("segments") || SegmentInfos.generationFromSegmentsFileName(fileName) > currentGen) continue;
            if (infoStream != null) {
                this.message("init: load commit \"" + fileName + "\"");
            }
            SegmentInfos sis = new SegmentInfos();
            sis.read(directory, fileName);
            CommitPoint commitPoint = new CommitPoint(sis);
            if (sis.getGeneration() == segmentInfos.getGeneration()) {
                currentCommitPoint = commitPoint;
            }
            this.commits.add(commitPoint);
            this.incRef(sis, true);
        }
        if (currentCommitPoint == null) {
            throw new CorruptIndexException("failed to locate current segments_N file");
        }
        Collections.sort(this.commits);
        Iterator it = this.refCounts.keySet().iterator();
        while (it.hasNext()) {
            fileName = (String)it.next();
            RefCount rc = (RefCount)this.refCounts.get(fileName);
            if (0 != rc.count) continue;
            if (infoStream != null) {
                this.message("init: removing unreferenced file \"" + fileName + "\"");
            }
            this.deleteFile(fileName);
        }
        policy.onInit(this.commits);
        if (currentCommitPoint.deleted) {
            this.checkpoint(segmentInfos, false);
        }
        this.deleteCommits();
    }

    private void deleteCommits() throws IOException {
        int size = this.commitsToDelete.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                CommitPoint commit = (CommitPoint)this.commitsToDelete.get(i);
                if (this.infoStream != null) {
                    this.message("deleteCommits: now remove commit \"" + commit.getSegmentsFileName() + "\"");
                }
                int size2 = commit.files.size();
                for (int j = 0; j < size2; ++j) {
                    this.decRef((List)commit.files.get(j));
                }
                this.decRef(commit.getSegmentsFileName());
            }
            this.commitsToDelete.clear();
            size = this.commits.size();
            int writeTo = 0;
            for (int readFrom = 0; readFrom < size; ++readFrom) {
                CommitPoint commit = (CommitPoint)this.commits.get(readFrom);
                if (commit.deleted) continue;
                if (writeTo != readFrom) {
                    this.commits.set(writeTo, this.commits.get(readFrom));
                }
                ++writeTo;
            }
            while (size > writeTo) {
                this.commits.remove(size - 1);
                --size;
            }
        }
    }

    public void refresh() throws IOException {
        String[] files = this.directory.list();
        if (files == null) {
            throw new IOException("cannot read directory " + this.directory + ": list() returned null");
        }
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!filter.accept(null, fileName) || this.refCounts.containsKey(fileName) || fileName.equals("segments.gen")) continue;
            if (this.infoStream != null) {
                this.message("refresh: removing newly created unreferenced file \"" + fileName + "\"");
            }
            this.deleteFile(fileName);
        }
    }

    public void checkpoint(SegmentInfos segmentInfos, boolean isCommit) throws IOException {
        int i;
        int size;
        if (this.infoStream != null) {
            this.message("now checkpoint \"" + segmentInfos.getCurrentSegmentFileName() + "\" [isCommit = " + isCommit + "]");
        }
        if (this.deletable != null) {
            List oldDeletable = this.deletable;
            this.deletable = null;
            int size2 = oldDeletable.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                this.deleteFile((String)oldDeletable.get(i2));
            }
        }
        this.incRef(segmentInfos, isCommit);
        if (isCommit) {
            this.commits.add(new CommitPoint(segmentInfos));
            this.policy.onCommit(this.commits);
            this.deleteCommits();
        }
        if ((size = this.lastFiles.size()) > 0) {
            for (i = 0; i < size; ++i) {
                this.decRef((List)this.lastFiles.get(i));
            }
            this.lastFiles.clear();
        }
        if (!isCommit) {
            size = segmentInfos.size();
            for (i = 0; i < size; ++i) {
                SegmentInfo segmentInfo = segmentInfos.info(i);
                if (segmentInfo.dir != this.directory) continue;
                this.lastFiles.add(segmentInfo.files());
            }
        }
    }

    void incRef(SegmentInfos segmentInfos, boolean isCommit) throws IOException {
        int size = segmentInfos.size();
        for (int i = 0; i < size; ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (segmentInfo.dir != this.directory) continue;
            this.incRef(segmentInfo.files());
        }
        if (isCommit) {
            this.getRefCount(segmentInfos.getCurrentSegmentFileName()).IncRef();
        }
    }

    private void incRef(List files) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            String fileName = (String)files.get(i);
            RefCount rc = this.getRefCount(fileName);
            if (this.infoStream != null) {
                this.message("  IncRef \"" + fileName + "\": pre-incr count is " + rc.count);
            }
            rc.IncRef();
        }
    }

    private void decRef(List files) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            this.decRef((String)files.get(i));
        }
    }

    private void decRef(String fileName) throws IOException {
        RefCount rc = this.getRefCount(fileName);
        if (this.infoStream != null) {
            this.message("  DecRef \"" + fileName + "\": pre-decr count is " + rc.count);
        }
        if (0 == rc.DecRef()) {
            this.deleteFile(fileName);
            this.refCounts.remove(fileName);
        }
    }

    void decRef(SegmentInfos segmentInfos) throws IOException {
        int size = segmentInfos.size();
        for (int i = 0; i < size; ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (segmentInfo.dir != this.directory) continue;
            this.decRef(segmentInfo.files());
        }
    }

    private RefCount getRefCount(String fileName) {
        RefCount rc;
        if (!this.refCounts.containsKey(fileName)) {
            rc = new RefCount();
            this.refCounts.put(fileName, rc);
        } else {
            rc = (RefCount)this.refCounts.get(fileName);
        }
        return rc;
    }

    private void deleteFile(String fileName) throws IOException {
        block5: {
            try {
                if (this.infoStream != null) {
                    this.message("delete \"" + fileName + "\"");
                }
                this.directory.deleteFile(fileName);
            }
            catch (IOException e2) {
                if (!this.directory.fileExists(fileName)) break block5;
                if (this.infoStream != null) {
                    this.message("IndexFileDeleter: unable to remove file \"" + fileName + "\": " + e2.toString() + "; Will re-try later.");
                }
                if (this.deletable == null) {
                    this.deletable = new ArrayList();
                }
                this.deletable.add(fileName);
            }
        }
    }

    public void deleteDirect(Directory otherDir, List segments) throws IOException {
        int size = segments.size();
        for (int i = 0; i < size; ++i) {
            List filestoDelete = ((SegmentInfo)segments.get(i)).files();
            int size2 = filestoDelete.size();
            for (int j = 0; j < size2; ++j) {
                otherDir.deleteFile((String)filestoDelete.get(j));
            }
        }
    }

    private final class CommitPoint
    implements Comparable,
    IndexCommitPoint {
        long gen;
        List files;
        String segmentsFileName;
        boolean deleted;

        public CommitPoint(SegmentInfos segmentInfos) throws IOException {
            this.segmentsFileName = segmentInfos.getCurrentSegmentFileName();
            int size = segmentInfos.size();
            this.files = new ArrayList(size);
            this.gen = segmentInfos.getGeneration();
            for (int i = 0; i < size; ++i) {
                SegmentInfo segmentInfo = segmentInfos.info(i);
                if (segmentInfo.dir != IndexFileDeleter.this.directory) continue;
                this.files.add(segmentInfo.files());
            }
        }

        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public void delete() {
            if (!this.deleted) {
                this.deleted = true;
                IndexFileDeleter.this.commitsToDelete.add(this);
            }
        }

        public int compareTo(Object obj) {
            CommitPoint commit = (CommitPoint)obj;
            if (this.gen < commit.gen) {
                return -1;
            }
            if (this.gen > commit.gen) {
                return 1;
            }
            return 0;
        }
    }

    private static final class RefCount {
        int count;

        private RefCount() {
        }

        private final int IncRef() {
            return ++this.count;
        }

        private final int DecRef() {
            return --this.count;
        }
    }
}

