/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.versioning;

import java.util.StringTokenizer;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class DefaultArtifactVersion
implements ArtifactVersion {
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer incrementalVersion;
    private Integer buildNumber;
    private String qualifier;

    public DefaultArtifactVersion(String version2) {
        this.parseVersion(version2);
    }

    public int compareTo(Object o) {
        DefaultArtifactVersion otherVersion = (DefaultArtifactVersion)o;
        int result = this.compareIntegers(this.majorVersion, otherVersion.majorVersion);
        if (result == 0) {
            result = this.compareIntegers(this.minorVersion, otherVersion.minorVersion);
        }
        if (result == 0) {
            result = this.compareIntegers(this.incrementalVersion, otherVersion.incrementalVersion);
        }
        if (result == 0) {
            if (this.buildNumber != null || otherVersion.buildNumber != null) {
                result = this.compareIntegers(this.buildNumber, otherVersion.buildNumber);
            } else if (this.qualifier != null) {
                result = otherVersion.qualifier != null ? (this.qualifier.length() > otherVersion.qualifier.length() && this.qualifier.startsWith(otherVersion.qualifier) ? -1 : (this.qualifier.length() < otherVersion.qualifier.length() && otherVersion.qualifier.startsWith(this.qualifier) ? 1 : this.qualifier.compareTo(otherVersion.qualifier))) : -1;
            } else if (otherVersion.qualifier != null) {
                result = 1;
            }
        }
        return result;
    }

    private int compareIntegers(Integer i1, Integer i2) {
        if (i1 == null ? i2 == null : i1.equals(i2)) {
            return 0;
        }
        if (i1 == null) {
            return -1;
        }
        if (i2 == null) {
            return 1;
        }
        return i1 - i2;
    }

    public int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    public int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    public int getIncrementalVersion() {
        return this.incrementalVersion != null ? this.incrementalVersion : 0;
    }

    public int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public final void parseVersion(String version2) {
        String part1;
        int index = version2.indexOf("-");
        String part2 = null;
        if (index < 0) {
            part1 = version2;
        } else {
            part1 = version2.substring(0, index);
            part2 = version2.substring(index + 1);
        }
        if (part2 != null) {
            try {
                if (part2.length() == 1 || !part2.startsWith("0")) {
                    this.buildNumber = Integer.valueOf(part2);
                } else {
                    this.qualifier = part2;
                }
            }
            catch (NumberFormatException e2) {
                this.qualifier = part2;
            }
        }
        if (part1.indexOf(".") < 0 && !part1.startsWith("0")) {
            try {
                this.majorVersion = Integer.valueOf(part1);
            }
            catch (NumberFormatException e3) {
                this.qualifier = version2;
                this.buildNumber = null;
            }
        } else {
            boolean fallback = false;
            StringTokenizer tok = new StringTokenizer(part1, ".");
            try {
                this.majorVersion = DefaultArtifactVersion.getNextIntegerToken(tok);
                if (tok.hasMoreTokens()) {
                    this.minorVersion = DefaultArtifactVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    this.incrementalVersion = DefaultArtifactVersion.getNextIntegerToken(tok);
                }
                if (tok.hasMoreTokens()) {
                    fallback = true;
                }
            }
            catch (NumberFormatException e4) {
                fallback = true;
            }
            if (fallback) {
                this.qualifier = version2;
                this.majorVersion = null;
                this.minorVersion = null;
                this.incrementalVersion = null;
            }
        }
    }

    private static Integer getNextIntegerToken(StringTokenizer tok) {
        String s = tok.nextToken();
        if (s.length() > 1 && s.startsWith("0")) {
            throw new NumberFormatException("Number part has a leading 0: '" + s + "'");
        }
        return Integer.valueOf(s);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.majorVersion != null) {
            buf.append(this.majorVersion);
        }
        if (this.minorVersion != null) {
            buf.append(".");
            buf.append(this.minorVersion);
        }
        if (this.incrementalVersion != null) {
            buf.append(".");
            buf.append(this.incrementalVersion);
        }
        if (this.buildNumber != null) {
            buf.append("-");
            buf.append(this.buildNumber);
        } else if (this.qualifier != null) {
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(this.qualifier);
        }
        return buf.toString();
    }
}

