/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath.regex;

import java.io.Serializable;
import java.text.CharacterIterator;
import org.apache.xerces.impl.xpath.regex.BMPattern;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.Op;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.ParserForXMLSchema;
import org.apache.xerces.impl.xpath.regex.REUtil;
import org.apache.xerces.impl.xpath.regex.RangeToken;
import org.apache.xerces.impl.xpath.regex.RegexParser;
import org.apache.xerces.impl.xpath.regex.Token;

public class RegularExpression
implements Serializable {
    private static final long serialVersionUID = 3905241217112815923L;
    static final boolean DEBUG = false;
    String regex;
    int options;
    int nofparen;
    Token tokentree;
    boolean hasBackReferences = false;
    transient int minlength;
    transient Op operations = null;
    transient int numberOfClosures;
    transient Context context = null;
    transient RangeToken firstChar = null;
    transient String fixedString = null;
    transient int fixedStringOptions;
    transient BMPattern fixedStringTable = null;
    transient boolean fixedStringOnly = false;
    static final int IGNORE_CASE = 2;
    static final int SINGLE_LINE = 4;
    static final int MULTIPLE_LINES = 8;
    static final int EXTENDED_COMMENT = 16;
    static final int USE_UNICODE_CATEGORY = 32;
    static final int UNICODE_WORD_BOUNDARY = 64;
    static final int PROHIBIT_HEAD_CHARACTER_OPTIMIZATION = 128;
    static final int PROHIBIT_FIXED_STRING_OPTIMIZATION = 256;
    static final int XMLSCHEMA_MODE = 512;
    static final int SPECIAL_COMMA = 1024;
    private static final int WT_IGNORE = 0;
    private static final int WT_LETTER = 1;
    private static final int WT_OTHER = 2;
    static final int LINE_FEED = 10;
    static final int CARRIAGE_RETURN = 13;
    static final int LINE_SEPARATOR = 8232;
    static final int PARAGRAPH_SEPARATOR = 8233;

    private synchronized void compile(Token token) {
        if (this.operations != null) {
            return;
        }
        this.numberOfClosures = 0;
        this.operations = this.compile(token, null, false);
    }

    private Op compile(Token token, Op op, boolean bl) {
        Op op2;
        switch (token.type) {
            case 11: {
                op2 = Op.createDot();
                op2.next = op;
                break;
            }
            case 0: {
                op2 = Op.createChar(token.getChar());
                op2.next = op;
                break;
            }
            case 8: {
                op2 = Op.createAnchor(token.getChar());
                op2.next = op;
                break;
            }
            case 4: 
            case 5: {
                op2 = Op.createRange(token);
                op2.next = op;
                break;
            }
            case 1: {
                op2 = op;
                if (!bl) {
                    int n = token.size() - 1;
                    while (n >= 0) {
                        op2 = this.compile(token.getChild(n), op2, false);
                        --n;
                    }
                } else {
                    int n = 0;
                    while (n < token.size()) {
                        op2 = this.compile(token.getChild(n), op2, true);
                        ++n;
                    }
                }
                break;
            }
            case 2: {
                Op.UnionOp unionOp = Op.createUnion(token.size());
                int n = 0;
                while (n < token.size()) {
                    unionOp.addElement(this.compile(token.getChild(n), op, bl));
                    ++n;
                }
                op2 = unionOp;
                break;
            }
            case 3: 
            case 9: {
                Token token2 = token.getChild(0);
                int n = token.getMin();
                int n2 = token.getMax();
                if (n >= 0 && n == n2) {
                    op2 = op;
                    int n4 = 0;
                    while (n4 < n) {
                        op2 = this.compile(token2, op2, bl);
                        ++n4;
                    }
                } else {
                    if (n > 0 && n2 > 0) {
                        n2 -= n;
                    }
                    if (n2 > 0) {
                        op2 = op;
                        int n5 = 0;
                        while (n5 < n2) {
                            Op.ChildOp childOp = Op.createQuestion(token.type == 9);
                            childOp.next = op;
                            childOp.setChild(this.compile(token2, op2, bl));
                            op2 = childOp;
                            ++n5;
                        }
                    } else {
                        Op.ChildOp childOp = token.type == 9 ? Op.createNonGreedyClosure() : (token2.getMinLength() == 0 ? Op.createClosure(this.numberOfClosures++) : Op.createClosure(-1));
                        childOp.next = op;
                        childOp.setChild(this.compile(token2, childOp, bl));
                        op2 = childOp;
                    }
                    if (n <= 0) break;
                    int n6 = 0;
                    while (n6 < n) {
                        op2 = this.compile(token2, op2, bl);
                        ++n6;
                    }
                }
                break;
            }
            case 7: {
                op2 = op;
                break;
            }
            case 10: {
                op2 = Op.createString(token.getString());
                op2.next = op;
                break;
            }
            case 12: {
                op2 = Op.createBackReference(token.getReferenceNumber());
                op2.next = op;
                break;
            }
            case 6: {
                if (token.getParenNumber() == 0) {
                    op2 = this.compile(token.getChild(0), op, bl);
                    break;
                }
                if (bl) {
                    op = Op.createCapture(token.getParenNumber(), op);
                    op = this.compile(token.getChild(0), op, bl);
                    op2 = Op.createCapture(-token.getParenNumber(), op);
                    break;
                }
                op = Op.createCapture(-token.getParenNumber(), op);
                op = this.compile(token.getChild(0), op, bl);
                op2 = Op.createCapture(token.getParenNumber(), op);
                break;
            }
            case 20: {
                op2 = Op.createLook(20, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 21: {
                op2 = Op.createLook(21, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 22: {
                op2 = Op.createLook(22, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 23: {
                op2 = Op.createLook(23, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 24: {
                op2 = Op.createIndependent(op, this.compile(token.getChild(0), null, bl));
                break;
            }
            case 25: {
                op2 = Op.createModifier(op, this.compile(token.getChild(0), null, bl), ((Token.ModifierToken)token).getOptions(), ((Token.ModifierToken)token).getOptionsMask());
                break;
            }
            case 26: {
                Token.ConditionToken conditionToken = (Token.ConditionToken)token;
                int n = conditionToken.refNumber;
                Op op3 = conditionToken.condition == null ? null : this.compile(conditionToken.condition, null, bl);
                Op op4 = this.compile(conditionToken.yes, op, bl);
                Op op5 = conditionToken.no == null ? null : this.compile(conditionToken.no, op, bl);
                op2 = Op.createCondition(op, n, op3, op4, op5);
                break;
            }
            default: {
                throw new RuntimeException("Unknown token type: " + token.type);
            }
        }
        return op2;
    }

    public boolean matches(char[] cArray) {
        return this.matches(cArray, 0, cArray.length, (Match)null);
    }

    public boolean matches(char[] cArray, int n, int n2) {
        return this.matches(cArray, n, n2, (Match)null);
    }

    public boolean matches(char[] cArray, Match match2) {
        return this.matches(cArray, 0, cArray.length, match2);
    }

    public boolean matches(char[] cArray, int n, int n2, Match match2) {
        int n4;
        int n5;
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(cArray, n, n2, this.numberOfClosures);
        }
        if (match2 != null) {
            match2.setNumberOfGroups(this.nofparen);
            match2.setSource(cArray);
        } else if (this.hasBackReferences) {
            match2 = new Match();
            match2.setNumberOfGroups(this.nofparen);
        }
        context.match = match2;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchCharArray(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(cArray, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.inuse = false;
                return true;
            }
            context.inuse = false;
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(cArray, context.start, context.limit)) < 0) {
            context.inuse = false;
            return false;
        }
        n5 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = context.start;
                n8 = this.matchCharArray(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl = true;
                n4 = context.start;
                while (n4 <= n5) {
                    char c = cArray[n4];
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                    } else {
                        if (bl && 0 <= (n8 = this.matchCharArray(context, this.operations, n4, 1, this.options))) break;
                        bl = false;
                    }
                    ++n4;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                n4 = context.start;
                while (n4 <= n5) {
                    char c;
                    int n9 = cArray[n4];
                    if (!(!REUtil.isHighSurrogate(n9) || n4 + 1 >= context.limit ? !rangeToken.match(n9) && !rangeToken.match(c = Character.toUpperCase((char)n9)) && !rangeToken.match(Character.toLowerCase(c)) : !rangeToken.match(n9 = REUtil.composeFromSurrogates(n9, cArray[n4 + 1])))) {
                        n8 = this.matchCharArray(context, this.operations, n4, 1, this.options);
                        if (0 <= n8) break;
                    }
                    ++n4;
                }
            } else {
                n4 = context.start;
                while (n4 <= n5) {
                    int n10 = cArray[n4];
                    if (REUtil.isHighSurrogate(n10) && n4 + 1 < context.limit) {
                        n10 = REUtil.composeFromSurrogates(n10, cArray[n4 + 1]);
                    }
                    if (!rangeToken.match(n10) || 0 > (n8 = this.matchCharArray(context, this.operations, n4, 1, this.options))) {
                        ++n4;
                        continue;
                    }
                    break;
                }
            }
        } else {
            n4 = context.start;
            while (n4 <= n5) {
                n8 = this.matchCharArray(context, this.operations, n4, 1, this.options);
                if (0 > n8) {
                    ++n4;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n4);
                context.match.setEnd(0, n8);
            }
            context.inuse = false;
            return true;
        }
        context.inuse = false;
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private int matchCharArray(Context context, Op op, int n, int n2, int n4) {
        char[] cArray = context.charTarget;
        block32: while (true) {
            if (op == null) {
                return RegularExpression.isSet(n4, 512) && n != context.limit ? -1 : n;
            }
            if (n > context.limit || n < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || !RegularExpression.matchIgnoreCase(n5, cArray[n])) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n6 = n - 1;
                            if (n6 >= context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, cArray[n6])) {
                                return -1;
                            }
                            n = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || n5 != cArray[n]) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n7 = n - 1;
                            if (n7 >= context.limit || n7 < 0 || n5 != cArray[n7]) {
                                return -1;
                            }
                            n = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n5 = cArray[n];
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                                ++n;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, cArray[++n]);
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n;
                    } else {
                        n5 = n - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = cArray[n5];
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(cArray[--n5], n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c;
                    int n5;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n5 = cArray[n];
                        if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, cArray[++n]);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n5);
                                c = c2;
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n;
                    } else {
                        n5 = n - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = cArray[n5];
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(cArray[--n5], n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c3 = Character.toUpperCase((char)n9);
                                if (!rangeToken.match(c3) && !rangeToken.match(Character.toLowerCase(c3))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    char c;
                    int n5 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n != context.start && (n <= context.start || !RegularExpression.isEOLChar(cArray[n - 1])) : n != context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n == context.start || n > context.start && RegularExpression.isEOLChar(cArray[n - 1])) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n != context.limit && (n >= context.limit || !RegularExpression.isEOLChar(cArray[n])) : !(n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(cArray[n]) || n + 2 == context.limit && cArray[n] == '\r' && cArray[n + 1] == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(cArray[n]) || n + 2 == context.limit && cArray[n] == '\r' && cArray[n + 1] == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(cArray, context.start, context.limit, n, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            c = RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n, n4);
                            if (n10 != c) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n5 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(cArray, context.start, context.limit, n, n4);
                                int n12 = n5 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, context.start, context.limit, n, n4) == 1 && RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, context.start, context.limit, n, n4) == 2 && RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    char c = context.match.getBeginning(n13);
                    int n14 = context.match.getEnd(n13) - c;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n, context.limit, (int)c, n14)) {
                                return -1;
                            }
                            n += n14;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n - n14, context.limit, (int)c, n14)) {
                                return -1;
                            }
                            n -= n14;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n, context.limit, (int)c, n14)) {
                            return -1;
                        }
                        n += n14;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n - n14, context.limit, (int)c, n14)) {
                            return -1;
                        }
                        n -= n14;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string = op.getString();
                    char c = string.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n, context.limit, string, (int)c)) {
                                return -1;
                            }
                            n += c;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n - c, context.limit, string, (int)c)) {
                                return -1;
                            }
                            n -= c;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n, context.limit, string, (int)c)) {
                            return -1;
                        }
                        n += c;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n - c, context.limit, string, (int)c)) {
                            return -1;
                        }
                        n -= c;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    char c;
                    int n15 = op.getData();
                    if (n15 >= 0) {
                        c = context.offsets[n15];
                        if (c < '\u0000' || c != n) {
                            context.offsets[n15] = n;
                        } else {
                            context.offsets[n15] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    c = this.matchCharArray(context, op.getChild(), n, n2, n4);
                    if (n15 >= 0) {
                        context.offsets[n15] = -1;
                    }
                    if (c >= '\u0000') {
                        return c;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n16 = this.matchCharArray(context, op.getChild(), n, n2, n4);
                    if (n16 >= 0) {
                        return n16;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n17 = this.matchCharArray(context, op.next, n, n2, n4);
                    if (n17 >= 0) {
                        return n17;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    char c;
                    int n18 = 0;
                    while (n18 < op.size()) {
                        c = this.matchCharArray(context, op.elementAt(n18), n, n2, n4);
                        if (c >= '\u0000') {
                            return c;
                        }
                        ++n18;
                    }
                    return -1;
                }
                case 15: {
                    int n19;
                    char c = op.getData();
                    if (context.match != null && c > '\u0000') {
                        int n20 = context.match.getBeginning(c);
                        context.match.setBeginning(c, n);
                        n19 = this.matchCharArray(context, op.next, n, n2, n4);
                        if (n19 < 0) {
                            context.match.setBeginning(c, n20);
                        }
                        return n19;
                    }
                    if (context.match != null && c < '\u0000') {
                        char c4 = -c;
                        n19 = context.match.getEnd(c4);
                        context.match.setEnd(c4, n);
                        int n21 = this.matchCharArray(context, op.next, n, n2, n4);
                        if (n21 < 0) {
                            context.match.setEnd(c4, n19);
                        }
                        return n21;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchCharArray(context, op.getChild(), n, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchCharArray(context, op.getChild(), n, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchCharArray(context, op.getChild(), n, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchCharArray(context, op.getChild(), n, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n22 = this.matchCharArray(context, op.getChild(), n, n2, n4);
                    if (n22 < 0) {
                        return n22;
                    }
                    n = n22;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n23 = n4;
                    n23 |= op.getData();
                    int n19 = this.matchCharArray(context, op.getChild(), n, n2, n23 &= ~op.getData2());
                    if (n19 < 0) {
                        return n19;
                    }
                    n = n19;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op;
                    int n19 = 0;
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        n19 = context.match.getBeginning(conditionOp.refNumber) >= 0 && context.match.getEnd(conditionOp.refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n24 = n19 = 0 <= this.matchCharArray(context, conditionOp.condition, n, n2, n4) ? 1 : 0;
                    }
                    if (n19 != 0) {
                        op = conditionOp.yes;
                        continue block32;
                    }
                    if (conditionOp.no != null) {
                        op = conditionOp.no;
                        continue block32;
                    }
                    op = conditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(char[] cArray, int n, int n2, int n4, int n5) {
        int n6 = RegularExpression.getWordType(cArray, n, n2, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(cArray, n, n2, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(char[] cArray, int n, int n2, int n4, int n5) {
        if (n4 < n || n4 >= n2) {
            return 2;
        }
        return RegularExpression.getWordType0(cArray[n4], n5);
    }

    private static final boolean regionMatches(char[] cArray, int n, int n2, String string, int n4) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            if (cArray[n++] == string.charAt(n5++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(char[] cArray, int n, int n2, int n4, int n5) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            if (cArray[n++] == cArray[n6++]) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n, int n2, String string, int n4) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n++]) == (c3 = string.charAt(n5++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n, int n2, int n4, int n5) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n++]) == (c3 = cArray[n6++]) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(String string) {
        return this.matches(string, 0, string.length(), (Match)null);
    }

    public boolean matches(String string, int n, int n2) {
        return this.matches(string, n, n2, (Match)null);
    }

    public boolean matches(String string, Match match2) {
        return this.matches(string, 0, string.length(), match2);
    }

    public boolean matches(String string, int n, int n2, Match match2) {
        int n4;
        int n5;
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(string, n, n2, this.numberOfClosures);
        }
        if (match2 != null) {
            match2.setNumberOfGroups(this.nofparen);
            match2.setSource(string);
        } else if (this.hasBackReferences) {
            match2 = new Match();
            match2.setNumberOfGroups(this.nofparen);
        }
        context.match = match2;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchString(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(string, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.inuse = false;
                return true;
            }
            context.inuse = false;
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(string, context.start, context.limit)) < 0) {
            context.inuse = false;
            return false;
        }
        n5 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = context.start;
                n8 = this.matchString(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl = true;
                n4 = context.start;
                while (n4 <= n5) {
                    char c = string.charAt(n4);
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                    } else {
                        if (bl && 0 <= (n8 = this.matchString(context, this.operations, n4, 1, this.options))) break;
                        bl = false;
                    }
                    ++n4;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                n4 = context.start;
                while (n4 <= n5) {
                    char c;
                    int n9 = string.charAt(n4);
                    if (!(!REUtil.isHighSurrogate(n9) || n4 + 1 >= context.limit ? !rangeToken.match(n9) && !rangeToken.match(c = Character.toUpperCase((char)n9)) && !rangeToken.match(Character.toLowerCase(c)) : !rangeToken.match(n9 = REUtil.composeFromSurrogates(n9, string.charAt(n4 + 1))))) {
                        n8 = this.matchString(context, this.operations, n4, 1, this.options);
                        if (0 <= n8) break;
                    }
                    ++n4;
                }
            } else {
                n4 = context.start;
                while (n4 <= n5) {
                    int n10 = string.charAt(n4);
                    if (REUtil.isHighSurrogate(n10) && n4 + 1 < context.limit) {
                        n10 = REUtil.composeFromSurrogates(n10, string.charAt(n4 + 1));
                    }
                    if (!rangeToken.match(n10) || 0 > (n8 = this.matchString(context, this.operations, n4, 1, this.options))) {
                        ++n4;
                        continue;
                    }
                    break;
                }
            }
        } else {
            n4 = context.start;
            while (n4 <= n5) {
                n8 = this.matchString(context, this.operations, n4, 1, this.options);
                if (0 > n8) {
                    ++n4;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n4);
                context.match.setEnd(0, n8);
            }
            context.inuse = false;
            return true;
        }
        context.inuse = false;
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private int matchString(Context context, Op op, int n, int n2, int n4) {
        String string = context.strTarget;
        block32: while (true) {
            if (op == null) {
                return RegularExpression.isSet(n4, 512) && n != context.limit ? -1 : n;
            }
            if (n > context.limit || n < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || !RegularExpression.matchIgnoreCase(n5, string.charAt(n))) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n6 = n - 1;
                            if (n6 >= context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, string.charAt(n6))) {
                                return -1;
                            }
                            n = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || n5 != string.charAt(n)) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n7 = n - 1;
                            if (n7 >= context.limit || n7 < 0 || n5 != string.charAt(n7)) {
                                return -1;
                            }
                            n = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n5 = string.charAt(n);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                                ++n;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, string.charAt(++n));
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n;
                    } else {
                        n5 = n - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = string.charAt(n5);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(string.charAt(--n5), n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c;
                    int n5;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n5 = string.charAt(n);
                        if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, string.charAt(++n));
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n5);
                                c = c2;
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n;
                    } else {
                        n5 = n - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = string.charAt(n5);
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(string.charAt(--n5), n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c3 = Character.toUpperCase((char)n9);
                                if (!rangeToken.match(c3) && !rangeToken.match(Character.toLowerCase(c3))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    char c;
                    int n5 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n != context.start && (n <= context.start || !RegularExpression.isEOLChar(string.charAt(n - 1))) : n != context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n == context.start || n > context.start && RegularExpression.isEOLChar(string.charAt(n - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n != context.limit && (n >= context.limit || !RegularExpression.isEOLChar(string.charAt(n))) : !(n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(string.charAt(n)) || n + 2 == context.limit && string.charAt(n) == '\r' && string.charAt(n + 1) == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(string.charAt(n)) || n + 2 == context.limit && string.charAt(n) == '\r' && string.charAt(n + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(string, context.start, context.limit, n, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            c = RegularExpression.getPreviousWordType(string, context.start, context.limit, n, n4);
                            if (n10 != c) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n5 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(string, context.start, context.limit, n, n4);
                                int n12 = n5 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(string, context.start, context.limit, n, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string, context.start, context.limit, n, n4) == 1 && RegularExpression.getPreviousWordType(string, context.start, context.limit, n, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string, context.start, context.limit, n, n4) == 2 && RegularExpression.getPreviousWordType(string, context.start, context.limit, n, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    char c = context.match.getBeginning(n13);
                    int n14 = context.match.getEnd(n13) - c;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(string, n, context.limit, (int)c, n14)) {
                                return -1;
                            }
                            n += n14;
                        } else {
                            if (!RegularExpression.regionMatches(string, n - n14, context.limit, (int)c, n14)) {
                                return -1;
                            }
                            n -= n14;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n, context.limit, (int)c, n14)) {
                            return -1;
                        }
                        n += n14;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n - n14, context.limit, (int)c, n14)) {
                            return -1;
                        }
                        n -= n14;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string2 = op.getString();
                    char c = string2.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(string, n, context.limit, string2, (int)c)) {
                                return -1;
                            }
                            n += c;
                        } else {
                            if (!RegularExpression.regionMatches(string, n - c, context.limit, string2, (int)c)) {
                                return -1;
                            }
                            n -= c;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n, context.limit, string2, (int)c)) {
                            return -1;
                        }
                        n += c;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n - c, context.limit, string2, (int)c)) {
                            return -1;
                        }
                        n -= c;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    char c;
                    int n15 = op.getData();
                    if (n15 >= 0) {
                        c = context.offsets[n15];
                        if (c < '\u0000' || c != n) {
                            context.offsets[n15] = n;
                        } else {
                            context.offsets[n15] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    c = this.matchString(context, op.getChild(), n, n2, n4);
                    if (n15 >= 0) {
                        context.offsets[n15] = -1;
                    }
                    if (c >= '\u0000') {
                        return c;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n16 = this.matchString(context, op.getChild(), n, n2, n4);
                    if (n16 >= 0) {
                        return n16;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n17 = this.matchString(context, op.next, n, n2, n4);
                    if (n17 >= 0) {
                        return n17;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    char c;
                    int n18 = 0;
                    while (n18 < op.size()) {
                        c = this.matchString(context, op.elementAt(n18), n, n2, n4);
                        if (c >= '\u0000') {
                            return c;
                        }
                        ++n18;
                    }
                    return -1;
                }
                case 15: {
                    int n19;
                    char c = op.getData();
                    if (context.match != null && c > '\u0000') {
                        int n20 = context.match.getBeginning(c);
                        context.match.setBeginning(c, n);
                        n19 = this.matchString(context, op.next, n, n2, n4);
                        if (n19 < 0) {
                            context.match.setBeginning(c, n20);
                        }
                        return n19;
                    }
                    if (context.match != null && c < '\u0000') {
                        char c4 = -c;
                        n19 = context.match.getEnd(c4);
                        context.match.setEnd(c4, n);
                        int n21 = this.matchString(context, op.next, n, n2, n4);
                        if (n21 < 0) {
                            context.match.setEnd(c4, n19);
                        }
                        return n21;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchString(context, op.getChild(), n, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchString(context, op.getChild(), n, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchString(context, op.getChild(), n, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchString(context, op.getChild(), n, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n22 = this.matchString(context, op.getChild(), n, n2, n4);
                    if (n22 < 0) {
                        return n22;
                    }
                    n = n22;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n23 = n4;
                    n23 |= op.getData();
                    int n19 = this.matchString(context, op.getChild(), n, n2, n23 &= ~op.getData2());
                    if (n19 < 0) {
                        return n19;
                    }
                    n = n19;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op;
                    int n19 = 0;
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        n19 = context.match.getBeginning(conditionOp.refNumber) >= 0 && context.match.getEnd(conditionOp.refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n24 = n19 = 0 <= this.matchString(context, conditionOp.condition, n, n2, n4) ? 1 : 0;
                    }
                    if (n19 != 0) {
                        op = conditionOp.yes;
                        continue block32;
                    }
                    if (conditionOp.no != null) {
                        op = conditionOp.no;
                        continue block32;
                    }
                    op = conditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(String string, int n, int n2, int n4, int n5) {
        int n6 = RegularExpression.getWordType(string, n, n2, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(string, n, n2, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(String string, int n, int n2, int n4, int n5) {
        if (n4 < n || n4 >= n2) {
            return 2;
        }
        return RegularExpression.getWordType0(string.charAt(n4), n5);
    }

    private static final boolean regionMatches(String string, int n, int n2, String string2, int n4) {
        if (n2 - n < n4) {
            return false;
        }
        return string.regionMatches(n, string2, 0, n4);
    }

    private static final boolean regionMatches(String string, int n, int n2, int n4, int n5) {
        if (n2 - n < n5) {
            return false;
        }
        return string.regionMatches(n, string, n4, n5);
    }

    private static final boolean regionMatchesIgnoreCase(String string, int n, int n2, String string2, int n4) {
        return string.regionMatches(true, n, string2, 0, n4);
    }

    private static final boolean regionMatchesIgnoreCase(String string, int n, int n2, int n4, int n5) {
        if (n2 - n < n5) {
            return false;
        }
        return string.regionMatches(true, n, string, n4, n5);
    }

    public boolean matches(CharacterIterator characterIterator) {
        return this.matches(characterIterator, (Match)null);
    }

    public boolean matches(CharacterIterator characterIterator, Match match2) {
        int n;
        int n2;
        int n4 = characterIterator.getBeginIndex();
        int n5 = characterIterator.getEndIndex();
        RegularExpression regularExpression = this;
        synchronized (regularExpression) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        Context context = null;
        Context context2 = this.context;
        synchronized (context2) {
            context = this.context.inuse ? new Context() : this.context;
            context.reset(characterIterator, n4, n5, this.numberOfClosures);
        }
        if (match2 != null) {
            match2.setNumberOfGroups(this.nofparen);
            match2.setSource(characterIterator);
        } else if (this.hasBackReferences) {
            match2 = new Match();
            match2.setNumberOfGroups(this.nofparen);
        }
        context.match = match2;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchCharacterIterator(context, this.operations, context.start, 1, this.options);
            if (n6 == context.limit) {
                if (context.match != null) {
                    context.match.setBeginning(0, context.start);
                    context.match.setEnd(0, n6);
                }
                context.inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(characterIterator, context.start, context.limit);
            if (n7 >= 0) {
                if (context.match != null) {
                    context.match.setBeginning(0, n7);
                    context.match.setEnd(0, n7 + this.fixedString.length());
                }
                context.inuse = false;
                return true;
            }
            context.inuse = false;
            return false;
        }
        if (this.fixedString != null && (n2 = this.fixedStringTable.matches(characterIterator, context.start, context.limit)) < 0) {
            context.inuse = false;
            return false;
        }
        n2 = context.limit - this.minlength;
        int n8 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n = context.start;
                n8 = this.matchCharacterIterator(context, this.operations, context.start, 1, this.options);
            } else {
                boolean bl = true;
                n = context.start;
                while (n <= n2) {
                    char c = characterIterator.setIndex(n);
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                    } else {
                        if (bl && 0 <= (n8 = this.matchCharacterIterator(context, this.operations, n, 1, this.options))) break;
                        bl = false;
                    }
                    ++n;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                n = context.start;
                while (n <= n2) {
                    char c;
                    int n9 = characterIterator.setIndex(n);
                    if (!(!REUtil.isHighSurrogate(n9) || n + 1 >= context.limit ? !rangeToken.match(n9) && !rangeToken.match(c = Character.toUpperCase((char)n9)) && !rangeToken.match(Character.toLowerCase(c)) : !rangeToken.match(n9 = REUtil.composeFromSurrogates(n9, characterIterator.setIndex(n + 1))))) {
                        n8 = this.matchCharacterIterator(context, this.operations, n, 1, this.options);
                        if (0 <= n8) break;
                    }
                    ++n;
                }
            } else {
                n = context.start;
                while (n <= n2) {
                    int n10 = characterIterator.setIndex(n);
                    if (REUtil.isHighSurrogate(n10) && n + 1 < context.limit) {
                        n10 = REUtil.composeFromSurrogates(n10, characterIterator.setIndex(n + 1));
                    }
                    if (!rangeToken.match(n10) || 0 > (n8 = this.matchCharacterIterator(context, this.operations, n, 1, this.options))) {
                        ++n;
                        continue;
                    }
                    break;
                }
            }
        } else {
            n = context.start;
            while (n <= n2) {
                n8 = this.matchCharacterIterator(context, this.operations, n, 1, this.options);
                if (0 > n8) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        if (n8 >= 0) {
            if (context.match != null) {
                context.match.setBeginning(0, n);
                context.match.setEnd(0, n8);
            }
            context.inuse = false;
            return true;
        }
        context.inuse = false;
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private int matchCharacterIterator(Context context, Op op, int n, int n2, int n4) {
        CharacterIterator characterIterator = context.ciTarget;
        block32: while (true) {
            if (op == null) {
                return RegularExpression.isSet(n4, 512) && n != context.limit ? -1 : n;
            }
            if (n > context.limit || n < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || !RegularExpression.matchIgnoreCase(n5, characterIterator.setIndex(n))) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n6 = n - 1;
                            if (n6 >= context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, characterIterator.setIndex(n6))) {
                                return -1;
                            }
                            n = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || n5 != characterIterator.setIndex(n)) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n7 = n - 1;
                            if (n7 >= context.limit || n7 < 0 || n5 != characterIterator.setIndex(n7)) {
                                return -1;
                            }
                            n = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n5 = characterIterator.setIndex(n);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                                ++n;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, characterIterator.setIndex(++n));
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n;
                    } else {
                        n5 = n - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = characterIterator.setIndex(n5);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n5), n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c;
                    int n5;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n5 = characterIterator.setIndex(n);
                        if (REUtil.isHighSurrogate(n5) && n + 1 < context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, characterIterator.setIndex(++n));
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n5);
                                c = c2;
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n;
                    } else {
                        n5 = n - 1;
                        if (n5 >= context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = characterIterator.setIndex(n5);
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n5), n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c3 = Character.toUpperCase((char)n9);
                                if (!rangeToken.match(c3) && !rangeToken.match(Character.toLowerCase(c3))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    char c;
                    int n5 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n != context.start && (n <= context.start || !RegularExpression.isEOLChar(characterIterator.setIndex(n - 1))) : n != context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n == context.start || n > context.start && RegularExpression.isEOLChar(characterIterator.setIndex(n - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n != context.limit && (n >= context.limit || !RegularExpression.isEOLChar(characterIterator.setIndex(n))) : !(n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n)) || n + 2 == context.limit && characterIterator.setIndex(n) == '\r' && characterIterator.setIndex(n + 1) == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n)) || n + 2 == context.limit && characterIterator.setIndex(n) == '\r' && characterIterator.setIndex(n + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(characterIterator, context.start, context.limit, n, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            c = RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n, n4);
                            if (n10 != c) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n5 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(characterIterator, context.start, context.limit, n, n4);
                                int n12 = n5 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, context.start, context.limit, n, n4) == 1 && RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, context.start, context.limit, n, n4) == 2 && RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    char c = context.match.getBeginning(n13);
                    int n14 = context.match.getEnd(n13) - c;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n, context.limit, (int)c, n14)) {
                                return -1;
                            }
                            n += n14;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n - n14, context.limit, (int)c, n14)) {
                                return -1;
                            }
                            n -= n14;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n, context.limit, (int)c, n14)) {
                            return -1;
                        }
                        n += n14;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n - n14, context.limit, (int)c, n14)) {
                            return -1;
                        }
                        n -= n14;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string = op.getString();
                    char c = string.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n, context.limit, string, (int)c)) {
                                return -1;
                            }
                            n += c;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n - c, context.limit, string, (int)c)) {
                                return -1;
                            }
                            n -= c;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n, context.limit, string, (int)c)) {
                            return -1;
                        }
                        n += c;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n - c, context.limit, string, (int)c)) {
                            return -1;
                        }
                        n -= c;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    char c;
                    int n15 = op.getData();
                    if (n15 >= 0) {
                        c = context.offsets[n15];
                        if (c < '\u0000' || c != n) {
                            context.offsets[n15] = n;
                        } else {
                            context.offsets[n15] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    c = this.matchCharacterIterator(context, op.getChild(), n, n2, n4);
                    if (n15 >= 0) {
                        context.offsets[n15] = -1;
                    }
                    if (c >= '\u0000') {
                        return c;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n16 = this.matchCharacterIterator(context, op.getChild(), n, n2, n4);
                    if (n16 >= 0) {
                        return n16;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n17 = this.matchCharacterIterator(context, op.next, n, n2, n4);
                    if (n17 >= 0) {
                        return n17;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    char c;
                    int n18 = 0;
                    while (n18 < op.size()) {
                        c = this.matchCharacterIterator(context, op.elementAt(n18), n, n2, n4);
                        if (c >= '\u0000') {
                            return c;
                        }
                        ++n18;
                    }
                    return -1;
                }
                case 15: {
                    int n19;
                    char c = op.getData();
                    if (context.match != null && c > '\u0000') {
                        int n20 = context.match.getBeginning(c);
                        context.match.setBeginning(c, n);
                        n19 = this.matchCharacterIterator(context, op.next, n, n2, n4);
                        if (n19 < 0) {
                            context.match.setBeginning(c, n20);
                        }
                        return n19;
                    }
                    if (context.match != null && c < '\u0000') {
                        char c4 = -c;
                        n19 = context.match.getEnd(c4);
                        context.match.setEnd(c4, n);
                        int n21 = this.matchCharacterIterator(context, op.next, n, n2, n4);
                        if (n21 < 0) {
                            context.match.setEnd(c4, n19);
                        }
                        return n21;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchCharacterIterator(context, op.getChild(), n, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchCharacterIterator(context, op.getChild(), n, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchCharacterIterator(context, op.getChild(), n, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchCharacterIterator(context, op.getChild(), n, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n22 = this.matchCharacterIterator(context, op.getChild(), n, n2, n4);
                    if (n22 < 0) {
                        return n22;
                    }
                    n = n22;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n23 = n4;
                    n23 |= op.getData();
                    int n19 = this.matchCharacterIterator(context, op.getChild(), n, n2, n23 &= ~op.getData2());
                    if (n19 < 0) {
                        return n19;
                    }
                    n = n19;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op;
                    int n19 = 0;
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        n19 = context.match.getBeginning(conditionOp.refNumber) >= 0 && context.match.getEnd(conditionOp.refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n24 = n19 = 0 <= this.matchCharacterIterator(context, conditionOp.condition, n, n2, n4) ? 1 : 0;
                    }
                    if (n19 != 0) {
                        op = conditionOp.yes;
                        continue block32;
                    }
                    if (conditionOp.no != null) {
                        op = conditionOp.no;
                        continue block32;
                    }
                    op = conditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(CharacterIterator characterIterator, int n, int n2, int n4, int n5) {
        int n6 = RegularExpression.getWordType(characterIterator, n, n2, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(characterIterator, n, n2, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(CharacterIterator characterIterator, int n, int n2, int n4, int n5) {
        if (n4 < n || n4 >= n2) {
            return 2;
        }
        return RegularExpression.getWordType0(characterIterator.setIndex(n4), n5);
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n, int n2, String string, int n4) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            if (characterIterator.setIndex(n++) == string.charAt(n5++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n, int n2, int n4, int n5) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            if (characterIterator.setIndex(n++) == characterIterator.setIndex(n6++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n, int n2, String string, int n4) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = characterIterator.setIndex(n++)) == (c3 = string.charAt(n5++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n, int n2, int n4, int n5) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = characterIterator.setIndex(n++)) == (c3 = characterIterator.setIndex(n6++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    void prepare() {
        Object object;
        int n;
        this.compile(this.tokentree);
        this.minlength = this.tokentree.getMinLength();
        this.firstChar = null;
        if (!RegularExpression.isSet(this.options, 128) && !RegularExpression.isSet(this.options, 512) && (n = this.tokentree.analyzeFirstCharacter((RangeToken)(object = Token.createRange()), this.options)) == 1) {
            ((RangeToken)object).compactRanges();
            this.firstChar = object;
        }
        if (this.operations != null && (this.operations.type == 6 || this.operations.type == 1) && this.operations.next == null) {
            this.fixedStringOnly = true;
            if (this.operations.type == 6) {
                this.fixedString = this.operations.getString();
            } else if (this.operations.getData() >= 65536) {
                this.fixedString = REUtil.decomposeToSurrogates(this.operations.getData());
            } else {
                object = new char[1];
                object[0] = (char)this.operations.getData();
                this.fixedString = new String((char[])object);
            }
            this.fixedStringOptions = this.options;
            this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
        } else if (!RegularExpression.isSet(this.options, 256) && !RegularExpression.isSet(this.options, 512)) {
            object = new Token.FixedStringContainer();
            this.tokentree.findFixedString((Token.FixedStringContainer)object, this.options);
            this.fixedString = ((Token.FixedStringContainer)object).token == null ? null : ((Token.FixedStringContainer)object).token.getString();
            this.fixedStringOptions = ((Token.FixedStringContainer)object).options;
            if (this.fixedString != null && this.fixedString.length() < 2) {
                this.fixedString = null;
            }
            if (this.fixedString != null) {
                this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
            }
        }
    }

    private static final boolean isSet(int n, int n2) {
        return (n & n2) == n2;
    }

    public RegularExpression(String string) throws ParseException {
        this.setPattern(string, null);
    }

    public RegularExpression(String string, String string2) throws ParseException {
        this.setPattern(string, string2);
    }

    RegularExpression(String string, Token token, int n, boolean bl, int n2) {
        this.regex = string;
        this.tokentree = token;
        this.nofparen = n;
        this.options = n2;
        this.hasBackReferences = bl;
    }

    public void setPattern(String string) throws ParseException {
        this.setPattern(string, this.options);
    }

    private void setPattern(String string, int n) throws ParseException {
        this.regex = string;
        this.options = n;
        RegexParser regexParser = RegularExpression.isSet(this.options, 512) ? new ParserForXMLSchema() : new RegexParser();
        this.tokentree = regexParser.parse(this.regex, this.options);
        this.nofparen = regexParser.parennumber;
        this.hasBackReferences = regexParser.hasBackReferences;
        this.operations = null;
        this.context = null;
    }

    public void setPattern(String string, String string2) throws ParseException {
        this.setPattern(string, REUtil.parseOptions(string2));
    }

    public String getPattern() {
        return this.regex;
    }

    public String toString() {
        return this.tokentree.toString(this.options);
    }

    public String getOptions() {
        return REUtil.createOptionString(this.options);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RegularExpression)) {
            return false;
        }
        RegularExpression regularExpression = (RegularExpression)object;
        return this.regex.equals(regularExpression.regex) && this.options == regularExpression.options;
    }

    boolean equals(String string, int n) {
        return this.regex.equals(string) && this.options == n;
    }

    public int hashCode() {
        return (this.regex + "/" + this.getOptions()).hashCode();
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    private static final int getWordType0(char c, int n) {
        if (!RegularExpression.isSet(n, 64)) {
            if (RegularExpression.isSet(n, 32)) {
                return Token.getRange("IsWord", true).match(c) ? 1 : 2;
            }
            return RegularExpression.isWordChar(c) ? 1 : 2;
        }
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
            case 6: 
            case 7: 
            case 16: {
                return 0;
            }
            case 15: {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 2;
    }

    private static final boolean isEOLChar(int n) {
        return n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    private static final boolean isWordChar(int n) {
        if (n == 95) {
            return true;
        }
        if (n < 48) {
            return false;
        }
        if (n > 122) {
            return false;
        }
        if (n <= 57) {
            return true;
        }
        if (n < 65) {
            return false;
        }
        if (n <= 90) {
            return true;
        }
        return n >= 97;
    }

    private static final boolean matchIgnoreCase(int n, int n2) {
        char c;
        if (n == n2) {
            return true;
        }
        if (n > 65535 || n2 > 65535) {
            return false;
        }
        char c2 = Character.toUpperCase((char)n);
        if (c2 == (c = Character.toUpperCase((char)n2))) {
            return true;
        }
        return Character.toLowerCase(c2) == Character.toLowerCase(c);
    }

    static final class Context {
        CharacterIterator ciTarget;
        String strTarget;
        char[] charTarget;
        int start;
        int limit;
        int length;
        Match match;
        boolean inuse = false;
        int[] offsets;

        Context() {
        }

        private void resetCommon(int n) {
            this.length = this.limit - this.start;
            this.inuse = true;
            this.match = null;
            if (this.offsets == null || this.offsets.length != n) {
                this.offsets = new int[n];
            }
            int n2 = 0;
            while (n2 < n) {
                this.offsets[n2] = -1;
                ++n2;
            }
        }

        void reset(CharacterIterator characterIterator, int n, int n2, int n4) {
            this.ciTarget = characterIterator;
            this.start = n;
            this.limit = n2;
            this.resetCommon(n4);
        }

        void reset(String string, int n, int n2, int n4) {
            this.strTarget = string;
            this.start = n;
            this.limit = n2;
            this.resetCommon(n4);
        }

        void reset(char[] cArray, int n, int n2, int n4) {
            this.charTarget = cArray;
            this.start = n;
            this.limit = n2;
            this.resetCommon(n4);
        }
    }
}

