/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECMultiplier;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.FixedPointUtil;

public class FixedPointCombMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        int n = FixedPointUtil.getCombSize(eCCurve);
        if (bigInteger.bitLength() > n) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        int n2 = this.getWidthForCombSize(n);
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint, n2);
        ECPoint[] eCPointArray = fixedPointPreCompInfo.getPreComp();
        int n4 = fixedPointPreCompInfo.getWidth();
        int n5 = (n + n4 - 1) / n4;
        ECPoint eCPoint2 = eCCurve.getInfinity();
        int n6 = n5 * n4 - 1;
        for (int i = 0; i < n5; ++i) {
            int n7 = 0;
            for (int j = n6 - i; j >= 0; j -= n5) {
                n7 <<= 1;
                if (!bigInteger.testBit(j)) continue;
                n7 |= 1;
            }
            eCPoint2 = eCPoint2.twicePlus(eCPointArray[n7]);
        }
        return eCPoint2;
    }

    protected int getWidthForCombSize(int n) {
        return n > 257 ? 6 : 5;
    }
}

